/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.events;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.util.RealmsTasks;
import java.io.IOException;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.OptionsScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.realms.RealmsScreenProxy;
import net.minecraftforge.client.ForgeIngameGui;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.anim.OldAnimation;
import xaero.common.gui.GuiEditMode;
import xaero.common.gui.GuiWidgetUpdateAll;
import xaero.common.settings.ModSettings;
import xaero.patreon.Patreon5;

public class ForgeEventHandler {
    public static final RenderGameOverlayEvent.ElementType[] OVERLAY_LAYERS = new RenderGameOverlayEvent.ElementType[]{RenderGameOverlayEvent.ElementType.ALL, RenderGameOverlayEvent.ElementType.HELMET, RenderGameOverlayEvent.ElementType.HOTBAR, RenderGameOverlayEvent.ElementType.CROSSHAIRS, RenderGameOverlayEvent.ElementType.BOSSHEALTH, RenderGameOverlayEvent.ElementType.TEXT, RenderGameOverlayEvent.ElementType.POTION_ICONS, RenderGameOverlayEvent.ElementType.SUBTITLES, RenderGameOverlayEvent.ElementType.CHAT};
    private IXaeroMinimap modMain;
    private Screen lastGuiOpen;
    private Field realmsTaskField;
    private Field realmsTaskServerField;
    private boolean crosshairDisabledByThisMod = false;
    public RealmsServer latestRealm;

    public ForgeEventHandler(IXaeroMinimap modMain) {
        this.modMain = modMain;
    }

    @SubscribeEvent
    public void handleGuiOpenEvent(GuiOpenEvent event) {
        if (event.getGui() instanceof OptionsScreen) {
            if (!ModSettings.settingsButton) {
                return;
            }
            event.setGui((Screen)this.modMain.getGuiHelper().getMyOptions());
            try {
                this.modMain.getSettings().saveSettings();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (event.getGui() instanceof MainMenuScreen || event.getGui() instanceof MultiplayerScreen) {
            this.modMain.getSettings().resetServerSettings();
        }
        if (event.getGui() instanceof RealmsScreenProxy && ((RealmsScreenProxy)event.getGui()).getScreen() instanceof RealmsLongRunningMcoTaskScreen) {
            try {
                RealmsTasks.RealmsGetServerDetailsTask realmsTask;
                RealmsServer realm;
                RealmsLongRunningMcoTaskScreen realmsTaskScreen;
                Object task;
                if (this.realmsTaskField == null) {
                    this.realmsTaskField = RealmsLongRunningMcoTaskScreen.class.getDeclaredField("field_224248_l");
                    this.realmsTaskField.setAccessible(true);
                }
                if (this.realmsTaskServerField == null) {
                    this.realmsTaskServerField = RealmsTasks.RealmsGetServerDetailsTask.class.getDeclaredField("field_225007_b");
                    this.realmsTaskServerField.setAccessible(true);
                }
                if ((task = this.realmsTaskField.get(realmsTaskScreen = (RealmsLongRunningMcoTaskScreen)((RealmsScreenProxy)event.getGui()).getScreen())) instanceof RealmsTasks.RealmsGetServerDetailsTask && (realm = (RealmsServer)this.realmsTaskServerField.get(realmsTask = (RealmsTasks.RealmsGetServerDetailsTask)task)) != null && (this.latestRealm == null || realm.id != this.latestRealm.id)) {
                    this.latestRealm = realm;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.lastGuiOpen = event.getGui();
    }

    protected void handleRenderGameOverlayEventPreOverridable(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == OVERLAY_LAYERS[this.modMain.getSettings().renderLayerIndex]) {
            Minecraft.func_71410_x().field_195558_d.func_216522_a(Minecraft.field_142025_a);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            if (minimapSession != null) {
                this.modMain.getInterfaceRenderer().renderInterfaces(minimapSession, event.getPartialTicks());
                this.modMain.getInterfaces().getMinimapInterface().getWaypointsGuiRenderer().drawSetChange(minimapSession.getWaypointsManager(), Minecraft.func_71410_x().field_195558_d);
                if (ForgeIngameGui.renderCrosshairs && minimapSession.getMinimapProcessor().isEnlargedMap() && this.modMain.getSettings().centeredEnlarged) {
                    ForgeIngameGui.renderCrosshairs = false;
                    this.crosshairDisabledByThisMod = true;
                }
            }
            OldAnimation.tick();
        }
    }

    @SubscribeEvent
    public void handleRenderGameOverlayEventPre(RenderGameOverlayEvent.Pre event) {
        if (InputMappings.func_216506_a((long)Minecraft.func_71410_x().field_195558_d.func_198092_i(), (int)256)) {
            GuiEditMode.cancel(this.modMain.getInterfaces());
        }
        this.handleRenderGameOverlayEventPreOverridable(event);
    }

    @SubscribeEvent
    protected void handleRenderGameOverlayEventPost(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && this.crosshairDisabledByThisMod) {
            ForgeIngameGui.renderCrosshairs = true;
            this.crosshairDisabledByThisMod = false;
        }
    }

    @SubscribeEvent
    public void handleClientSendChatEvent(ClientChatEvent e) {
        if (e.getMessage().startsWith("xaero_waypoint_add:")) {
            String[] args = e.getMessage().split(":");
            e.setMessage("");
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getWaypointSharing().onWaypointAdd(args);
        } else if (e.getMessage().equals("/xaero_tp_anyway")) {
            e.setMessage("");
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getWaypointsManager().teleportAnyway();
        }
    }

    @SubscribeEvent
    public void handleClientChatReceivedEvent(ClientChatReceivedEvent e) {
        if (e.getMessage() == null) {
            return;
        }
        String text = e.getMessage().func_150254_d();
        if (text.contains("xaero_waypoint:") || text.contains("xaero-waypoint:")) {
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getWaypointSharing().onWaypointReceived(text, e);
        }
        if (text.contains("\u00a7c \u00a7r\u00a75 \u00a7r\u00a71 \u00a7r\u00a7f")) {
            String code = text.substring(text.indexOf("f") + 1);
            code = code.replace("\u00a7", "").replace("r", "").replace(" ", "");
            this.modMain.getSettings().resetServerSettings();
            this.modMain.getSettings();
            ModSettings.serverSettings &= Integer.parseInt(code);
            System.out.println("Code: " + code);
        }
    }

    @SubscribeEvent
    public void handleRenderWorldLastEvent(RenderWorldLastEvent event) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession != null && Minecraft.func_71410_x().field_71441_e == minimapSession.getMinimapProcessor().mainWorld) {
            this.modMain.getInterfaces().getMinimapInterface().getWaypointsIngameRenderer().render(minimapSession, event.getPartialTicks());
        }
    }

    @SubscribeEvent
    public void handleDrawScreenEventPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (Patreon5.needsNotification() && event.getGui() instanceof MainMenuScreen) {
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiWidgetUpdateAll(this.modMain));
        } else if (this.modMain.isOutdated()) {
            this.modMain.setOutdated(false);
        }
    }

    @SubscribeEvent
    public void handlePlayerSetSpawnEvent(PlayerSetSpawnEvent event) {
        XaeroMinimapSession minimapSession;
        if (event.getPlayer().field_70170_p instanceof ClientWorld && (minimapSession = XaeroMinimapSession.getCurrentSession()) != null) {
            minimapSession.getWaypointsManager().setCurrentSpawn(event.getNewSpawn());
        }
    }

    @SubscribeEvent
    public void handleRenderPlayerEventPost(RenderPlayerEvent.Post event) {
        if (this.modMain.getSupportMods().optifine) {
            Patreon5.renderCapeFallback(this.modMain.getFileLayoutID(), event);
        }
    }

    public Object getLastGuiOpen() {
        return this.lastGuiOpen;
    }
}

