/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CursorBox;
import xaero.common.gui.GuiDropDown;
import xaero.common.gui.IDropDownCallback;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.MyTinyButton;
import xaero.common.misc.Misc;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;

public class GuiEntityRadar
extends Screen
implements IDropDownCallback {
    private final int ROW_HEIGHT = 25;
    private IXaeroMinimap modMain;
    private Screen parentGuiScreen;
    private ArrayList<RadarCategory> categories;
    private boolean dropped;
    private String[] colorOptions;
    public CursorBox nameTooltip = new CursorBox("gui.xaero_box_entity_radar_names");
    public CursorBox iconTooltip = new CursorBox("gui.xaero_box_entity_radar_icons");

    protected GuiEntityRadar(IXaeroMinimap modMain, Screen par1GuiScreen) {
        super((ITextComponent)new TranslationTextComponent("gui.xaero_entity_radar", new Object[0]));
        this.modMain = modMain;
        this.parentGuiScreen = par1GuiScreen;
        this.categories = new ArrayList();
        this.colorOptions = this.createColorOptions();
        String[] playerOptions = new String[this.colorOptions.length + 1];
        String[] teamOptions = new String[this.colorOptions.length + 1];
        String[] tamedOptions = new String[this.colorOptions.length + 1];
        for (int i = 0; i < this.colorOptions.length; ++i) {
            playerOptions[i] = this.colorOptions[i];
            teamOptions[i + 1] = this.colorOptions[i];
            tamedOptions[i + 1] = this.colorOptions[i];
        }
        playerOptions[this.colorOptions.length] = "gui.xaero_team_colours";
        teamOptions[0] = "gui.xaero_players";
        tamedOptions[0] = "gui.xaero_untamed_color";
        ModSettings settings = modMain.getSettings();
        this.categories.add(new RadarCategory("gui.xaero_players", settings.playersColor != -1 ? settings.playersColor : this.colorOptions.length, settings.playerNames, settings.playerIcons, 3, this.categories.size(), playerOptions, ModOptions.PLAYERS){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.playersColor = this.color < GuiEntityRadar.this.colorOptions.length ? this.color : -1;
                settings.playerNames = this.names;
                settings.playerIcons = this.icons;
            }
        });
        this.categories.add(new RadarCategory("gui.xaero_other_teams", settings.otherTeamColor + 1, settings.otherTeamsNames, -4, 4, this.categories.size(), teamOptions, ModOptions.DISPLAY_OTHER_TEAM){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.otherTeamColor = this.color - 1;
                settings.otherTeamsNames = this.names;
            }
        });
        this.categories.add(new RadarCategory("gui.xaero_mobs", settings.mobsColor, settings.friendlyMobNames, settings.mobIcons, 3, this.categories.size(), this.colorOptions, ModOptions.MOBS){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.mobsColor = this.color;
                settings.friendlyMobNames = this.names;
                settings.mobIcons = this.icons;
            }
        });
        this.categories.add(new RadarCategory("gui.xaero_hostile", settings.hostileColor, settings.hostileMobNames, settings.hostileIcons, 3, this.categories.size(), this.colorOptions, ModOptions.HOSTILE){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.hostileColor = this.color;
                settings.hostileMobNames = this.names;
                settings.hostileIcons = this.icons;
            }
        });
        this.categories.add(new RadarCategory("gui.xaero_tamed", settings.tamedMobsColor + 1, settings.tamedMobNames, settings.tamedIcons, 4, this.categories.size(), tamedOptions, ModOptions.TAMED){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.tamedMobsColor = this.color - 1;
                settings.tamedMobNames = this.names;
                settings.tamedIcons = this.icons;
            }
        });
        this.categories.add(new RadarCategory("gui.xaero_items", settings.itemsColor, settings.itemNames, -1, 3, this.categories.size(), this.colorOptions, ModOptions.ITEMS){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.itemsColor = this.color;
                settings.itemNames = this.names;
            }
        });
        this.categories.add(new RadarCategory("gui.xaero_other", settings.otherColor, settings.otherNames, -1, 3, this.categories.size(), this.colorOptions, ModOptions.ENTITIES){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.otherColor = this.color;
                settings.otherNames = this.names;
            }
        });
    }

    private String[] createColorOptions() {
        String[] options = new String[ModSettings.ENCHANT_COLOR_NAMES.length];
        for (int i = 0; i < options.length; ++i) {
            options[i] = i == 0 ? I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]) : "\u00a7" + ModSettings.ENCHANT_COLORS[i] + I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]);
        }
        return options;
    }

    public void init() {
        super.init();
        this.addButton((Widget)new MySmallButton(200, this.width / 2 - 155, this.height / 6 + 168, I18n.func_135052_a((String)"gui.xaero_confirm", (Object[])new Object[0]), b -> {
            ModSettings settings = this.modMain.getSettings();
            for (RadarCategory c : this.categories) {
                c.onConfirm(settings);
                c.onDisplayOptionConfirm(settings);
            }
            try {
                settings.saveSettings();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.minecraft.func_147108_a(this.parentGuiScreen);
        }));
        this.addButton((Widget)new MySmallButton(201, this.width / 2 + 5, this.height / 6 + 168, I18n.func_135052_a((String)"gui.xaero_cancel", (Object[])new Object[0]), b -> this.minecraft.func_147108_a(this.parentGuiScreen)));
        for (RadarCategory c : this.categories) {
            c.init();
        }
    }

    public void render(int par1, int par2, float par3) {
        this.renderBackground();
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 5, 0xFFFFFF);
        this.drawCenteredString(this.font, I18n.func_135052_a((String)"gui.xaero_entity_radar_type", (Object[])new Object[0]), this.width / 2 - 176, this.height / 12, -1);
        this.drawCenteredString(this.font, I18n.func_135052_a((String)"gui.xaero_entity_radar_color", (Object[])new Object[0]), this.width / 2 - 76, this.height / 12, -1);
        this.drawCenteredString(this.font, I18n.func_135052_a((String)"gui.xaero_entity_radar_visiblity", (Object[])new Object[0]), this.width / 2 + 24, this.height / 12, -1);
        this.drawCenteredString(this.font, I18n.func_135052_a((String)"gui.xaero_entity_radar_names", (Object[])new Object[0]), this.width / 2 + 100, this.height / 12, -1);
        this.drawCenteredString(this.font, I18n.func_135052_a((String)"gui.xaero_entity_radar_icons", (Object[])new Object[0]), this.width / 2 + 176, this.height / 12, -1);
        for (RadarCategory c : this.categories) {
            c.render(par1, par2, par3);
        }
        if (this.dropped) {
            super.render(0, 0, par3);
        } else {
            super.render(par1, par2, par3);
        }
        this.dropped = false;
        for (RadarCategory c : this.categories) {
            if (!c.onDropdownRender(par1, par2, par3, true)) continue;
            this.dropped = true;
        }
        for (RadarCategory c : this.categories) {
            c.onDropdownRender(par1, par2, par3, false);
        }
        for (int k = 0; k < this.buttons.size(); ++k) {
            Widget b = (Widget)this.buttons.get(k);
            if (!(b instanceof MyTinyButton)) continue;
            MyTinyButton optionWidget = (MyTinyButton)b;
            if (!optionWidget.active || optionWidget.getTooltip() == null || par1 < b.x || par2 < b.y || par1 >= b.x + b.getWidth() || par2 >= b.y + b.getHeight()) continue;
            optionWidget.getTooltip().drawBox(par1, par2, this.width, this.height);
        }
    }

    @Override
    public boolean onSelected(GuiDropDown menu, int selected) {
        for (RadarCategory c : this.categories) {
            if (!c.onDropdownSelect(menu, selected)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double par1, double par2, int par3) {
        for (RadarCategory c : this.categories) {
            if (!c.onClick(par1, par2, par3, false)) continue;
            return true;
        }
        for (RadarCategory c : this.categories) {
            if (!c.onClick(par1, par2, par3, true)) continue;
            return true;
        }
        return super.mouseClicked(par1, par2, par3);
    }

    public boolean mouseReleased(double par1, double par2, int par3) {
        for (RadarCategory c : this.categories) {
            c.onRelease(par1, par2, par3);
        }
        return super.mouseReleased(par1, par2, par3);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double wheel) {
        if ((int)wheel != 0) {
            int mouseXScaled = (int)(Misc.getMouseX(Minecraft.func_71410_x()) / Minecraft.func_71410_x().field_195558_d.func_198100_s());
            int mouseYScaled = (int)(Misc.getMouseY(Minecraft.func_71410_x()) / Minecraft.func_71410_x().field_195558_d.func_198100_s());
            for (RadarCategory c : this.categories) {
                if (!c.onScroll(mouseXScaled, mouseYScaled, wheel)) continue;
                return true;
            }
        }
        return super.mouseScrolled(mouseX, mouseY, wheel);
    }

    public abstract class RadarCategory {
        String name;
        int index;
        GuiDropDown dropdown;
        int color;
        int names;
        int icons;
        boolean display;
        boolean initialDisplay;
        int totalNames;
        String[] dropdownOptions;
        ModOptions displayOption;

        public RadarCategory(String name, int color, int names, int icons, int totalNames, int index, String[] dropdownOptions, ModOptions displayOption) {
            this.name = name;
            this.color = color;
            this.names = names;
            this.icons = icons;
            this.display = this.initialDisplay = GuiEntityRadar.this.modMain.getSettings().getClientBooleanValue(displayOption);
            this.index = index;
            this.dropdownOptions = dropdownOptions;
            this.displayOption = displayOption;
            this.totalNames = totalNames;
        }

        public void init() {
            this.dropdown = new GuiDropDown(this.dropdownOptions, GuiEntityRadar.this.width / 2 - 136, GuiEntityRadar.this.height / 12 + 20 + 25 * this.index, 120, this.color, GuiEntityRadar.this);
            GuiEntityRadar.this.addButton((Widget)new MyTinyButton(null, GuiEntityRadar.this.width / 2 - 13, GuiEntityRadar.this.height / 12 + 16 + 25 * this.index, ModOptions.MOBS, this.getDisplayButtonText(), this::onSettingClicked));
            GuiEntityRadar.this.addButton((Widget)new MyTinyButton(GuiEntityRadar.this.nameTooltip, GuiEntityRadar.this.width / 2 + 63, GuiEntityRadar.this.height / 12 + 16 + 25 * this.index, I18n.func_135052_a((String)ModSettings.ENTITY_NAMES_OPTIONS[this.names], (Object[])new Object[0]), b -> {
                this.names = (this.names + 1) % this.totalNames;
                b.setMessage(I18n.func_135052_a((String)ModSettings.ENTITY_NAMES_OPTIONS[this.names], (Object[])new Object[0]));
            }));
            int icons = this.icons;
            if (icons < 0) {
                icons = -icons - 1;
            }
            MyTinyButton iconsButton = new MyTinyButton(GuiEntityRadar.this.iconTooltip, GuiEntityRadar.this.width / 2 + 139, GuiEntityRadar.this.height / 12 + 16 + 25 * this.index, I18n.func_135052_a((String)ModSettings.ENTITY_ICONS_OPTIONS[icons], (Object[])new Object[0]), b -> {
                this.icons = (this.icons + 1) % this.totalNames;
                b.setMessage(I18n.func_135052_a((String)ModSettings.ENTITY_ICONS_OPTIONS[this.icons], (Object[])new Object[0]));
            });
            if (this.icons < 0) {
                iconsButton.active = false;
            }
            GuiEntityRadar.this.addButton((Widget)iconsButton);
        }

        public void render(int par1, int par2, float par3) {
            GuiEntityRadar.this.drawCenteredString(GuiEntityRadar.this.font, I18n.func_135052_a((String)this.name, (Object[])new Object[0]), GuiEntityRadar.this.width / 2 - 176, GuiEntityRadar.this.height / 12 + 22 + 25 * this.index, -5592406);
        }

        public boolean onDropdownRender(int par1, int par2, float par3, boolean closed) {
            if (closed == this.dropdown.isClosed()) {
                this.dropdown.drawButton(par1, par2, GuiEntityRadar.this.height);
                return false;
            }
            return true;
        }

        public boolean onDropdownSelect(GuiDropDown menu, int selected) {
            if (menu == this.dropdown) {
                this.color = selected;
                return true;
            }
            return false;
        }

        public boolean onClick(double par1, double par2, int par3, boolean closed) {
            if (closed == this.dropdown.isClosed() && this.dropdown.onDropDown((int)par1, (int)par2, GuiEntityRadar.this.height)) {
                this.dropdown.mouseClicked((int)par1, (int)par2, par3, GuiEntityRadar.this.height);
                return true;
            }
            this.dropdown.setClosed(true);
            return false;
        }

        public boolean onRelease(double par1, double par2, int par3) {
            this.dropdown.mouseReleased((int)par1, (int)par2, par3, GuiEntityRadar.this.height);
            return true;
        }

        public boolean onScroll(int mouseXScaled, int mouseYScaled, double wheel) {
            if (!this.dropdown.isClosed() && this.dropdown.onDropDown(mouseXScaled, mouseYScaled, GuiEntityRadar.this.height)) {
                this.dropdown.mouseScrolled((int)wheel, mouseXScaled, mouseYScaled, GuiEntityRadar.this.height);
                return true;
            }
            return false;
        }

        private void onSettingClicked(Button b) {
            this.display = !this.display;
            b.setMessage(this.getDisplayButtonText());
        }

        private String getDisplayButtonText() {
            String s = "";
            boolean serverSetting = GuiEntityRadar.this.modMain.getSettings().getBooleanValue(this.displayOption);
            s = s + ModSettings.getTranslation(this.display) + (serverSetting != this.initialDisplay ? "\u00a7e (" + ModSettings.getTranslation(serverSetting) + ")" : "");
            return s;
        }

        public void onDisplayOptionConfirm(ModSettings settings) {
            if (this.display != this.initialDisplay) {
                settings.setOptionValue(this.displayOption);
            }
        }

        public abstract void onConfirm(ModSettings var1);
    }
}

