/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.IOException;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.StringUtils;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiSettings;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.settings.ModOptions;

public class GuiSlimeSeed
extends GuiSettings {
    public TextFieldWidget seedTextField;
    private IXaeroMinimap modMain;
    private final String fullWorldID;

    public GuiSlimeSeed(IXaeroMinimap modMain, WaypointsManager waypointsManager, Screen parent) {
        super(modMain, (TextComponent)new TranslationTextComponent("gui.xaero_slime_chunks", new Object[0]), parent);
        this.modMain = modMain;
        this.options = new ModOptions[]{ModOptions.SLIME_CHUNKS, ModOptions.OPEN_SLIME_SETTINGS};
        this.fullWorldID = waypointsManager.getCurrentContainerAndWorldID();
    }

    @Override
    public void init() {
        super.init();
        this.seedTextField = new TextFieldWidget(this.font, this.width / 2 - 100, this.height / 7 + 68, 200, 20, I18n.func_135052_a((String)"gui.xaero_used_seed", (Object[])new Object[0]));
        this.seedTextField.func_146180_a("" + (this.modMain.getSettings().getSlimeChunksSeed(this.fullWorldID) == null ? "" : this.modMain.getSettings().getSlimeChunksSeed(this.fullWorldID)));
        this.children.add(this.seedTextField);
        this.minecraft.field_195559_v.func_197967_a(true);
    }

    @Override
    public void render(int mouseX, int mouseY, float partial) {
        super.render(mouseX, mouseY, partial);
        this.seedTextField.render(mouseX, mouseY, partial);
        this.drawCenteredString(this.font, I18n.func_135052_a((String)"gui.xaero_used_seed", (Object[])new Object[0]), this.width / 2, this.height / 7 + 55, 0xFFFFFF);
    }

    public void tick() {
        this.seedTextField.func_146178_a();
    }

    public boolean keyPressed(int par1, int par2, int par3) {
        boolean result = super.keyPressed(par1, par2, par3);
        if (par1 == 257) {
            ((Widget)this.buttons.get(0)).onClick(0.0, 0.0);
        }
        this.updateSlimeSeed();
        return result;
    }

    public boolean charTyped(char par1, int par2) {
        boolean result = super.charTyped(par1, par2);
        this.updateSlimeSeed();
        return result;
    }

    private void updateSlimeSeed() {
        String s = this.seedTextField.func_146179_b();
        if (!StringUtils.isEmpty((CharSequence)s)) {
            try {
                long j = Long.parseLong(s);
                this.modMain.getSettings().setSlimeChunksSeed(j, this.fullWorldID);
            }
            catch (NumberFormatException numberformatexception) {
                this.modMain.getSettings().setSlimeChunksSeed(s.hashCode(), this.fullWorldID);
            }
        }
        try {
            this.modMain.getSettings().saveSettings();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

