/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.io.FileUtils;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.graphics.CursorBox;
import xaero.common.gui.GuiTransfer;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.GuiWorldTpCommand;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.MyTinyButton;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointWorldRootContainer;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.settings.ModSettings;

public class GuiWaypointsOptions
extends Screen {
    Screen parent;
    private IXaeroMinimap modMain;
    private XaeroMinimapSession minimapSession;
    private WaypointsManager waypointsManager;
    private MySmallButton automaticButton;
    private MySmallButton subAutomaticButton;
    private MySmallButton deleteButton;
    private MySmallButton subDeleteButton;
    private MySmallButton connectButton;
    private boolean buttonTest;
    private WaypointWorld waypointWorld;
    private WaypointWorld automaticWaypointWorld;
    private WaypointWorldRootContainer rootContainer;
    private boolean teleportationOptionShown;
    private boolean selectedWorldIsConnected;
    public CursorBox mwTooltip = new CursorBox("gui.xaero_use_multiworld_tooltip");
    public CursorBox teleportationTooltip = new CursorBox("gui.xaero_teleportation_tooltip", "\u00a7c");
    public CursorBox connectionTooltip = new CursorBox("gui.xaero_world_connection_tooltip");

    public GuiWaypointsOptions(IXaeroMinimap modMain, XaeroMinimapSession minimapSession, Screen parent, WaypointWorld waypointWorld, String frozenAutoContainerID, String frozenAutoWorldID) {
        super((ITextComponent)new TranslationTextComponent("gui.xaero_options", new Object[0]));
        this.parent = parent;
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.waypointsManager = minimapSession.getWaypointsManager();
        this.waypointWorld = waypointWorld;
        this.rootContainer = waypointWorld.getContainer().getRootContainer();
        this.automaticWaypointWorld = this.waypointsManager.getWorld(frozenAutoContainerID, frozenAutoWorldID);
        this.teleportationOptionShown = this.rootContainer.isTeleportationEnabled();
    }

    public void init() {
        super.init();
        this.parent.resize(this.minecraft, this.width, this.height);
        this.selectedWorldIsConnected = this.rootContainer.getSubWorldConnections().isConnected(this.automaticWaypointWorld, this.waypointWorld);
        this.addButton((Widget)new MyTinyButton(this.width / 2 - 203, 32, I18n.func_135052_a((String)"gui.xaero_close", (Object[])new Object[0]), b -> this.actionPerformed(b, 5)));
        this.addButton((Widget)new MySmallButton(6, this.width / 2 - 203, 57, I18n.func_135052_a((String)"gui.xaero_transfer", (Object[])new Object[0]), b -> this.actionPerformed(b, 6)));
        this.automaticButton = new MySmallButton(7, this.width / 2 - 203, 82, I18n.func_135052_a((String)"gui.xaero_make_automatic", (Object[])new Object[0]), b -> this.actionPerformed(b, 7));
        this.addButton((Widget)this.automaticButton);
        this.subAutomaticButton = new MySmallButton(8, this.width / 2 - 203, 107, I18n.func_135052_a((String)"gui.xaero_make_multi_automatic", (Object[])new Object[0]), b -> this.actionPerformed(b, 8));
        this.addButton((Widget)this.subAutomaticButton);
        this.deleteButton = new MySmallButton(9, this.width / 2 - 203, 132, I18n.func_135052_a((String)"gui.xaero_delete_world", (Object[])new Object[0]), b -> this.actionPerformed(b, 9));
        this.addButton((Widget)this.deleteButton);
        this.subDeleteButton = new MySmallButton(10, this.width / 2 - 203, 157, I18n.func_135052_a((String)"gui.xaero_delete_multi_world", (Object[])new Object[0]), b -> this.actionPerformed(b, 10));
        this.addButton((Widget)this.subDeleteButton);
        this.addButton((Widget)new MySmallButton(11, this.width / 2 - 203, 182, I18n.func_135052_a((String)"gui.xaero_multiply_all_by_8", (Object[])new Object[0]), b -> this.actionPerformed(b, 11)));
        this.addButton((Widget)new MySmallButton(12, this.width / 2 - 203, 207, I18n.func_135052_a((String)"gui.xaero_divide_all_by_8", (Object[])new Object[0]), b -> this.actionPerformed(b, 12)));
        this.addButton((Widget)new MySmallButton(200, this.width / 2 + 53, 57, this.getConfigButtonName(0), b -> this.onConfigButtonClick((MySmallButton)b)));
        MySmallButton teleportationEnabledButton = (MySmallButton)this.addButton((Widget)new MySmallButton(201, this.width / 2 + 53, 82, this.getConfigButtonName(1), b -> this.onConfigButtonClick((MySmallButton)b)));
        teleportationEnabledButton.active = this.teleportationOptionShown;
        this.addButton((Widget)new MySmallButton(13, this.width / 2 + 53, 107, I18n.func_135052_a((String)"gui.xaero_world_teleport_command", (Object[])new Object[0]), b -> this.actionPerformed(b, 13)));
        this.connectButton = new MySmallButton(14, this.width / 2 + 53, 132, this.getConfigButtonName(4), b -> this.actionPerformed(b, 14));
        this.addButton((Widget)this.connectButton);
        this.connectButton.active = this.waypointsManager.isMultiplayer(this.rootContainer.getKey()) && this.waypointWorld.getContainer() != this.automaticWaypointWorld.getContainer() && this.rootContainer == this.automaticWaypointWorld.getContainer().getRootContainer();
        this.addButton((Widget)new MySmallButton(202, this.width / 2 + 53, 182, this.getConfigButtonName(2), b -> this.onConfigButtonClick((MySmallButton)b)));
        this.addButton((Widget)new MySmallButton(203, this.width / 2 + 53, 207, this.getConfigButtonName(3), b -> this.onConfigButtonClick((MySmallButton)b)));
    }

    private String getConfigButtonName(int buttonId) {
        switch (buttonId) {
            case 0: {
                return I18n.func_135052_a((String)"gui.xaero_use_multiworld", (Object[])new Object[0]) + ": " + ModSettings.getTranslation(this.rootContainer.isUsingMultiworldDetection());
            }
            case 1: {
                return I18n.func_135052_a((String)"gui.xaero_teleportation", (Object[])new Object[0]) + ": " + ModSettings.getTranslation(this.rootContainer.isTeleportationEnabled());
            }
            case 2: {
                return I18n.func_135052_a((String)"gui.xaero_sort", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)this.rootContainer.getSortType().optionName, (Object[])new Object[0]);
            }
            case 3: {
                return I18n.func_135052_a((String)"gui.xaero_sort_reversed", (Object[])new Object[0]) + ": " + ModSettings.getTranslation(this.rootContainer.isSortReversed());
            }
            case 4: {
                return this.selectedWorldIsConnected ? I18n.func_135052_a((String)"gui.xaero_disconnect_from_auto", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.xaero_connect_with_auto", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private void onConfigButtonClick(MySmallButton button) {
        this.buttonTest = true;
        WaypointWorldRootContainer wc = this.rootContainer;
        switch (button.getId() - 200) {
            case 0: {
                wc.setUsingMultiworldDetection(!this.rootContainer.isUsingMultiworldDetection());
                wc.setDefaultMultiworldId(null);
                break;
            }
            case 1: {
                wc.setTeleportationEnabled(!wc.isTeleportationEnabled());
                break;
            }
            case 2: {
                this.rootContainer.toggleSortType();
                this.parent.init(this.minecraft, this.width, this.height);
                break;
            }
            case 3: {
                this.rootContainer.toggleSortReversed();
                this.parent.init(this.minecraft, this.width, this.height);
            }
        }
        wc.saveConfig();
        button.setMessage(this.getConfigButtonName(button.getId() - 200));
    }

    public boolean mouseClicked(double par1, double par2, int par3) {
        this.buttonTest = false;
        boolean toReturn = super.mouseClicked(par1, par2, par3);
        if (!this.buttonTest) {
            this.minecraft.func_147108_a(this.parent);
        }
        return toReturn;
    }

    protected void actionPerformed(Button p_146284_1_, int id) {
        this.buttonTest = true;
        if (p_146284_1_.active) {
            switch (id) {
                case 5: {
                    this.minecraft.func_147108_a(this.parent);
                    break;
                }
                case 6: {
                    this.minecraft.func_147108_a((Screen)new GuiTransfer(this.modMain, this.minimapSession, this.parent));
                    break;
                }
                case 7: {
                    this.minecraft.func_147108_a((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (ITextComponent)new TranslationTextComponent("gui.xaero_make_automatic_msg1", new Object[0]), (ITextComponent)new TranslationTextComponent("gui.xaero_make_automatic_msg2", new Object[0])));
                    break;
                }
                case 8: {
                    this.minecraft.func_147108_a((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (ITextComponent)new TranslationTextComponent("gui.xaero_make_multi_automatic_msg1", new Object[0]), (ITextComponent)new TranslationTextComponent("gui.xaero_make_multi_automatic_msg2", new Object[0])));
                    break;
                }
                case 9: {
                    this.minecraft.func_147108_a((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (ITextComponent)new TranslationTextComponent("gui.xaero_delete_world_msg1", new Object[0]), (ITextComponent)new TranslationTextComponent("gui.xaero_delete_world_msg2", new Object[0])));
                    break;
                }
                case 10: {
                    this.minecraft.func_147108_a((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (ITextComponent)new TranslationTextComponent("gui.xaero_delete_multi_world_msg1", new Object[0]), (ITextComponent)new TranslationTextComponent("gui.xaero_delete_multi_world_msg2", new Object[0])));
                    break;
                }
                case 11: {
                    this.minecraft.func_147108_a((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (ITextComponent)new TranslationTextComponent("gui.xaero_multiply_msg1", new Object[0]), (ITextComponent)new TranslationTextComponent("gui.xaero_multiply_msg2", new Object[0])));
                    break;
                }
                case 12: {
                    this.minecraft.func_147108_a((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (ITextComponent)new TranslationTextComponent("gui.xaero_multiply_msg1", new Object[0]), (ITextComponent)new TranslationTextComponent("gui.xaero_divide_msg2", new Object[0])));
                    break;
                }
                case 13: {
                    this.minecraft.func_147108_a((Screen)new GuiWorldTpCommand(this.modMain, this, this.waypointWorld));
                    break;
                }
                case 14: {
                    WaypointWorldContainer autoContainer = this.automaticWaypointWorld.getContainer();
                    WaypointWorldContainer selectedContainer = this.waypointWorld.getContainer();
                    String autoWorldName = autoContainer.getFullName(this.automaticWaypointWorld.getId(), autoContainer.getSubName()) + " (auto)";
                    String selectedWorldName = selectedContainer.getFullName(this.waypointWorld.getId(), selectedContainer.getSubName());
                    String connectionDisplayString = autoWorldName + "   \u00a7e<=>\u00a7r   " + selectedWorldName;
                    if (this.selectedWorldIsConnected) {
                        this.minecraft.func_147108_a((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (ITextComponent)new TranslationTextComponent("gui.xaero_disconnect_from_auto_msg", new Object[0]), (ITextComponent)new StringTextComponent(connectionDisplayString)));
                        break;
                    }
                    this.minecraft.func_147108_a((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (ITextComponent)new TranslationTextComponent("gui.xaero_connect_with_auto_msg", new Object[0]), (ITextComponent)new StringTextComponent(connectionDisplayString)));
                }
            }
        }
    }

    public void confirmResult(boolean result, int id) {
        block30: {
            block29: {
                boolean differentRoot = this.isDifferentRootContainer();
                boolean differentSub = this.isDifferentSubWorld(differentRoot);
                boolean exitOptions = true;
                if (!result) break block29;
                switch (id) {
                    case 7: {
                        if (!differentRoot) break;
                        WaypointWorldRootContainer selected = this.rootContainer;
                        WaypointWorldRootContainer auto = (WaypointWorldRootContainer)this.waypointsManager.getWaypointMap().get(this.waypointsManager.getAutoRootContainerID());
                        if (selected == null || auto == null) break;
                        String buKey = selected.getKey();
                        this.waypointsManager.getWaypointMap().put(auto.getKey(), selected);
                        this.waypointsManager.getWaypointMap().put(buKey, auto);
                        selected.setKey(auto.getKey());
                        auto.setKey(buKey);
                        selected.updateConnectionsField(this.minimapSession);
                        auto.updateConnectionsField(this.minimapSession);
                        Path selectedPath = selected.getDirectory().toPath();
                        Path autoPath = auto.getDirectory().toPath();
                        Path tempFolder = this.modMain.getWaypointsFolder().toPath().resolve("temp_to_add");
                        try {
                            Files.createDirectories(tempFolder, new FileAttribute[0]);
                            Path selectedTemp = tempFolder.resolve(selectedPath.getFileName());
                            if (Files.exists(selectedPath, new LinkOption[0])) {
                                Files.move(selectedPath, selectedTemp, new CopyOption[0]);
                            }
                            if (Files.exists(autoPath, new LinkOption[0])) {
                                Files.move(autoPath, selectedPath, new CopyOption[0]);
                            }
                            if (Files.exists(selectedTemp, new LinkOption[0])) {
                                Files.move(selectedTemp, autoPath, new CopyOption[0]);
                            }
                            Files.deleteIfExists(tempFolder);
                        }
                        catch (Throwable e) {
                            this.modMain.getInterfaces().getMinimapInterface().setCrashedWith(e);
                        }
                        selected.loadConfig();
                        auto.loadConfig();
                        this.waypointsManager.setCustomWorldID(null);
                        this.waypointsManager.setCustomContainerID(null);
                        this.waypointsManager.updateWaypoints();
                        break;
                    }
                    case 8: {
                        if (!differentSub) break;
                        WaypointWorld autoWorld = this.automaticWaypointWorld;
                        WaypointWorld selectedWorld = this.waypointWorld;
                        try {
                            Path autoFile = this.modMain.getSettings().getWaypointsFile(autoWorld).toPath();
                            Path selectedFile = this.modMain.getSettings().getWaypointsFile(selectedWorld).toPath();
                            Path autoTempFile = autoFile.getParent().resolve("temp_to_add").resolve(autoFile.getFileName());
                            Files.createDirectories(autoTempFile.getParent(), new FileAttribute[0]);
                            if (!Files.exists(autoFile, new LinkOption[0])) {
                                Files.createFile(autoFile, new FileAttribute[0]);
                            }
                            Files.move(autoFile, autoTempFile, new CopyOption[0]);
                            if (!Files.exists(selectedFile, new LinkOption[0])) {
                                Files.createFile(selectedFile, new FileAttribute[0]);
                            }
                            Files.move(selectedFile, autoFile, new CopyOption[0]);
                            if (Files.exists(autoTempFile, new LinkOption[0])) {
                                Files.move(autoTempFile, selectedFile, new CopyOption[0]);
                            }
                            Files.deleteIfExists(autoTempFile.getParent());
                        }
                        catch (Throwable e) {
                            this.modMain.getInterfaces().getMinimapInterface().setCrashedWith(e);
                            break;
                        }
                        WaypointWorldContainer autoWc = autoWorld.getContainer();
                        WaypointWorldContainer selectedWc = selectedWorld.getContainer();
                        autoWorld.setContainer(selectedWc);
                        selectedWorld.setContainer(autoWc);
                        selectedWc.worlds.put(selectedWorld.getId(), autoWorld);
                        autoWc.worlds.put(autoWorld.getId(), selectedWorld);
                        String buSelected = selectedWorld.getId();
                        selectedWorld.setId(autoWorld.getId());
                        autoWorld.setId(buSelected);
                        this.rootContainer.getSubWorldConnections().swapConnections(autoWorld, selectedWorld);
                        this.rootContainer.saveConfig();
                        this.waypointsManager.setCustomWorldID(null);
                        this.waypointsManager.setCustomContainerID(null);
                        this.waypointsManager.updateWaypoints();
                        break;
                    }
                    case 9: {
                        if (!differentRoot) break;
                        String selectedRootContainerId = this.rootContainer.getKey();
                        try {
                            File directory = this.modMain.getWaypointsFolder().toPath().resolve(selectedRootContainerId).toFile();
                            if (directory.exists()) {
                                FileUtils.deleteDirectory((File)directory);
                            }
                        }
                        catch (Throwable e) {
                            this.modMain.getInterfaces().getMinimapInterface().setCrashedWith(e);
                            break;
                        }
                        this.waypointsManager.getWaypointMap().remove(selectedRootContainerId);
                        this.waypointsManager.setCustomWorldID(null);
                        this.waypointsManager.setCustomContainerID(null);
                        this.waypointsManager.updateWaypoints();
                        break;
                    }
                    case 10: {
                        if (!differentSub) break;
                        WaypointWorld selectedWorld = this.waypointWorld;
                        try {
                            Files.deleteIfExists(this.modMain.getSettings().getWaypointsFile(selectedWorld).toPath());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        selectedWorld.getContainer().worlds.remove(selectedWorld.getId());
                        selectedWorld.getContainer().removeName(selectedWorld.getId());
                        this.waypointsManager.setCustomWorldID(null);
                        this.waypointsManager.setCustomContainerID(null);
                        this.waypointsManager.updateWaypoints();
                        break;
                    }
                    case 11: {
                        this.multiplyWaypoints(this.waypointWorld, 8.0);
                        break;
                    }
                    case 12: {
                        this.multiplyWaypoints(this.waypointWorld, 0.125);
                        break;
                    }
                    case 14: {
                        if (!this.selectedWorldIsConnected) {
                            this.rootContainer.getSubWorldConnections().addConnection(this.automaticWaypointWorld, this.waypointWorld);
                        } else {
                            this.rootContainer.getSubWorldConnections().removeConnection(this.automaticWaypointWorld, this.waypointWorld);
                        }
                        this.rootContainer.saveConfig();
                    }
                }
                if (exitOptions) {
                    if (this.parent instanceof GuiWaypoints) {
                        this.minecraft.func_147108_a((Screen)new GuiWaypoints(this.modMain, this.minimapSession, ((GuiWaypoints)this.parent).getParentScreen()));
                    } else {
                        this.minecraft.func_147108_a(this.parent);
                    }
                }
                break block30;
            }
            this.minecraft.func_147108_a((Screen)this);
        }
    }

    private void multiplyWaypoints(WaypointWorld world, double factor) {
        HashMap<String, WaypointSet> sets = world.getSets();
        Iterator<WaypointSet> iter = sets.values().iterator();
        while (iter.hasNext()) {
            ArrayList<Waypoint> wpList = iter.next().getList();
            for (int i = 0; i < wpList.size(); ++i) {
                Waypoint wp = wpList.get(i);
                wp.setX((int)Math.floor((double)wp.getX() * factor));
                wp.setZ((int)Math.floor((double)wp.getZ() * factor));
            }
        }
        try {
            this.modMain.getSettings().saveWaypoints(world);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isDifferentRootContainer() {
        return this.waypointsManager.getAutoRootContainerID() != null && !this.waypointsManager.getAutoRootContainerID().equals(this.rootContainer.getKey());
    }

    private boolean isDifferentSubWorld(boolean differentRoot) {
        return !differentRoot && this.waypointWorld != this.automaticWaypointWorld;
    }

    public void render(int par1, int par2, float par3) {
        this.automaticButton.active = this.deleteButton.active = this.isDifferentRootContainer();
        this.subAutomaticButton.active = this.subDeleteButton.active = this.isDifferentSubWorld(this.automaticButton.active);
        this.parent.render(0, 0, par3);
        this.renderBackground();
        super.render(par1, par2, par3);
        for (int k = 0; k < this.buttons.size(); ++k) {
            Widget w = (Widget)this.buttons.get(k);
            if (!(w instanceof MySmallButton)) continue;
            MySmallButton b = (MySmallButton)w;
            if (par1 < b.x || par2 < b.y || par1 >= b.x + 150 || par2 >= b.y + 20) continue;
            if (b.getId() >= 200) {
                switch (b.getId() - 200) {
                    case 0: {
                        this.mwTooltip.drawBox(par1, par2, this.width, this.height);
                        break;
                    }
                    case 1: {
                        this.teleportationTooltip.drawBox(par1, par2, this.width, this.height);
                    }
                }
                continue;
            }
            if (b.getId() != 14 || !b.active) continue;
            this.connectionTooltip.drawBox(par1, par2, this.width, this.height);
        }
    }
}

