/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.blaze3d.platform.GlStateManager;
import java.lang.reflect.Field;
import java.nio.IntBuffer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EnderDragonModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.IHasHead;
import net.minecraft.client.renderer.entity.model.QuadrupedModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import xaero.common.exception.OpenGLException;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIconDefinitions;
import xaero.common.minimap.render.radar.EntityIconModelPartsRenderer;
import xaero.common.minimap.render.radar.custom.EntityIconCustomRenderer;

public class EntityIconPrerenderer {
    private static final RendererModel[] ONE_RENDERER_ARRAY = new RendererModel[1];
    private static final boolean TEST_ALL_FIELDS = false;
    private static ArrayList<String> failedFields = new ArrayList();
    private ImprovedFramebuffer modelRenderFramebuffer = new ImprovedFramebuffer(512, 512, true);
    private ImprovedFramebuffer iconRenderFramebuffer;
    private ImprovedFramebuffer iconScaleFramebuffer;
    private EntityIconModelPartsRenderer entityModelPartsRenderer;
    private float r;
    private float g;
    private float b;
    private float a;

    public EntityIconPrerenderer() {
        OpenGLException.checkGLError();
        this.iconRenderFramebuffer = new ImprovedFramebuffer(512, 512, false);
        OpenGLException.checkGLError();
        this.iconScaleFramebuffer = new ImprovedFramebuffer(64, 64, false);
        OpenGLException.checkGLError();
        GlStateManager.deleteTexture((int)this.iconScaleFramebuffer.getFramebufferTexture());
        OpenGLException.checkGLError();
        this.entityModelPartsRenderer = new EntityIconModelPartsRenderer();
        this.modelRenderFramebuffer.func_147612_c();
        OpenGLException.checkGLError();
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager.texImage2D((int)3553, (int)0, (int)32856, (int)this.modelRenderFramebuffer.field_147621_c, (int)this.modelRenderFramebuffer.field_147618_d, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GlStateManager.bindTexture((int)0);
        this.iconRenderFramebuffer.func_147612_c();
        GL11.glTexParameteri((int)3553, (int)33085, (int)3);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)3.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        if (!GL.getCapabilities().OpenGL30) {
            GL11.glTexParameteri((int)3553, (int)33169, (int)1);
        }
        GL11.glTexParameteri((int)3553, (int)10241, (int)9984);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager.texImage2D((int)3553, (int)0, (int)32856, (int)this.iconRenderFramebuffer.field_147621_c, (int)this.iconRenderFramebuffer.field_147618_d, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GlStateManager.bindTexture((int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void testField(ImmutableList<String> fields) throws NoSuchFieldException, SecurityException {
        boolean odd = true;
        boolean pairFirstFailed = false;
        String prevS = null;
        UnmodifiableIterator unmodifiableIterator = fields.iterator();
        while (unmodifiableIterator.hasNext()) {
            String s = (String)unmodifiableIterator.next();
            try {
                boolean bl = odd = !odd;
                if (!odd) {
                    pairFirstFailed = false;
                }
                boolean failed = false;
                if (!s.isEmpty()) {
                    String[] fieldArgs = s.split(";");
                    Class<?> c = null;
                    try {
                        c = Class.forName(fieldArgs[0]);
                    }
                    catch (ClassNotFoundException cnfe) {
                        System.out.println("Skipping testing a class: " + fieldArgs[0]);
                        prevS = s;
                        continue;
                    }
                    try {
                        c.getDeclaredField(fieldArgs[1]);
                    }
                    catch (Exception e) {
                        failed = true;
                    }
                } else {
                    failed = true;
                }
                if (failed) {
                    if (!odd) {
                        pairFirstFailed = true;
                    } else if (pairFirstFailed) {
                        failedFields.add(prevS);
                        failedFields.add(s);
                    }
                }
                prevS = s;
            }
            catch (Throwable throwable) {
                prevS = s;
                throw throwable;
            }
        }
        return;
    }

    public int prerender(EntityRenderer entityRenderer, Entity entity, Framebuffer defaultFramebuffer, MinimapRendererHelper helper) {
        ImprovedFramebuffer modelRenderFramebuffer = this.modelRenderFramebuffer;
        ImprovedFramebuffer iconRenderFramebuffer = this.iconRenderFramebuffer;
        ImprovedFramebuffer iconScaleFramebuffer = this.iconScaleFramebuffer;
        int finalIconSize = iconScaleFramebuffer.field_147621_c;
        modelRenderFramebuffer.func_147610_a(true);
        int farPlane = 500;
        GlStateManager.matrixMode((int)5889);
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
        GlStateManager.ortho((double)0.0, (double)finalIconSize, (double)0.0, (double)finalIconSize, (double)-1.0, (double)farPlane);
        GlStateManager.matrixMode((int)5888);
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
        if (Minecraft.func_71410_x().func_175598_ae().field_217783_c != null) {
            entityRenderer.func_76986_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        } else {
            System.out.println("Render info was null for entity " + entity.func_70022_Q());
        }
        GlStateManager.activeTexture((int)33985);
        GlStateManager.disableTexture();
        GlStateManager.activeTexture((int)33984);
        RenderHelper.func_74518_a();
        GlStateManager.disableAlphaTest();
        GlStateManager.disableBlend();
        GlStateManager.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.clear((int)16640, (boolean)Minecraft.field_142025_a);
        GlStateManager.enableBlend();
        GlStateManager.enableDepthTest();
        GlStateManager.depthFunc((int)515);
        GlStateManager.enableAlphaTest();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        this.a = 1.0f;
        this.b = 1.0f;
        this.g = 1.0f;
        this.r = 1.0f;
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)(finalIconSize / 2), (double)(finalIconSize / 2), (double)-450.0);
        GlStateManager.disableCull();
        GlStateManager.scalef((float)(finalIconSize / 2), (float)(finalIconSize / 2), (float)-1.0f);
        boolean renderedSomething = false;
        EntityModel entityModel = null;
        if (entityRenderer instanceof LivingRenderer) {
            entityModel = ((LivingRenderer)entityRenderer).func_217764_d();
        } else if (entityRenderer instanceof EnderDragonRenderer) {
            entityModel = new EnderDragonModel(0.0f);
        }
        if (entityModel != null) {
            EntityIconDefinitions.customTransformation(entityModel, entity, this);
            entityModel.func_212844_a_(entity, 0.0f, 0.0f, (float)entity.field_70173_aa, 0.0f, 0.0f, 0.0625f);
            entityModel.func_212843_a_(entity, 0.0f, 0.0f, 1.0f);
            renderedSomething = this.renderModel(entityRenderer, entityModel, (Entity)((LivingEntity)entity));
            EntityIconDefinitions.customPostRenderTransformation(entityModel, entity);
        }
        GlStateManager.enableCull();
        GlStateManager.popMatrix();
        modelRenderFramebuffer.func_147609_e();
        GlStateManager.enableBlend();
        RenderHelper.func_74518_a();
        GlStateManager.enableAlphaTest();
        GlStateManager.alphaFunc((int)516, (float)0.0f);
        int entityScaledIconTextureId = -1;
        if (renderedSomething) {
            iconRenderFramebuffer.func_147610_a(true);
            GlStateManager.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.clear((int)16384, (boolean)Minecraft.field_142025_a);
            GlStateManager.disableBlend();
            modelRenderFramebuffer.func_147612_c();
            GlStateManager.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            for (int shadowOffsetX = -1; shadowOffsetX < 2; ++shadowOffsetX) {
                for (int shadowOffsetY = -1; shadowOffsetY < 2; ++shadowOffsetY) {
                    if (shadowOffsetX == 0 && shadowOffsetY == 0) continue;
                    helper.drawMyTexturedModalRect(shadowOffsetX, finalIconSize + shadowOffsetY, 0, 0, finalIconSize, -finalIconSize, finalIconSize, finalIconSize);
                }
            }
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            helper.drawMyTexturedModalRect(0.0f, finalIconSize, 0, 0, finalIconSize, -finalIconSize, finalIconSize, finalIconSize);
            GlStateManager.enableBlend();
            iconRenderFramebuffer.func_147609_e();
            iconRenderFramebuffer.func_147612_c();
            iconRenderFramebuffer.generateMipmaps();
            GlStateManager.bindTexture((int)0);
            entityScaledIconTextureId = GlStateManager.genTexture();
            OpenGLException.checkGLError();
            GlStateManager.bindTexture((int)entityScaledIconTextureId);
            GL11.glTexParameteri((int)3553, (int)33085, (int)0);
            GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
            GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
            GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            OpenGLException.checkGLError();
            GlStateManager.texImage2D((int)3553, (int)0, (int)32856, (int)iconScaleFramebuffer.field_147621_c, (int)iconScaleFramebuffer.field_147618_d, (int)0, (int)32993, (int)32821, (IntBuffer)null);
            GlStateManager.bindTexture((int)0);
            OpenGLException.checkGLError();
            iconScaleFramebuffer.func_147610_a(true);
            iconScaleFramebuffer.setFramebufferTexture(entityScaledIconTextureId);
            iconScaleFramebuffer.func_147611_b();
            iconRenderFramebuffer.func_147612_c();
            GlStateManager.disableAlphaTest();
            GlStateManager.disableBlend();
            helper.drawMyTexturedModalRect(0.0f, finalIconSize, 0, 0, finalIconSize, -finalIconSize, finalIconSize, finalIconSize);
            GlStateManager.enableAlphaTest();
            GlStateManager.enableBlend();
            GlStateManager.bindTexture((int)0);
        }
        GlStateManager.popMatrix();
        GlStateManager.matrixMode((int)5889);
        GlStateManager.popMatrix();
        GlStateManager.matrixMode((int)5888);
        iconScaleFramebuffer.func_147609_e();
        defaultFramebuffer.func_147610_a(true);
        return entityScaledIconTextureId;
    }

    private boolean renderModel(EntityRenderer entityRenderer, EntityModel entityModel, Entity entity) {
        EntityIconCustomRenderer extraLayer;
        boolean forceFieldCheck = EntityIconDefinitions.forceFieldCheck(entityModel);
        boolean isChildBU = entityModel.field_217114_e;
        entityModel.field_217114_e = false;
        ArrayList<RendererModel> renderedModels = new ArrayList<RendererModel>();
        RendererModel mainPart = null;
        boolean fullModelIcon = EntityIconDefinitions.fullModelIcon(entityModel);
        ResourceLocation entityTexture = EntityIconDefinitions.getEntityTexture(entityRenderer, entity);
        if (entityTexture != null) {
            RendererModel headRenderer;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(entityTexture);
            if (!fullModelIcon && !forceFieldCheck && entityModel instanceof BipedModel) {
                mainPart = headRenderer = ((BipedModel)entityModel).field_78116_c;
                RendererModel headWearRenderer = ((BipedModel)entityModel).field_178720_f;
                this.entityModelPartsRenderer.renderPart(headRenderer, renderedModels, mainPart, this.r, this.g, this.b, this.a);
                this.entityModelPartsRenderer.renderPart(headWearRenderer, renderedModels, mainPart, this.r, this.g, this.b, this.a);
            } else if (!fullModelIcon && !forceFieldCheck && entityModel instanceof QuadrupedModel) {
                headRenderer = null;
                try {
                    headRenderer = EntityIconPrerenderer.handleDeclaredField(this.entityModelPartsRenderer.quadrupedHeadField, entityModel)[0];
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                if (headRenderer != null) {
                    mainPart = headRenderer;
                    this.entityModelPartsRenderer.renderPart(headRenderer, renderedModels, mainPart, this.r, this.g, this.b, this.a);
                }
            } else {
                if (!forceFieldCheck && entityModel instanceof IHasHead) {
                    mainPart = ((IHasHead)entityModel).func_205072_a();
                    this.entityModelPartsRenderer.renderPart(mainPart, renderedModels, mainPart, this.r, this.g, this.b, this.a);
                }
                if (mainPart == null) {
                    mainPart = this.searchSuperclassFields(entityModel, renderedModels, mainPart, EntityIconDefinitions.HEAD_HARDCODED_NAMES, true);
                }
                mainPart = this.searchSuperclassFields(entityModel, renderedModels, mainPart, fullModelIcon ? null : EntityIconDefinitions.HEAD_PARTS_HARDCODED_NAMES, false);
            }
        }
        if ((extraLayer = EntityIconDefinitions.getCustomLayer(entityRenderer, entity)) != null) {
            mainPart = extraLayer.render(this, entityRenderer, entity, entityModel, this.entityModelPartsRenderer, renderedModels, mainPart);
        }
        GlStateManager.bindTexture((int)0);
        entityModel.field_217114_e = isChildBU;
        return mainPart != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RendererModel[] handleDeclaredField(Field f, EntityModel entityModel) throws IllegalArgumentException, IllegalAccessException {
        boolean accessibleBU = f.isAccessible();
        try {
            f.setAccessible(true);
            Object fieldValue = f.get(entityModel);
            if (fieldValue instanceof RendererModel[]) {
                RendererModel[] rendererModelArray = (RendererModel[])fieldValue;
                return rendererModelArray;
            }
            EntityIconPrerenderer.ONE_RENDERER_ARRAY[0] = (RendererModel)fieldValue;
            RendererModel[] rendererModelArray = ONE_RENDERER_ARRAY;
            return rendererModelArray;
        }
        finally {
            f.setAccessible(accessibleBU);
        }
    }

    public RendererModel searchSuperclassFields(EntityModel entityModel, ArrayList<RendererModel> renderedModels, RendererModel mainPart, ImmutableList<String> filter, boolean justOne) {
        Class<?> modelClass = entityModel.getClass();
        while (modelClass != EntityModel.class) {
            Field[] declaredModelFields = modelClass.getDeclaredFields();
            mainPart = this.handleFields(entityModel, declaredModelFields, renderedModels, mainPart, filter, justOne);
            if ((!justOne || mainPart == null) && (modelClass = modelClass.getSuperclass()) != null) continue;
        }
        return mainPart;
    }

    public RendererModel handleFields(EntityModel entityModel, Field[] declaredModelFields, ArrayList<RendererModel> renderedModels, RendererModel mainPart, ImmutableList<String> filter, boolean justOne) {
        block7: for (Field f : declaredModelFields) {
            try {
                f.getType().asSubclass(RendererModel.class);
            }
            catch (ClassCastException cce) {
                try {
                    f.getType().asSubclass(RendererModel[].class);
                }
                catch (ClassCastException cce1) {
                    continue;
                }
            }
            try {
                RendererModel[] renderers;
                String comparisonName = f.getDeclaringClass().getName() + ";" + f.getName();
                if (filter != null && !filter.contains((Object)comparisonName)) continue;
                for (RendererModel mr : renderers = EntityIconPrerenderer.handleDeclaredField(f, entityModel)) {
                    if (mainPart == null) {
                        mainPart = mr;
                    }
                    this.entityModelPartsRenderer.renderPart(mr, renderedModels, mainPart, this.r, this.g, this.b, this.a);
                    if (justOne) break block7;
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return mainPart;
    }

    public void setRGBA(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }
}

