/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar.custom;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.resources.data.VillagerMetadataSection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.villager.IVillagerDataHolder;
import net.minecraft.entity.villager.IVillagerType;
import net.minecraft.resources.IResource;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import xaero.common.minimap.render.radar.custom.EntityIconCustomRenderer;
import xaero.common.minimap.render.radar.custom.IconRenderTypeCustomRenderer;
import xaero.common.minimap.render.radar.custom.MultiLayerIconCustomRenderer;

public class VillagerIconCustomRenderer
extends MultiLayerIconCustomRenderer {
    public VillagerIconCustomRenderer(String entityType) {
        super(Lists.newArrayList((Object[])new EntityIconCustomRenderer[]{new TypeLayer(entityType), new ProfessionLayer(entityType), new ProfessionLevelLayer(entityType)}));
    }

    private static ResourceLocation getTexture(String entityType, String textureType, ResourceLocation textureName) {
        if (textureName == null) {
            return null;
        }
        return new ResourceLocation(textureName.func_110624_b(), "textures/entity/" + entityType + "/" + textureType + "/" + textureName.func_110623_a() + ".png");
    }

    public static class ProfessionLevelLayer
    extends IconRenderTypeCustomRenderer {
        private String entityType;
        private static final Int2ObjectMap<ResourceLocation> levels = (Int2ObjectMap)Util.func_200696_a((Object)new Int2ObjectOpenHashMap(), map -> {
            map.put(1, (Object)new ResourceLocation("stone"));
            map.put(2, (Object)new ResourceLocation("iron"));
            map.put(3, (Object)new ResourceLocation("gold"));
            map.put(4, (Object)new ResourceLocation("emerald"));
            map.put(5, (Object)new ResourceLocation("diamond"));
        });

        public ProfessionLevelLayer(String entityType) {
            this.entityType = entityType;
        }

        @Override
        protected boolean preRender(EntityRenderer entityRenderer, Entity entity) {
            VillagerData villagerdata = ((IVillagerDataHolder)entity).func_213700_eh();
            VillagerProfession villagerprofession = villagerdata.func_221130_b();
            if (villagerprofession == VillagerProfession.field_221151_a || ((LivingEntity)entity).func_70631_g_()) {
                return false;
            }
            int level = villagerdata.func_221132_c();
            if (level > 5) {
                level = 5;
            } else if (level < 1) {
                level = 1;
            }
            ResourceLocation texture = VillagerIconCustomRenderer.getTexture(this.entityType, "profession_level", (ResourceLocation)ProfessionLevelLayer.levels.get(level));
            if (texture == null) {
                return false;
            }
            GlStateManager.enableBlend();
            GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            GlStateManager.enableAlphaTest();
            GlStateManager.alphaFunc((int)516, (float)0.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
            return true;
        }

        @Override
        protected void postRender(Entity entity) {
            GlStateManager.disableBlend();
            GlStateManager.disableAlphaTest();
            GlStateManager.alphaFunc((int)516, (float)0.1f);
        }
    }

    public static class ProfessionLayer
    extends IconRenderTypeCustomRenderer {
        private String entityType;

        public ProfessionLayer(String entityType) {
            this.entityType = entityType;
        }

        @Override
        protected boolean preRender(EntityRenderer entityRenderer, Entity entity) {
            VillagerData villagerdata = ((IVillagerDataHolder)entity).func_213700_eh();
            VillagerProfession villagerprofession = villagerdata.func_221130_b();
            if (villagerprofession == VillagerProfession.field_221151_a || ((LivingEntity)entity).func_70631_g_()) {
                return false;
            }
            ResourceLocation texture = VillagerIconCustomRenderer.getTexture(this.entityType, "profession", Registry.field_218370_L.func_177774_c((Object)villagerprofession));
            if (texture == null) {
                return false;
            }
            GlStateManager.enableBlend();
            GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            GlStateManager.enableAlphaTest();
            GlStateManager.alphaFunc((int)516, (float)0.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
            return true;
        }

        @Override
        protected void postRender(Entity entity) {
            GlStateManager.disableBlend();
            GlStateManager.disableAlphaTest();
            GlStateManager.alphaFunc((int)516, (float)0.1f);
        }
    }

    public static class TypeLayer
    extends IconRenderTypeCustomRenderer {
        private String entityType;

        public TypeLayer(String entityType) {
            this.entityType = entityType;
        }

        @Override
        protected boolean preRender(EntityRenderer entityRenderer, Entity entity) {
            Throwable throwable;
            VillagerData villagerdata = ((IVillagerDataHolder)entity).func_213700_eh();
            IVillagerType villagertype = villagerdata.func_221129_a();
            ResourceLocation typeTexture = VillagerIconCustomRenderer.getTexture(this.entityType, "type", Registry.field_218369_K.func_177774_c((Object)villagertype));
            ResourceLocation profTexture = VillagerIconCustomRenderer.getTexture(this.entityType, "profession", Registry.field_218370_L.func_177774_c((Object)villagerdata.func_221130_b()));
            VillagerMetadataSection.HatType typeHatType = VillagerMetadataSection.HatType.NONE;
            VillagerMetadataSection.HatType profHatType = VillagerMetadataSection.HatType.NONE;
            try {
                throwable = null;
                try (IResource typeResource = Minecraft.func_71410_x().func_195551_G().func_199002_a(typeTexture);){
                    VillagerMetadataSection typeMetadata = (VillagerMetadataSection)typeResource.func_199028_a((IMetadataSectionSerializer)VillagerMetadataSection.field_217827_a);
                    if (typeMetadata != null) {
                        typeHatType = typeMetadata.func_217826_a();
                    }
                }
                catch (Throwable typeMetadata) {
                    throwable = typeMetadata;
                    throw typeMetadata;
                }
            }
            catch (IOException typeResource) {
                // empty catch block
            }
            try {
                throwable = null;
                try (IResource profResource = Minecraft.func_71410_x().func_195551_G().func_199002_a(profTexture);){
                    VillagerMetadataSection profMetadata = (VillagerMetadataSection)profResource.func_199028_a((IMetadataSectionSerializer)VillagerMetadataSection.field_217827_a);
                    if (profMetadata != null) {
                        profHatType = profMetadata.func_217826_a();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (profHatType != VillagerMetadataSection.HatType.NONE && (profHatType != VillagerMetadataSection.HatType.PARTIAL || typeHatType == VillagerMetadataSection.HatType.FULL)) {
                return false;
            }
            if (typeTexture == null) {
                return false;
            }
            GlStateManager.enableBlend();
            GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            GlStateManager.enableAlphaTest();
            GlStateManager.alphaFunc((int)516, (float)0.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(typeTexture);
            return true;
        }

        @Override
        protected void postRender(Entity entity) {
            GlStateManager.disableBlend();
            GlStateManager.disableAlphaTest();
            GlStateManager.alphaFunc((int)516, (float)0.1f);
        }
    }
}

