/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.write;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.ComparatorBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.GlassBlock;
import net.minecraft.block.IceBlock;
import net.minecraft.block.OreBlock;
import net.minecraft.block.RepeaterBlock;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.crash.ReportedException;
import net.minecraft.fluid.IFluidState;
import net.minecraft.resources.IResource;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.gen.Heightmap;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.core.XaeroMinimapCore;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.mcworld.MinimapClientWorldData;
import xaero.common.minimap.mcworld.MinimapClientWorldDataHelper;
import xaero.common.minimap.region.MinimapChunk;
import xaero.common.minimap.region.MinimapTile;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.write.MinimapWriterHelper;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;

public class MinimapWriter {
    private static final String[] dimensionsToIgnore = new String[]{"FZHammer"};
    private static final int UPDATE_EVERY_RUNS = 5;
    private static final int MAXIMUM_OVERLAYS = 5;
    private static final int SUN_MINIMUM = 9;
    private IXaeroMinimap modMain;
    private XaeroMinimapSession minimapSession;
    private MinimapWriterHelper helper;
    private MinimapInterface minimapInterface;
    private Random usedRandom = new Random(0L);
    private int loadingSideInChunks;
    private int updateRadius;
    private MinimapChunk[][] loadingBlocks;
    private int loadingMapChunkX;
    private int loadingMapChunkZ;
    private int loadingStartX;
    private int loadingStartZ;
    private int loadingEndX;
    private int loadingEndZ;
    private int loadingCaving;
    private int loadingLevels;
    private int loadingTerrainSlopes;
    private boolean loadingTerrainDepth;
    private boolean loadingRedstone;
    private int loadingColours;
    private boolean loadingTransparency;
    private boolean loadingBiomesVanillaMode;
    private int loadingDimension;
    private boolean loadingIgnoreHeightmaps;
    private int loadingCaveMapsDepth;
    public int loadingLightOverlayType;
    public int loadingLightOverlayMaxLight;
    public int loadingLightOverlayMinLight;
    public int loadingLightOverlayColor;
    private boolean loadingFlowers;
    private MinimapChunk[][] loadedBlocks;
    private int loadedMapChunkX;
    private int loadedMapChunkZ;
    private int loadedCaving;
    private int prevLoadedCaving;
    private int loadedLevels;
    private int loadedTerrainSlopes;
    private boolean loadedTerrainDepth;
    private boolean loadedRedstone;
    private int loadedColours;
    private boolean loadedTransparency;
    private boolean loadedBiomesVanillaMode;
    private int loadedDimension;
    private boolean loadedIgnoreHeightmaps;
    private int loadedCaveMapsDepth;
    public int loadedLightOverlayType;
    public int loadedLightOverlayMaxLight;
    public int loadedLightOverlayMinLight;
    public int loadedLightOverlayColor;
    private boolean loadedFlowers;
    private boolean settingsChanged;
    private int workingFrameCount;
    private long framesFreedTime = -1L;
    public long writeFreeSinceLastWrite = -1L;
    private int writeFreeSizeTiles;
    private int writeFreeFullUpdateTargetTime;
    private int updateChunkX;
    private int updateChunkZ;
    private int tileInsideX;
    private int tileInsideZ;
    private int runNumber;
    private boolean previousShouldLoad;
    private int lastCaving;
    private boolean clearBlockColours;
    private final HashMap<String, Integer> textureColours;
    private final HashMap<Integer, Integer> blockColours;
    private final HashMap<Block, Boolean> transparentCache;
    private final HashMap<BlockState, Boolean> glowingCache;
    private long lastWrite = -1L;
    private long lastWriteTry = -1L;
    private boolean forcedRefresh;
    private MinimapChunk oldChunk;
    private final int[][] lastBlockY = new int[4][16];
    private int updates;
    private int loads;
    private long before;
    private int processingTime;
    public boolean debugTotalTime = false;
    public long minTime = -1L;
    public long maxTime = -1L;
    public long totalTime;
    public long totalRuns;
    public long lastDebugTime = -1L;
    public long minTimeDebug;
    public long maxTimeDebug;
    public long averageTimeDebug;
    private long currentComparisonCode;
    private final List<Integer> pixelTransparentSizes;
    private final List<BlockState> pixelBlockStates;
    private final List<Integer> pixelBlockLights;
    private int firstBlockY;
    boolean isglowing;
    private final int[] underRed;
    private final int[] underGreen;
    private final int[] underBlue;
    private int sun;
    private float currentTransparencyMultiplier;
    private int blockY;
    private int blockColor;
    private final int[] red;
    private final int[] green;
    private final int[] blue;
    private final float[] brightness;
    private final float[] postBrightness;
    private final int[] tempColor;
    private boolean underair;
    private BlockState previousTransparentState;
    private final boolean[] topMostChunk;
    private final BlockPos.MutableBlockPos mutableBlockPos;
    private final BlockPos.MutableBlockPos mutableBlockPos2;
    private final int[][] intUpdateArrayBuffers;
    private Long seedForLoading;
    private final int[] zero16;

    public MinimapWriter(IXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.loadingSideInChunks = 9;
        this.updateRadius = 16;
        this.loadingCaving = -1;
        this.loadedCaving = -1;
        this.prevLoadedCaving = -1;
        this.lastCaving = -1;
        this.textureColours = new HashMap();
        this.blockColours = new HashMap();
        this.loadedCaving = -1;
        this.red = new int[5];
        this.green = new int[5];
        this.blue = new int[5];
        this.underRed = new int[5];
        this.underGreen = new int[5];
        this.underBlue = new int[5];
        this.brightness = new float[5];
        this.postBrightness = new float[5];
        this.tempColor = new int[3];
        this.helper = new MinimapWriterHelper();
        this.mutableBlockPos = new BlockPos.MutableBlockPos();
        this.mutableBlockPos2 = new BlockPos.MutableBlockPos();
        this.intUpdateArrayBuffers = new int[5][4096];
        this.pixelBlockStates = new ArrayList<BlockState>();
        this.pixelTransparentSizes = new ArrayList<Integer>();
        this.pixelBlockLights = new ArrayList<Integer>();
        this.transparentCache = new HashMap();
        this.glowingCache = new HashMap();
        this.topMostChunk = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            this.topMostChunk[i] = true;
        }
        this.minimapInterface = modMain.getInterfaces().getMinimapInterface();
        this.zero16 = new int[16];
    }

    private void updateTimeDebug(long before) {
        if (this.debugTotalTime) {
            long debugPassed = System.nanoTime() - before;
            this.totalTime += debugPassed;
            ++this.totalRuns;
            if (debugPassed > this.maxTime) {
                this.maxTime = debugPassed;
            }
            if (this.minTime == -1L || debugPassed < this.minTime) {
                this.minTime = debugPassed;
            }
            long time = System.currentTimeMillis();
            if (this.lastDebugTime == -1L) {
                this.lastDebugTime = time;
            } else if (time - this.lastDebugTime > 1000L) {
                this.maxTimeDebug = this.maxTime;
                this.minTimeDebug = this.minTime;
                this.averageTimeDebug = this.totalTime / this.totalRuns;
                this.maxTime = -1L;
                this.minTime = -1L;
                this.totalTime = 0L;
                this.totalRuns = 0L;
                this.lastDebugTime = time;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRender() {
        long before = System.nanoTime();
        MinimapProcessor minimapProcessor = this.minimapSession.getMinimapProcessor();
        try {
            long passed;
            boolean shouldLoad;
            World world = null;
            double playerX = 0.0;
            double playerY = 0.0;
            double playerZ = 0.0;
            Object object = minimapProcessor.mainStuffSync;
            synchronized (object) {
                world = minimapProcessor.mainWorld;
                playerX = minimapProcessor.mainPlayerX;
                playerY = minimapProcessor.mainPlayerY;
                playerZ = minimapProcessor.mainPlayerZ;
            }
            if (this.modMain.getSettings() == null || !this.modMain.getSettings().getMinimap() || world == null) {
                this.updateTimeDebug(before);
                return;
            }
            int currentCaving = this.getCaving(playerX, playerY, playerZ, world);
            boolean bl = shouldLoad = !this.ignoreWorld(world) && (!this.modMain.getSupportMods().shouldUseWorldMapChunks() || this.loadingCaving != -1 || this.loadedCaving != -1 || this.loadingLightOverlayType > 0 || this.loadedLightOverlayType > 0 || currentCaving != -1 || this.modMain.getSettings().lightOverlayType > 0);
            if (shouldLoad != this.previousShouldLoad) {
                this.updateChunkZ = 0;
                this.updateChunkX = 0;
                this.tileInsideZ = 0;
                this.tileInsideX = 0;
                this.previousShouldLoad = shouldLoad;
            }
            if (!shouldLoad) {
                this.updateTimeDebug(before);
                return;
            }
            XaeroMinimapCore.ensureField();
            int lengthX = Math.min(this.loadingSideInChunks, this.loadingEndX - this.loadingStartX + 1);
            int lengthZ = Math.min(this.loadingSideInChunks, this.loadingEndZ - this.loadingStartZ + 1);
            if (this.lastWriteTry == -1L) {
                lengthX = 3;
                lengthZ = 3;
            } else {
                if (lengthX > this.loadingSideInChunks) {
                    lengthX = this.loadingSideInChunks;
                }
                if (lengthZ > this.loadingSideInChunks) {
                    lengthZ = this.loadingSideInChunks;
                }
            }
            int sizeTileChunks = lengthX * lengthZ;
            int sizeTiles = sizeTileChunks * 4 * 4;
            int sizeBasedTargetTime = sizeTiles * 1000 / 1500;
            int fullUpdateTargetTime = Math.max(100, sizeBasedTargetTime);
            long time = System.currentTimeMillis();
            long l = passed = this.lastWrite == -1L ? 0L : time - this.lastWrite;
            if (this.lastWriteTry == -1L || this.writeFreeSizeTiles != sizeTiles || this.writeFreeFullUpdateTargetTime != fullUpdateTargetTime || this.workingFrameCount > 30) {
                this.framesFreedTime = time;
                this.writeFreeSizeTiles = sizeTiles;
                this.writeFreeFullUpdateTargetTime = fullUpdateTargetTime;
                this.workingFrameCount = 0;
            }
            long sinceLastWrite = Math.min(passed, this.writeFreeSinceLastWrite);
            if (this.framesFreedTime != -1L) {
                sinceLastWrite = time - this.framesFreedTime;
            }
            long tilesToUpdate = Math.min(sinceLastWrite * (long)sizeTiles / (long)fullUpdateTargetTime, 100L);
            if (this.lastWrite == -1L || tilesToUpdate != 0L) {
                this.lastWrite = time;
            }
            if (tilesToUpdate != 0L) {
                if (this.framesFreedTime == -1L) {
                    int timeLimit = (int)(Math.min(sinceLastWrite, 50L) * 86960L);
                    long writeStartNano = System.nanoTime();
                    int i = 0;
                    while ((long)i < tilesToUpdate) {
                        if (this.writeChunk(minimapProcessor, playerX, playerY, playerZ, world, currentCaving)) {
                            --i;
                        }
                        if (System.nanoTime() - writeStartNano >= (long)timeLimit) break;
                        ++i;
                    }
                    ++this.workingFrameCount;
                } else {
                    this.writeFreeSinceLastWrite = sinceLastWrite;
                    this.framesFreedTime = -1L;
                }
            }
            this.lastWriteTry = time;
        }
        catch (Throwable e) {
            this.minimapInterface.setCrashedWith(e);
        }
        this.updateTimeDebug(before);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeChunk(MinimapProcessor minimapProcessor, double playerX, double playerY, double playerZ, World world, int currentCaving) {
        MinimapChunk mchunk;
        long processStart = System.nanoTime();
        if (this.tileInsideX == 0 && this.tileInsideZ == 0) {
            if (this.updateChunkX == 0 && this.updateChunkZ == 0) {
                this.settingsChanged = false;
                if (this.clearBlockColours) {
                    this.settingsChanged = true;
                    this.clearBlockColours = false;
                    if (!this.blockColours.isEmpty()) {
                        this.blockColours.clear();
                        this.textureColours.clear();
                        System.out.println("Minimap block colour cache cleaned.");
                    }
                }
                this.loadingSideInChunks = this.getLoadSide();
                this.updateRadius = this.getUpdateRadiusInChunks();
                int playerXInt = OptimizedMath.myFloor(playerX);
                int playerZInt = OptimizedMath.myFloor(playerZ);
                this.loadingMapChunkX = this.getMapCoord(this.loadingSideInChunks, playerXInt);
                this.loadingMapChunkZ = this.getMapCoord(this.loadingSideInChunks, playerZInt);
                int loadDistance = Minecraft.func_71410_x().field_71474_y.field_151451_c;
                int playerTileX = playerXInt >> 4;
                int playerTileZ = playerZInt >> 4;
                int globalStartX = playerTileX - loadDistance >> 2;
                int globalStartZ = playerTileZ - loadDistance >> 2;
                int globalEndX = playerTileX + loadDistance >> 2;
                int globalEndZ = playerTileZ + loadDistance >> 2;
                this.loadingStartX = globalStartX - this.loadingMapChunkX;
                this.loadingStartZ = globalStartZ - this.loadingMapChunkZ;
                this.loadingEndX = globalEndX - this.loadingMapChunkX;
                this.loadingEndZ = globalEndZ - this.loadingMapChunkZ;
                this.loadingCaving = currentCaving;
                if (this.loadingCaving != -1 || this.loadedCaving != -1) {
                    int maxDistance = 2;
                    if (this.loadingCaving != -1 && this.loadedCaving == -1) {
                        maxDistance = 1;
                    }
                    this.loadingStartX = Math.max(this.loadingStartX, this.loadingSideInChunks / 2 - maxDistance);
                    this.loadingStartZ = Math.max(this.loadingStartZ, this.loadingSideInChunks / 2 - maxDistance);
                    this.loadingEndX = Math.min(this.loadingEndX, this.loadingSideInChunks / 2 + maxDistance);
                    this.loadingEndZ = Math.min(this.loadingEndZ, this.loadingSideInChunks / 2 + maxDistance);
                }
                if (this.loadingCaving != this.loadedCaving || this.loadingCaving != -1 && this.prevLoadedCaving == -1) {
                    this.runNumber = 0;
                }
                this.loadingLevels = this.modMain.getSettings().getLighting() ? 5 : 1;
                this.loadingTerrainSlopes = this.modMain.getSettings().getTerrainSlopes();
                this.loadingTerrainDepth = this.modMain.getSettings().getTerrainDepth();
                this.loadingRedstone = this.modMain.getSettings().getDisplayRedstone();
                this.loadingColours = this.modMain.getSettings().getBlockColours();
                this.loadingTransparency = this.modMain.getSettings().blockTransparency;
                this.loadingBiomesVanillaMode = this.modMain.getSettings().getBiomeColorsVanillaMode();
                this.loadingDimension = world.func_201675_m().func_186058_p().func_186068_a();
                this.loadingCaveMapsDepth = this.modMain.getSettings().caveMapsDepth;
                this.loadingIgnoreHeightmaps = this.modMain.getSettings().isIgnoreHeightmaps();
                this.loadingLightOverlayColor = this.modMain.getSettings().lightOverlayColor;
                this.loadingLightOverlayMaxLight = this.modMain.getSettings().lightOverlayMaxLight;
                this.loadingLightOverlayMinLight = this.modMain.getSettings().lightOverlayMinLight;
                this.loadingLightOverlayType = this.modMain.getSettings().lightOverlayType;
                this.loadingFlowers = this.modMain.getSettings().getShowFlowers();
                this.settingsChanged = this.settingsChanged || this.loadedDimension != this.loadingDimension;
                this.settingsChanged = this.settingsChanged || this.loadedTerrainSlopes != this.loadingTerrainSlopes;
                this.settingsChanged = this.settingsChanged || this.loadedTerrainDepth != this.loadingTerrainDepth;
                this.settingsChanged = this.settingsChanged || this.loadedRedstone != this.loadingRedstone;
                this.settingsChanged = this.settingsChanged || this.loadedColours != this.loadingColours;
                this.settingsChanged = this.settingsChanged || this.loadedTransparency != this.loadingTransparency;
                this.settingsChanged = this.settingsChanged || this.loadingBiomesVanillaMode != this.loadedBiomesVanillaMode;
                this.settingsChanged = this.settingsChanged || this.loadingCaveMapsDepth != this.loadedCaveMapsDepth;
                this.settingsChanged = this.settingsChanged || this.loadingIgnoreHeightmaps != this.loadedIgnoreHeightmaps;
                this.settingsChanged = this.settingsChanged || this.loadingLightOverlayColor != this.loadedLightOverlayColor;
                this.settingsChanged = this.settingsChanged || this.loadingLightOverlayMaxLight != this.loadedLightOverlayMaxLight;
                this.settingsChanged = this.settingsChanged || this.loadingLightOverlayMinLight != this.loadedLightOverlayMinLight;
                this.settingsChanged = this.settingsChanged || this.loadingLightOverlayType != this.loadedLightOverlayType;
                boolean bl = this.settingsChanged = this.settingsChanged || this.loadingFlowers != this.loadedFlowers;
                if (this.loadingBlocks == null || this.loadingBlocks.length != this.loadingSideInChunks) {
                    this.loadingBlocks = new MinimapChunk[this.loadingSideInChunks][this.loadingSideInChunks];
                }
                if (this.minimapInterface.usingFBO() && minimapProcessor.isToResetImage()) {
                    this.forcedRefresh = true;
                    minimapProcessor.setToResetImage(false);
                }
            }
            this.oldChunk = null;
            if (this.loadedBlocks != null) {
                int updateChunkXOld = this.loadingMapChunkX + this.updateChunkX - this.loadedMapChunkX;
                int updateChunkZOld = this.loadingMapChunkZ + this.updateChunkZ - this.loadedMapChunkZ;
                if (updateChunkXOld > -1 && updateChunkXOld < this.loadedBlocks.length && updateChunkZOld > -1 && updateChunkZOld < this.loadedBlocks.length) {
                    this.oldChunk = this.loadedBlocks[updateChunkXOld][updateChunkZOld];
                }
            }
        }
        if ((mchunk = this.loadingBlocks[this.updateChunkX][this.updateChunkZ]) == null) {
            MinimapChunk minimapChunk = new MinimapChunk(this.loadingMapChunkX + this.updateChunkX, this.loadingMapChunkZ + this.updateChunkZ);
            this.loadingBlocks[this.updateChunkX][this.updateChunkZ] = minimapChunk;
            mchunk = minimapChunk;
        } else if (this.tileInsideX == 0 && this.tileInsideZ == 0) {
            mchunk.reset(this.loadingMapChunkX + this.updateChunkX, this.loadingMapChunkZ + this.updateChunkZ);
        }
        boolean onlyLoad = this.runNumber % 5 != 0 && this.loadingLightOverlayType <= 0;
        boolean outsideRender = this.updateChunkX < this.loadingStartX || this.updateChunkX > this.loadingEndX || this.updateChunkZ < this.loadingStartZ || this.updateChunkZ > this.loadingEndZ;
        if (this.loadingCaving == -1 == (this.loadedCaving == -1) && this.loadingCaving == -1 != (currentCaving == -1)) {
            outsideRender = true;
        }
        this.writeTile(minimapProcessor, playerX, playerY, playerZ, world, mchunk, this.oldChunk, this.updateChunkX, this.updateChunkZ, this.tileInsideX, this.tileInsideZ, onlyLoad, outsideRender);
        if (this.loadingLightOverlayType > 0 && this.loadedLightOverlayType > 0) {
            onlyLoad = true;
        }
        ++this.tileInsideZ;
        if (this.tileInsideZ >= 4) {
            this.tileInsideZ = 0;
            ++this.tileInsideX;
            if (this.tileInsideX >= 4) {
                int i2;
                this.tileInsideX = 0;
                mchunk = this.loadingBlocks[this.updateChunkX][this.updateChunkZ];
                if (this.minimapInterface.usingFBO() && mchunk.isHasSomething() && mchunk.isChanged()) {
                    mchunk.updateBuffers(this.loadingLevels, this.intUpdateArrayBuffers);
                    mchunk.setChanged(false);
                }
                mchunk.setLevelsBuffered(this.loadingLevels);
                if (this.updateChunkX == this.loadingSideInChunks - 1 && this.updateChunkZ == this.loadingSideInChunks - 1) {
                    if (this.runNumber % 5 == 0 && !MinimapTile.recycled.isEmpty()) {
                        MinimapTile.recycled.subList(0, MinimapTile.recycled.size() / 2).clear();
                    }
                    if (this.loadedBlocks != null) {
                        for (i2 = 0; i2 < this.loadedBlocks.length; ++i2) {
                            for (int j = 0; j < this.loadedBlocks.length; ++j) {
                                boolean shouldTransfer;
                                MinimapChunk m = this.loadedBlocks[i2][j];
                                MinimapChunk lm = null;
                                if (m == null) continue;
                                m.recycleTiles();
                                int loadingX = this.loadedMapChunkX + i2 - this.loadingMapChunkX;
                                int loadingZ = this.loadedMapChunkZ + j - this.loadingMapChunkZ;
                                if (loadingX > -1 && loadingZ > -1 && loadingX < this.loadingSideInChunks && loadingZ < this.loadingSideInChunks) {
                                    lm = this.loadingBlocks[loadingX][loadingZ];
                                }
                                boolean bl = shouldTransfer = m.getLevelsBuffered() == this.loadingLevels && lm != null;
                                if (shouldTransfer) {
                                    MinimapChunk minimapChunk = m;
                                    synchronized (minimapChunk) {
                                        m.setBlockTextureUpload(true);
                                    }
                                }
                                for (int l = 0; l < m.getLevelsBuffered(); ++l) {
                                    if (m.getGlTexture(l) != 0) {
                                        if (shouldTransfer) {
                                            lm.setGlTexture(l, m.getGlTexture(l));
                                        } else {
                                            GL11.glDeleteTextures((int)m.getGlTexture(l));
                                        }
                                    }
                                    if (!shouldTransfer || lm.isRefreshRequired(l) || !m.isRefreshRequired(l)) continue;
                                    lm.copyBuffer(l, m.getBuffer(l));
                                    lm.setRefreshRequired(l, true);
                                    m.setRefreshRequired(l, false);
                                }
                            }
                        }
                    }
                    MinimapWriter i2 = this;
                    synchronized (i2) {
                        MinimapChunk[][] bu = this.loadedBlocks;
                        this.loadedBlocks = this.loadingBlocks;
                        this.loadingBlocks = bu;
                        this.loadedMapChunkX = this.loadingMapChunkX;
                        this.loadedMapChunkZ = this.loadingMapChunkZ;
                        this.loadedLevels = this.loadingLevels;
                        this.loadedTerrainSlopes = this.loadingTerrainSlopes;
                        this.loadedTerrainDepth = this.loadingTerrainDepth;
                        this.loadedRedstone = this.loadingRedstone;
                        this.loadedColours = this.loadingColours;
                        this.loadedTransparency = this.loadingTransparency;
                        this.loadedBiomesVanillaMode = this.loadingBiomesVanillaMode;
                        this.loadedDimension = this.loadingDimension;
                        this.loadedCaveMapsDepth = this.loadingCaveMapsDepth;
                        this.loadedIgnoreHeightmaps = this.loadingIgnoreHeightmaps;
                        this.loadedLightOverlayColor = this.loadingLightOverlayColor;
                        this.loadedLightOverlayMaxLight = this.loadingLightOverlayMaxLight;
                        this.loadedLightOverlayMinLight = this.loadingLightOverlayMinLight;
                        this.loadedLightOverlayType = this.loadingLightOverlayType;
                        this.loadedFlowers = this.loadingFlowers;
                    }
                    this.prevLoadedCaving = this.loadedCaving;
                    this.loadedCaving = this.loadingCaving;
                    this.forcedRefresh = false;
                    ++this.runNumber;
                }
                ++this.updateChunkZ;
                if (this.updateChunkZ >= this.loadingSideInChunks) {
                    this.updateChunkZ = 0;
                    this.updateChunkX = (this.updateChunkX + 1) % this.loadingSideInChunks;
                    for (i2 = 0; i2 < 4; ++i2) {
                        this.topMostChunk[i2] = true;
                        System.arraycopy(this.zero16, 0, this.lastBlockY[i2], 0, 16);
                    }
                }
            }
        }
        int passed = (int)(System.nanoTime() - processStart);
        return outsideRender;
    }

    private void writeTile(MinimapProcessor minimapProcessor, double playerX, double playerY, double playerZ, World world, MinimapChunk mchunk, MinimapChunk oldChunk, int canvasX, int canvasZ, int insideX, int insideZ, boolean onlyLoad, boolean outsideRender) {
        int j;
        int tileX = mchunk.getX() * 4 + insideX;
        int tileZ = mchunk.getZ() * 4 + insideZ;
        int halfSide = this.loadingSideInChunks / 2;
        int tileFromCenterX = canvasX - halfSide;
        int tileFromCenterZ = canvasZ - halfSide;
        MinimapTile oldTile = null;
        if (oldChunk != null) {
            oldTile = oldChunk.getTile(insideX, insideZ);
        }
        Chunk bchunk = (Chunk)world.func_217353_a(tileX, tileZ, ChunkStatus.field_222617_m, false);
        boolean neighborsLoaded = true;
        block4: for (int i = -1; i < 2; ++i) {
            for (j = -1; j < 2; ++j) {
                Chunk nChunk;
                if (i == 0 && j == 0 || (nChunk = world.func_212866_a_(tileX + i, tileZ + j)) != null && !(nChunk instanceof EmptyChunk)) continue;
                neighborsLoaded = false;
                continue block4;
            }
        }
        boolean chunkUpdated = false;
        try {
            chunkUpdated = bchunk != null && (Boolean)XaeroMinimapCore.chunkCleanField.get(bchunk) == false || oldTile == null || oldTile.caveLevel != this.loadingCaving;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        if (outsideRender || bchunk == null || bchunk instanceof EmptyChunk || !neighborsLoaded || (!chunkUpdated || onlyLoad || tileFromCenterX > this.updateRadius || tileFromCenterZ > this.updateRadius || tileFromCenterX < -this.updateRadius || tileFromCenterZ < -this.updateRadius) && oldTile != null && oldTile.isSuccess() && oldChunk.getLevelsBuffered() == this.loadingLevels && !this.settingsChanged) {
            if (oldTile != null && oldChunk.getLevelsBuffered() == this.loadingLevels && !this.settingsChanged) {
                mchunk.setTile(insideX, insideZ, oldTile);
                oldTile.setWasTransfered(true);
                for (j = 0; j < 16; ++j) {
                    this.lastBlockY[insideX][j] = oldTile.getLastHeight(j);
                }
                mchunk.setHasSomething(oldChunk.isHasSomething());
                this.topMostChunk[insideX] = false;
                if (this.forcedRefresh) {
                    mchunk.setChanged(true);
                }
            } else {
                for (j = 0; j < 16; ++j) {
                    this.lastBlockY[insideX][j] = 0;
                }
            }
            return;
        }
        if (oldTile != null && oldChunk.getLevelsBuffered() != this.loadingLevels) {
            oldTile = null;
        }
        MinimapTile tile = null;
        int sectionBasedHeight = this.loadingIgnoreHeightmaps ? this.getSectionBasedHeight(bchunk, 64) : 0;
        Heightmap.Type typeWorldSurface = Heightmap.Type.WORLD_SURFACE;
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getWorldData((ClientWorld)world);
        float shadowR = worldData.shadowR;
        float shadowG = worldData.shadowG;
        float shadowB = worldData.shadowB;
        int playerYi = (int)playerY;
        boolean sameCaveLevel = oldTile != null && this.loadingCaving == oldTile.caveLevel;
        boolean settingsChanged = this.settingsChanged;
        int loadingCaving = this.loadingCaving;
        int loadingLevels = this.loadingLevels;
        int loadingTerrainSlopes = this.loadingTerrainSlopes;
        boolean loadingTerrainDepth = this.loadingTerrainDepth;
        List<Integer> pixelTransparentSizes = this.pixelTransparentSizes;
        List<BlockState> pixelBlockStates = this.pixelBlockStates;
        List<Integer> pixelBlockLights = this.pixelBlockLights;
        int[] underRed = this.underRed;
        int[] underGreen = this.underGreen;
        int[] underBlue = this.underBlue;
        int[][] lastBlockY = this.lastBlockY;
        boolean[] topMostChunk = this.topMostChunk;
        float[] postBrightness = this.postBrightness;
        float[] brightness = this.brightness;
        int[] red = this.red;
        int[] green = this.green;
        int[] blue = this.blue;
        int[] tempColor = this.tempColor;
        boolean loadingIgnoreHeightmaps = this.loadingIgnoreHeightmaps;
        int loadingCaveMapsDepth = this.loadingCaveMapsDepth;
        BlockPos.MutableBlockPos mutableBlockPos = this.mutableBlockPos;
        BlockPos.MutableBlockPos mutableBlockPos2 = this.mutableBlockPos2;
        Long seedForLoading = this.seedForLoading;
        int loadedLevels = this.loadedLevels;
        IXaeroMinimap modMain = this.modMain;
        MinimapWriterHelper helper = this.helper;
        int loadingColours = this.loadingColours;
        boolean loadingRedstone = this.loadingRedstone;
        boolean loadingTransparency = this.loadingTransparency;
        int loadingLightOverlayType = this.loadingLightOverlayType;
        int loadingLightOverlayMaxLight = this.loadingLightOverlayMaxLight;
        int loadingLightOverlayMinLight = this.loadingLightOverlayMinLight;
        int loadingLightOverlayColor = this.loadingLightOverlayColor;
        boolean loadingFlowers = this.loadingFlowers;
        for (int blockX = 0; blockX < 16; ++blockX) {
            for (int blockZ = 0; blockZ < 16; ++blockZ) {
                tile = this.loadBlockColor(playerYi, world, blockX, blockZ, bchunk, tileX, tileZ, insideX, insideZ, sectionBasedHeight, typeWorldSurface, oldTile, mchunk, shadowR, shadowG, shadowB, sameCaveLevel, settingsChanged, loadingCaving, loadingLevels, loadingTerrainSlopes, loadingTerrainDepth, pixelTransparentSizes, pixelBlockStates, pixelBlockLights, underRed, underGreen, underBlue, lastBlockY, topMostChunk, postBrightness, brightness, red, green, blue, tempColor, loadingIgnoreHeightmaps, loadingCaveMapsDepth, mutableBlockPos, mutableBlockPos2, seedForLoading, loadedLevels, modMain, helper, loadingColours, loadingRedstone, loadingTransparency, loadingLightOverlayType, loadingLightOverlayMaxLight, loadingLightOverlayMinLight, loadingLightOverlayColor, loadingFlowers);
                if (blockZ != 15 || tile == null) continue;
                tile.setLastHeight(blockX, lastBlockY[insideX][blockX]);
            }
        }
        tile.caveLevel = loadingCaving;
        topMostChunk[insideX] = false;
        try {
            XaeroMinimapCore.chunkCleanField.set(bchunk, true);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public MinimapTile loadBlockColor(int playerYi, World world, int insideX, int insideZ, Chunk bchunk, int tileX, int tileZ, int tileInsideX, int tileInsideZ, int sectionBasedHeight, Heightmap.Type typeWorldSurface, MinimapTile oldTile, MinimapChunk mchunk, float shadowR, float shadowG, float shadowB, boolean sameCaveLevel, boolean settingsChanged, int loadingCaving, int loadingLevels, int loadingTerrainSlopes, boolean loadingTerrainDepth, List<Integer> pixelTransparentSizes, List<BlockState> pixelBlockStates, List<Integer> pixelBlockLights, int[] underRed, int[] underGreen, int[] underBlue, int[][] lastBlockY, boolean[] topMostChunk, float[] postBrightness, float[] brightness, int[] red, int[] green, int[] blue, int[] tempColor, boolean loadingIgnoreHeightmaps, int loadingCaveMapsDepth, BlockPos.MutableBlockPos mutableBlockPos, BlockPos.MutableBlockPos mutableBlockPos2, Long seedForLoading, int loadedLevels, IXaeroMinimap modMain, MinimapWriterHelper helper, int loadingColours, boolean loadingRedstone, boolean loadingTransparency, int loadingLightOverlayType, int loadingLightOverlayMaxLight, int loadingLightOverlayMinLight, int loadingLightOverlayColor, boolean loadingFlowers) {
        MinimapTile tile;
        boolean reuseColour;
        int lowY;
        int highY;
        if (loadingCaving != -1) {
            highY = loadingCaving;
        } else {
            int height = bchunk.func_201576_a(typeWorldSurface, insideX, insideZ);
            highY = loadingIgnoreHeightmaps || height == -1 ? sectionBasedHeight : height + 3;
        }
        int n = lowY = loadingCaving != -1 ? playerYi - loadingCaveMapsDepth : 0;
        if (lowY < 0) {
            lowY = 0;
        }
        pixelTransparentSizes.clear();
        pixelBlockStates.clear();
        pixelBlockLights.clear();
        this.currentComparisonCode = 0L;
        byte currentComparisonCodeAdd = 0;
        byte currentComparisonCodeAdd2 = 0;
        this.blockY = 0;
        for (int i = 0; i < loadingLevels; ++i) {
            underRed[i] = 0;
            underGreen[i] = 0;
            underBlue[i] = 0;
        }
        this.currentTransparencyMultiplier = 1.0f;
        this.sun = 15;
        this.blockColor = 0;
        this.isglowing = false;
        double secondaryBR = 1.0;
        double secondaryBG = 1.0;
        double secondaryBB = 1.0;
        Block block = this.findBlock(world, bchunk, insideX, insideZ, highY, lowY, loadingCaving, loadingRedstone, mutableBlockPos, mutableBlockPos2, loadingColours, loadingTransparency, pixelBlockLights, pixelBlockStates, loadingLevels, pixelTransparentSizes, loadingFlowers);
        boolean isglowing = this.isglowing;
        int blockY = this.blockY;
        long currentComparisonCode = this.currentComparisonCode;
        boolean success = true;
        if (topMostChunk[tileInsideX] && insideZ == 0) {
            if (pixelTransparentSizes.isEmpty()) {
                lastBlockY[tileInsideX][insideX] = blockY;
                try {
                    Chunk prevChunk = world.func_212866_a_(tileX, tileZ - 1);
                    if (prevChunk != null) {
                        lastBlockY[tileInsideX][insideX] = prevChunk.func_201576_a(typeWorldSurface, insideX, 15);
                    }
                }
                catch (IllegalStateException prevChunk) {
                    // empty catch block
                }
            }
            success = false;
        }
        int slope = 0;
        if (loadingTerrainSlopes > 0 && lastBlockY[tileInsideX][insideX] != 0) {
            slope = Math.max(-128, Math.min(127, blockY - lastBlockY[tileInsideX][insideX]));
        }
        currentComparisonCode |= 0L;
        for (int i = 0; i < pixelBlockLights.size(); ++i) {
            int l = pixelBlockLights.get(i);
            if (i <= 1) {
                currentComparisonCodeAdd = (byte)(currentComparisonCodeAdd | l << 4 * i + 2);
            }
            if (i < 1) continue;
            currentComparisonCode |= (long)(l << 4 * (i - 1) >> 2);
        }
        int add2Calculation = 17;
        for (int i = 0; i < pixelTransparentSizes.size(); ++i) {
            add2Calculation = add2Calculation * 37 + pixelTransparentSizes.get(i);
        }
        currentComparisonCodeAdd = (byte)(currentComparisonCodeAdd | add2Calculation >> 8 & 3);
        currentComparisonCodeAdd2 = (byte)add2Calculation;
        boolean bl = reuseColour = !settingsChanged && sameCaveLevel && !oldTile.pixelChanged(insideX, insideZ, currentComparisonCode, currentComparisonCodeAdd, currentComparisonCodeAdd2, (byte)slope);
        if (!reuseColour) {
            int firstSun = this.sun;
            this.calculateBlockColors(world, bchunk, insideX, insideZ, mutableBlockPos2, pixelTransparentSizes, pixelBlockStates, pixelBlockLights, loadingColours, loadingLightOverlayColor);
            int blockColor = this.blockColor;
            float currentTransparencyMultiplier = this.currentTransparencyMultiplier;
            int sun = this.sun;
            boolean bl2 = isglowing = block != null && !(block instanceof OreBlock) && isglowing;
            if (!isglowing) {
                boolean lighting = loadingLevels != 1;
                boolean hasTransparentLayer = !pixelTransparentSizes.isEmpty();
                int blockLight = pixelBlockLights.isEmpty() ? 0 : pixelBlockLights.get(pixelBlockLights.size() - 1);
                for (int i = 0; i < loadingLevels; ++i) {
                    postBrightness[i] = 1.0f;
                    if (!lighting && loadingCaving != -1) {
                        if (!hasTransparentLayer) {
                            brightness[i] = (float)Math.min((double)blockY / 80.0, 1.0);
                            continue;
                        }
                        brightness[i] = 1.0f;
                        postBrightness[i] = (float)Math.min((double)blockY / 80.0, 1.0);
                        continue;
                    }
                    brightness[i] = this.getBlockBrightness(9.0f, sun, i, blockLight);
                }
                float depthBrightness = 1.0f;
                if (loadingCaving == -1 && loadingTerrainDepth) {
                    float max;
                    depthBrightness = (float)blockY / 63.0f;
                    float f = max = loadingTerrainSlopes == 2 ? 1.0f : 1.15f;
                    if (depthBrightness > max) {
                        depthBrightness = max;
                    } else if (depthBrightness < 0.7f) {
                        depthBrightness = 0.7f;
                    }
                }
                if (loadingTerrainSlopes > 0) {
                    if (loadingTerrainSlopes == 1) {
                        if (slope > 0) {
                            depthBrightness = (float)((double)depthBrightness * 1.15);
                        } else if (slope < 0) {
                            depthBrightness = (float)((double)depthBrightness * 0.85);
                        }
                    } else {
                        float ambientLight = 0.7f;
                        float ambientLightColored = 0.2f;
                        float ambientLightWhite = ambientLight - ambientLightColored;
                        float cos = 0.0f;
                        if (slope >= 0) {
                            float surfaceDirectionMagnitude = (float)Math.sqrt(slope * slope + 1);
                            float castToMostLit = slope + 1;
                            cos = (float)((double)(castToMostLit / surfaceDirectionMagnitude) / Math.sqrt(2.0));
                        }
                        float whiteLight = ambientLightWhite + (1.0f - ambientLight) * Math.max(0.0f, cos) / 0.45f;
                        secondaryBR *= (double)(shadowR * ambientLightColored + whiteLight);
                        secondaryBG *= (double)(shadowG * ambientLightColored + whiteLight);
                        secondaryBB *= (double)(shadowB * ambientLightColored + whiteLight);
                    }
                }
                secondaryBR *= (double)depthBrightness;
                secondaryBG *= (double)depthBrightness;
                secondaryBB *= (double)depthBrightness;
            }
            if (isglowing) {
                helper.getBrightestColour(blockColor >> 16 & 0xFF, blockColor >> 8 & 0xFF, blockColor & 0xFF, tempColor);
            }
            if (loadingLightOverlayType > 0) {
                int testLight;
                int blockLight;
                int n2 = blockLight = pixelBlockLights.isEmpty() ? 0 : pixelBlockLights.get(0);
                int n3 = loadingLightOverlayType == 1 ? blockLight : (testLight = loadingLightOverlayType == 2 ? firstSun : Math.max(blockLight, firstSun));
                if (testLight >= loadingLightOverlayMinLight && testLight <= loadingLightOverlayMaxLight) {
                    int overlayColor = ModSettings.COLORS[loadingLightOverlayColor];
                    int overlayRed = (overlayColor >> 16 & 0xFF) * 2 / 3;
                    int overlayGreen = (overlayColor >> 8 & 0xFF) * 2 / 3;
                    int overlayBlue = (overlayColor & 0xFF) * 2 / 3;
                    int i = 0;
                    while (i < loadingLevels) {
                        int n4 = i;
                        underRed[n4] = underRed[n4] / 3;
                        int n5 = i;
                        underGreen[n5] = underGreen[n5] / 3;
                        int n6 = i;
                        underBlue[n6] = underBlue[n6] / 3;
                        int n7 = i;
                        underRed[n7] = underRed[n7] + overlayRed;
                        int n8 = i;
                        underGreen[n8] = underGreen[n8] + overlayGreen;
                        int n9 = i++;
                        underBlue[n9] = underBlue[n9] + overlayBlue;
                    }
                    currentTransparencyMultiplier /= 3.0f;
                }
            }
            for (int i = 0; i < loadingLevels; ++i) {
                float b;
                if (isglowing) {
                    red[i] = tempColor[0];
                    green[i] = tempColor[1];
                    blue[i] = tempColor[2];
                    b = currentTransparencyMultiplier;
                } else {
                    red[i] = blockColor >> 16 & 0xFF;
                    green[i] = blockColor >> 8 & 0xFF;
                    blue[i] = blockColor & 0xFF;
                    b = brightness[i] * currentTransparencyMultiplier;
                }
                red[i] = (int)(((double)((float)red[i] * b) * secondaryBR + (double)underRed[i]) * (double)postBrightness[i]);
                if (red[i] > 255) {
                    red[i] = 255;
                }
                green[i] = (int)(((double)((float)green[i] * b) * secondaryBG + (double)underGreen[i]) * (double)postBrightness[i]);
                if (green[i] > 255) {
                    green[i] = 255;
                }
                blue[i] = (int)(((double)((float)blue[i] * b) * secondaryBB + (double)underBlue[i]) * (double)postBrightness[i]);
                if (blue[i] <= 255) continue;
                blue[i] = 255;
            }
        } else {
            for (int i = 0; i < loadingLevels; ++i) {
                red[i] = oldTile.getRed(i, insideX, insideZ);
                green[i] = oldTile.getGreen(i, insideX, insideZ);
                blue[i] = oldTile.getBlue(i, insideX, insideZ);
            }
        }
        lastBlockY[tileInsideX][insideX] = blockY;
        if (this.notEmptyColor(red, green, blue)) {
            mchunk.setHasSomething(true);
        }
        if ((tile = mchunk.getTile(tileInsideX, tileInsideZ)) == null) {
            tile = MinimapTile.getANewTile(modMain.getSettings(), tileX, tileZ, seedForLoading);
            mchunk.setTile(tileInsideX, tileInsideZ, tile);
        }
        tile.setCode(insideX, insideZ, currentComparisonCode, currentComparisonCodeAdd, currentComparisonCodeAdd2, (byte)slope);
        if (tile.isSuccess()) {
            tile.setSuccess(success);
        }
        if (oldTile != null) {
            int oldTileDarkestLevel = loadedLevels - 1;
            int tileDarkestLevel = loadingLevels - 1;
            if (oldTile.getRed(oldTileDarkestLevel, insideX, insideZ) != red[tileDarkestLevel] || oldTile.getGreen(oldTileDarkestLevel, insideX, insideZ) != green[tileDarkestLevel] || oldTile.getBlue(oldTileDarkestLevel, insideX, insideZ) != blue[tileDarkestLevel]) {
                mchunk.setChanged(true);
            }
        } else {
            mchunk.setChanged(true);
        }
        for (int i = 0; i < loadingLevels; ++i) {
            tile.setRed(i, insideX, insideZ, red[i]);
            tile.setGreen(i, insideX, insideZ, green[i]);
            tile.setBlue(i, insideX, insideZ, blue[i]);
        }
        return tile;
    }

    public Block findBlock(World world, Chunk bchunk, int insideX, int insideZ, int highY, int lowY, int loadingCaving, boolean loadingRedstone, BlockPos.MutableBlockPos mutableBlockPos, BlockPos.MutableBlockPos mutableBlockPos2, int loadingColours, boolean loadingTransparency, List<Integer> pixelBlockLights, List<BlockState> pixelBlockStates, int loadingLevels, List<Integer> pixelTransparentSizes, boolean loadingFlowers) {
        this.underair = false;
        this.previousTransparentState = null;
        for (int i = highY; i >= lowY; --i) {
            mutableBlockPos.func_181079_c(insideX, i, insideZ);
            BlockState state = bchunk.func_180495_p((BlockPos)mutableBlockPos);
            IFluidState fluidFluidState = state.func_204520_s();
            BlockState fluidState = fluidFluidState.func_206883_i();
            if (!fluidFluidState.func_206888_e()) {
                this.underair = true;
                if (this.findBlockHelp(world, bchunk, insideX, i, insideZ, fluidState, fluidFluidState.func_180664_k(), loadingCaving, loadingRedstone, mutableBlockPos, mutableBlockPos2, loadingColours, loadingTransparency, pixelBlockLights, pixelBlockStates, loadingLevels, pixelTransparentSizes, loadingFlowers)) {
                    return fluidState.func_177230_c();
                }
            }
            if (state == null || state.func_177230_c() != Blocks.field_150350_a && state.func_177230_c() == fluidState.func_177230_c() || !this.findBlockHelp(world, bchunk, insideX, i, insideZ, state, state.func_177230_c().func_180664_k(), loadingCaving, loadingRedstone, mutableBlockPos, mutableBlockPos2, loadingColours, loadingTransparency, pixelBlockLights, pixelBlockStates, loadingLevels, pixelTransparentSizes, loadingFlowers)) continue;
            return state.func_177230_c();
        }
        return null;
    }

    private boolean findBlockHelp(World world, Chunk bchunk, int insideX, int i, int insideZ, BlockState state, BlockRenderLayer renderLayer, int loadingCaving, boolean loadingRedstone, BlockPos.MutableBlockPos mutableBlockPos, BlockPos.MutableBlockPos mutableBlockPos2, int loadingColours, boolean loadingTransparency, List<Integer> pixelBlockLights, List<BlockState> pixelBlockStates, int loadingLevels, List<Integer> pixelTransparentSizes, boolean loadingFlowers) {
        Block got = state.func_177230_c();
        if (!(got instanceof AirBlock) && (this.underair || loadingCaving == -1)) {
            boolean isRedstone = false;
            if (!(got instanceof FlowingFluidBlock) && state.func_185901_i() == BlockRenderType.INVISIBLE) {
                return false;
            }
            if (got == Blocks.field_150478_aa) {
                return false;
            }
            if (got == Blocks.field_150349_c) {
                return false;
            }
            if (got instanceof DoublePlantBlock) {
                return false;
            }
            if (!loadingFlowers && got instanceof BushBlock) {
                return false;
            }
            boolean bl = isRedstone = got == Blocks.field_150429_aA || got == Blocks.field_150488_af || got instanceof RepeaterBlock || got instanceof ComparatorBlock;
            if (!loadingRedstone && isRedstone) {
                return false;
            }
            this.blockY = i;
            BlockPos.MutableBlockPos globalPos = mutableBlockPos2.func_181079_c(bchunk.func_76632_l().field_77276_a * 16 + insideX, i, bchunk.func_76632_l().field_77275_b * 16 + insideZ);
            BlockPos.MutableBlockPos lightPos = mutableBlockPos.func_181079_c(globalPos.func_177958_n(), globalPos.func_177956_o() + 1, globalPos.func_177952_p());
            MaterialColor mapColor = state.func_185909_g((IBlockReader)world, (BlockPos)globalPos);
            if (!(isRedstone && loadingColours != 1 || mapColor != null && mapColor.field_76291_p != 0)) {
                return false;
            }
            if (this.currentComparisonCode == 0L) {
                this.firstBlockY = i;
                if (loadingLevels != 1 && loadingCaving != -1) {
                    this.sun = world.func_175642_b(LightType.SKY, (BlockPos)lightPos);
                }
            }
            int stateId = Block.func_196246_j((BlockState)state);
            if (loadingTransparency && (state == this.previousTransparentState || this.isTransparent(renderLayer, got))) {
                if (pixelBlockStates.size() < 5 && state != this.previousTransparentState) {
                    this.currentComparisonCode += (long)stateId & 0xFFFFFFFFL;
                    pixelBlockStates.add(state);
                    pixelTransparentSizes.add(1);
                    pixelBlockLights.add(loadingLevels == 1 ? 0 : world.func_175642_b(LightType.BLOCK, (BlockPos)lightPos));
                    this.previousTransparentState = state;
                } else {
                    pixelTransparentSizes.set(pixelTransparentSizes.size() - 1, pixelTransparentSizes.get(pixelTransparentSizes.size() - 1) + 1);
                }
                return false;
            }
            this.currentComparisonCode += (long)stateId & 0xFFFFFFFFL;
            this.currentComparisonCode <<= 29;
            this.currentComparisonCode |= (long)i << 21;
            pixelBlockLights.add(loadingLevels == 1 ? 0 : world.func_175642_b(LightType.BLOCK, (BlockPos)lightPos));
            pixelBlockStates.add(state);
            this.isglowing = this.isGlowing(state, world, (BlockPos)globalPos);
            return true;
        }
        if (got instanceof AirBlock) {
            this.underair = true;
        }
        return false;
    }

    private void calculateBlockColors(World world, Chunk bchunk, int insideX, int insideZ, BlockPos.MutableBlockPos mutableBlockPos2, List<Integer> pixelTransparentSizes, List<BlockState> pixelBlockStates, List<Integer> pixelBlockLights, int loadingColours, int loadingLightOverlayColor) {
        int firstBlockY = this.firstBlockY;
        BlockPos.MutableBlockPos globalPos = mutableBlockPos2.func_181079_c(bchunk.func_76632_l().field_77276_a * 16 + insideX, firstBlockY, bchunk.func_76632_l().field_77275_b * 16 + insideZ);
        if (!pixelTransparentSizes.isEmpty()) {
            for (int i = 0; i < pixelTransparentSizes.size(); ++i) {
                BlockState state = pixelBlockStates.get(i);
                Block b = state.func_177230_c();
                int size = pixelTransparentSizes.get(i);
                int opacity = state.func_200016_a((IBlockReader)bchunk.func_177412_p(), (BlockPos)globalPos);
                this.applyTransparentLayer(world, bchunk, b, state, opacity * size, (BlockPos)globalPos, pixelBlockLights.get(i));
                int nextY = globalPos.func_177956_o() - size;
                globalPos.func_185336_p(nextY);
            }
        }
        if (!pixelBlockStates.isEmpty()) {
            int color;
            BlockState state = pixelBlockStates.get(pixelBlockStates.size() - 1);
            Block b = state.func_177230_c();
            if (loadingColours == 1) {
                MaterialColor minimapColor = state.func_185909_g((IBlockReader)world, (BlockPos)globalPos);
                color = minimapColor.field_76291_p;
            } else {
                color = this.loadBlockColourFromTexture(world, state, b, (BlockPos)globalPos, true);
            }
            this.blockColor = this.addBlockColorMultipliers(color, state, world, (BlockPos)globalPos);
        }
    }

    private boolean isTransparent(BlockRenderLayer renderLayer, Block b) {
        Boolean cachedValue = this.transparentCache.get(b);
        if (cachedValue != null) {
            return cachedValue;
        }
        boolean transparent = renderLayer == BlockRenderLayer.TRANSLUCENT || b instanceof GlassBlock;
        this.transparentCache.put(b, transparent);
        return transparent;
    }

    private boolean isGlowing(BlockState state, World world, BlockPos pos) {
        Boolean cachedValue = this.glowingCache.get(state);
        if (cachedValue != null) {
            return cachedValue;
        }
        boolean isGlowing = false;
        try {
            isGlowing = state.getLightValue((IEnviromentBlockReader)world, pos) > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.glowingCache.put(state, isGlowing);
        return isGlowing;
    }

    private void applyTransparentLayer(World world, Chunk bchunk, Block b, BlockState state, int opacity, BlockPos globalPos, int blockLight) {
        float transparency;
        int red = 0;
        int green = 0;
        int blue = 0;
        float f = b instanceof FlowingFluidBlock ? 0.66f : (transparency = b instanceof IceBlock ? 0.83f : 0.5f);
        int color = this.loadingColours == 0 ? this.loadBlockColourFromTexture(world, state, b, globalPos, true) : (b instanceof FlowingFluidBlock ? -16751391 : state.func_185909_g((IBlockReader)world, (BlockPos)globalPos).field_76291_p);
        color = this.addBlockColorMultipliers(color, state, world, globalPos);
        red = color >> 16 & 0xFF;
        green = color >> 8 & 0xFF;
        blue = color & 0xFF;
        if (this.isGlowing(state, bchunk.func_177412_p(), globalPos)) {
            this.helper.getBrightestColour(red, green, blue, this.tempColor);
            red = this.tempColor[0];
            green = this.tempColor[1];
            blue = this.tempColor[2];
        }
        int i = 0;
        while (i < this.loadingLevels) {
            float overlayIntensity = this.currentTransparencyMultiplier * transparency * this.getBlockBrightness(9.0f, this.sun, i, blockLight);
            int n = i;
            this.underRed[n] = (int)((float)this.underRed[n] + (float)red * overlayIntensity);
            int n2 = i;
            this.underGreen[n2] = (int)((float)this.underGreen[n2] + (float)green * overlayIntensity);
            int n3 = i++;
            this.underBlue[n3] = (int)((float)this.underBlue[n3] + (float)blue * overlayIntensity);
        }
        this.currentTransparencyMultiplier *= 1.0f - transparency;
        this.sun -= opacity;
        if (this.sun < 0) {
            this.sun = 0;
        }
    }

    private int loadBlockColourFromTexture(World world, BlockState state, Block b, BlockPos pos, boolean convert) {
        int stateHash = Block.func_196246_j((BlockState)state);
        Integer c = this.blockColours.get(stateHash);
        int red = 0;
        int green = 0;
        int blue = 0;
        if (c == null) {
            String name = null;
            try {
                Integer cachedColour;
                TextureAtlasSprite texture;
                List upQuads = null;
                BlockModelShapes bms = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
                IBakedModel model = bms.func_178125_b(state);
                if (convert) {
                    upQuads = model.func_200117_a(state, Direction.UP, this.usedRandom);
                }
                TextureAtlasSprite missingTexture = Minecraft.func_71410_x().func_147117_R().func_195424_a(null);
                if (upQuads == null || upQuads.isEmpty() || ((BakedQuad)upQuads.get(0)).func_187508_a() == missingTexture) {
                    texture = bms.func_178122_a(state);
                    if (texture == missingTexture) {
                        List quads;
                        for (int i = Direction.values().length - 1; i >= 0 && (i == 1 || (quads = model.func_200117_a(state, Direction.values()[i], this.usedRandom)).isEmpty() || (texture = ((BakedQuad)quads.get(0)).func_187508_a()) == missingTexture); --i) {
                        }
                    }
                } else {
                    texture = ((BakedQuad)upQuads.get(0)).func_187508_a();
                }
                name = texture.func_195668_m() + ".png";
                if (b instanceof OreBlock && b != Blocks.field_196766_fg) {
                    name = "minecraft:block/stone.png";
                }
                c = -1;
                String[] args = name.split(":");
                if (args.length < 2) {
                    args = new String[]{"minecraft", args[0]};
                }
                if ((cachedColour = this.textureColours.get(name)) == null) {
                    ResourceLocation location = new ResourceLocation(args[0], "textures/" + args[1]);
                    IResource resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(location);
                    InputStream input = resource.func_199027_b();
                    BufferedImage img = ImageIO.read(input);
                    red = 0;
                    green = 0;
                    blue = 0;
                    int total = 64;
                    int tw = img.getWidth();
                    int diff = tw / 8;
                    for (int i = 0; i < 8; ++i) {
                        for (int j = 0; j < 8; ++j) {
                            int rgb = img.getRGB(i * diff, j * diff);
                            int alpha = rgb >> 24 & 0xFF;
                            if (rgb == 0 || alpha == 0) {
                                --total;
                                continue;
                            }
                            red += rgb >> 16 & 0xFF;
                            green += rgb >> 8 & 0xFF;
                            blue += rgb & 0xFF;
                        }
                    }
                    input.close();
                    if (total == 0) {
                        total = 1;
                    }
                    if (convert && (red /= total) == 0 && (green /= total) == 0 && (blue /= total) == 0) {
                        throw new Exception("Black texture");
                    }
                    c = 0xFF000000 | red << 16 | green << 8 | blue;
                    this.textureColours.put(name, c);
                } else {
                    c = cachedColour;
                }
            }
            catch (FileNotFoundException e) {
                if (convert) {
                    return this.loadBlockColourFromTexture(world, state, b, pos, false);
                }
                c = 0;
                if (state != null && state.func_185909_g((IBlockReader)world, pos) != null) {
                    c = state.func_185909_g((IBlockReader)world, (BlockPos)pos).field_76291_p;
                }
                if (name != null) {
                    this.textureColours.put(name, c);
                }
                System.out.println("Block file not found: " + b.getRegistryName());
            }
            catch (Exception e) {
                if (state.func_185909_g((IBlockReader)world, pos) != null) {
                    c = state.func_185909_g((IBlockReader)world, (BlockPos)pos).field_76291_p;
                }
                if (name != null) {
                    this.textureColours.put(name, c);
                }
                System.out.println("Exception when loading " + b.getRegistryName() + " texture, using material colour.");
                e.printStackTrace();
            }
            if (c != null) {
                this.blockColours.put(stateHash, c);
            }
        }
        return c;
    }

    private int addBlockColorMultipliers(int c, BlockState state, World world, BlockPos pos) {
        if (this.modMain.getSettings().getBlockColours() == 1 && !this.loadingBiomesVanillaMode) {
            return c;
        }
        int grassColor = 0xFFFFFF;
        try {
            grassColor = Minecraft.func_71410_x().func_184125_al().func_216860_a(state, (IEnviromentBlockReader)world, pos, 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (ReportedException reportedException) {
            // empty catch block
        }
        if (grassColor != 0xFFFFFF) {
            float rMultiplier = (float)(c >> 16 & 0xFF) / 255.0f;
            float gMultiplier = (float)(c >> 8 & 0xFF) / 255.0f;
            float bMultiplier = (float)(c & 0xFF) / 255.0f;
            int red = (int)((float)(grassColor >> 16 & 0xFF) * rMultiplier);
            int green = (int)((float)(grassColor >> 8 & 0xFF) * gMultiplier);
            int blue = (int)((float)(grassColor & 0xFF) * bMultiplier);
            c = 0xFF000000 | red << 16 | green << 8 | blue;
        }
        return c;
    }

    private boolean ignoreWorld(World world) {
        for (int i = 0; i < dimensionsToIgnore.length; ++i) {
            if (!dimensionsToIgnore[i].equals(WaypointsManager.getDimensionKey(world.func_201675_m().func_186058_p()).func_110623_a())) continue;
            return true;
        }
        return false;
    }

    private int getCaving(double playerX, double playerY, double playerZ, World world) {
        if (!this.modMain.getSettings().getCaveMaps()) {
            return -1;
        }
        if (this.ignoreWorld(world)) {
            return this.lastCaving;
        }
        int y = Math.max((int)playerY + 1, 0);
        if (y > 255 || y < 0) {
            return -1;
        }
        int x = OptimizedMath.myFloor(playerX);
        int z = OptimizedMath.myFloor(playerZ);
        this.mutableBlockPos.func_181079_c(x, y, z);
        Chunk bchunk = world.func_212866_a_(x >> 4, z >> 4);
        if (bchunk == null) {
            return -1;
        }
        int skyLight = world.func_175642_b(LightType.SKY, (BlockPos)this.mutableBlockPos);
        int roofRadius = this.modMain.getSettings().caveMaps - 1;
        int insideX = x & 0xF;
        int insideZ = z & 0xF;
        int bottom = y;
        int top = -1;
        boolean ignoringHeightmaps = this.modMain.getSettings().isIgnoreHeightmaps();
        if (skyLight < 15 && !ignoringHeightmaps) {
            top = bchunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, insideX, insideZ);
        } else if (ignoringHeightmaps) {
            ChunkSection[] sections = bchunk.func_76587_i();
            int playerSection = y >> 4;
            boolean foundSomething = false;
            for (int i = playerSection; i < sections.length; ++i) {
                ChunkSection searchedSection = sections[i];
                if (searchedSection == Chunk.field_186036_a) continue;
                if (!foundSomething) {
                    bottom = Math.max(bottom, i << 4);
                    foundSomething = true;
                }
                top = (i << 4) + 15;
            }
            if (!foundSomething) {
                return -1;
            }
        }
        if (top < 0) {
            return -1;
        }
        if (top > 255) {
            top = 255;
        }
        block1: for (int i = bottom; i <= top; ++i) {
            for (int o = x - roofRadius; o <= x + roofRadius; ++o) {
                for (int p = z - roofRadius; p <= z + roofRadius; ++p) {
                    this.mutableBlockPos.func_181079_c(o, i, p);
                    BlockState state = world.func_180495_p((BlockPos)this.mutableBlockPos);
                    if (!state.func_185904_a().func_76218_k() || state.func_177230_c() == Blocks.field_180401_cv) continue block1;
                }
            }
            this.lastCaving = Math.min(i, y + 3);
            return this.lastCaving;
        }
        return -1;
    }

    public int getSectionBasedHeight(Chunk bchunk, int startY) {
        ChunkSection searchedSection;
        int i;
        ChunkSection[] sections = bchunk.func_76587_i();
        int playerSection = startY >> 4;
        int result = -1;
        for (i = playerSection; i < sections.length; ++i) {
            searchedSection = sections[i];
            if (searchedSection == Chunk.field_186036_a) continue;
            result = (i << 4) + 15;
        }
        if (playerSection > 0 && result == -1) {
            for (i = playerSection - 1; i >= 0; --i) {
                searchedSection = sections[i];
                if (searchedSection == Chunk.field_186036_a) continue;
                result = (i << 4) + 15;
                break;
            }
        }
        return result;
    }

    public int getLoadSide() {
        return 9;
    }

    public int getUpdateRadiusInChunks() {
        return (int)Math.ceil((double)this.loadingSideInChunks / 2.0 / this.minimapSession.getMinimapProcessor().getMinimapZoom());
    }

    public int getMapCoord(int side, int coord) {
        return (coord >> 6) - side / 2;
    }

    public int getLoadedCaving() {
        return this.loadedCaving;
    }

    private boolean notEmptyColor(int[] red, int[] green, int[] blue) {
        return red[0] != 0 || green[0] != 0 || blue[0] != 0;
    }

    public float getBlockBrightness(float min, int sun, int lightLevel, int blockLight) {
        if (this.loadingLevels == 1) {
            return (min + (float)sun) / (15.0f + min);
        }
        return (min + Math.max((lightLevel == -1 || lightLevel == 0 ? 1.0f : ((float)this.loadingLevels - 1.0f - (float)lightLevel) / ((float)this.loadingLevels - 1.0f)) * (float)sun, (float)blockLight)) / (15.0f + min);
    }

    public MinimapChunk[][] getLoadedBlocks() {
        return this.loadedBlocks;
    }

    public int getLoadedMapChunkZ() {
        return this.loadedMapChunkZ;
    }

    public int getLoadedMapChunkX() {
        return this.loadedMapChunkX;
    }

    public int getLoadedLevels() {
        return this.loadedLevels;
    }

    public void setClearBlockColours(boolean clearBlockColours) {
        this.clearBlockColours = clearBlockColours;
    }

    public void setSeedForLoading(Long seedForLoading) {
        this.seedForLoading = seedForLoading;
    }

    public void cleanup() {
        if (this.loadedBlocks != null) {
            for (int i = 0; i < this.loadedBlocks.length; ++i) {
                for (int j = 0; j < this.loadedBlocks.length; ++j) {
                    MinimapChunk m = this.loadedBlocks[i][j];
                    if (m == null) continue;
                    m.cleanup(this.minimapInterface);
                }
            }
        }
    }
}

