/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.event;

import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import tschipp.carryon.client.keybinds.CarryOnKeybinds;
import tschipp.carryon.common.config.CarryOnConfig;
import tschipp.carryon.common.event.ItemEvents;
import tschipp.carryon.common.handler.ListHandler;
import tschipp.carryon.common.handler.PickupHandler;
import tschipp.carryon.common.handler.RegistrationHandler;
import tschipp.carryon.common.item.ItemEntity;
import tschipp.carryon.common.scripting.CarryOnOverride;
import tschipp.carryon.common.scripting.ScriptChecker;

public class ItemEntityEvents {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBlockClick(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() == RegistrationHandler.itemEntity && ItemEntity.hasEntityData(stack)) {
            String command;
            CarryOnOverride override;
            player.getEntityData().func_82580_o("carrySlot");
            event.setUseBlock(Event.Result.DENY);
            if (!player.field_70170_p.field_72995_K && (override = ScriptChecker.getOverride(player)) != null && (command = override.getCommandPlace()) != null) {
                player.func_184102_h().func_71187_D().func_71556_a((ICommandSender)player.func_184102_h(), "execute " + player.func_146103_bH().getName() + " ~ ~ ~ " + command);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onItemDropped(EntityJoinWorldEvent event) {
        EntityItem eitem;
        ItemStack stack;
        Item item;
        Entity e = event.getEntity();
        World world = event.getWorld();
        if (e instanceof EntityItem && (item = (stack = (eitem = (EntityItem)e).func_92059_d()).func_77973_b()) == RegistrationHandler.itemEntity && ItemEntity.hasEntityData(stack)) {
            BlockPos pos = eitem.func_180425_c();
            Entity entity = ItemEntity.getEntity(stack, world);
            entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            world.func_72838_d(entity);
            ItemEntity.clearEntityData(stack);
            eitem.func_92058_a(ItemStack.field_190927_a);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityRightClick(PlayerInteractEvent.EntityInteract event) {
        EntityPlayer player = event.getEntityPlayer();
        if (!(player instanceof EntityPlayerMP)) return;
        ItemStack main = player.func_184614_ca();
        ItemStack off = player.func_184592_cb();
        World world = event.getWorld();
        Entity entity = event.getTarget();
        BlockPos pos = entity.func_180425_c();
        if (main.func_190926_b() && off.func_190926_b() && CarryOnKeybinds.isKeyPressed(player)) {
            ItemStack stack = new ItemStack(RegistrationHandler.itemEntity);
            if (entity.field_70172_ad != 0) return;
            if (entity instanceof EntityAnimal) {
                ((EntityAnimal)entity).func_110160_i(true, true);
            }
            if (!PickupHandler.canPlayerPickUpEntity(player, entity)) return;
            if (!ItemEntity.storeEntityData(entity, world, stack)) return;
            if (entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                IItemHandler handler = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                for (int i = 0; i < handler.getSlots(); ++i) {
                    handler.extractItem(i, 64, false);
                }
            }
            CarryOnOverride override = ScriptChecker.inspectEntity(entity);
            int overrideHash = 0;
            if (override != null) {
                overrideHash = override.hashCode();
            }
            ItemEvents.sendPacket(player, player.field_71071_by.field_70461_c, overrideHash);
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_70606_j(0.0f);
            }
            entity.func_70106_y();
            player.func_184611_a(EnumHand.MAIN_HAND, stack);
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.FAIL);
            return;
        }
        if (main.func_190926_b()) return;
        if (main.func_77973_b() != RegistrationHandler.itemEntity) return;
        if (!ItemEntity.hasEntityData(main)) return;
        if (CarryOnKeybinds.isKeyPressed(player)) return;
        if (!CarryOnConfig.settings.stackableEntities) return;
        Entity entityHeld = ItemEntity.getEntity(main, world);
        if (entity.field_70172_ad != 0) return;
        if (!(entityHeld instanceof EntityLivingBase)) return;
        if (world.field_72995_K) return;
        if (entityHeld.func_110124_au() == entity.func_110124_au()) return;
        if (entityHeld.field_70128_L) return;
        if (entity.field_70128_L) return;
        double sizeHeldEntity = entityHeld.field_70131_O * entityHeld.field_70130_N;
        double distance = pos.func_177957_d(player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v);
        Entity lowestEntity = entity.func_184208_bv();
        int numPassengers = ItemEntityEvents.getAllPassengers(lowestEntity);
        if (numPassengers >= CarryOnConfig.settings.maxEntityStackLimit - 1) {
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187679_dF, SoundCategory.PLAYERS, 0.5f, 1.5f);
            return;
        }
        Entity topEntity = ItemEntityEvents.getTopPassenger(lowestEntity);
        if (CarryOnConfig.settings.useWhitelistStacking) {
            if (!ListHandler.isStackingAllowed(topEntity)) return;
        } else if (ListHandler.isStackingForbidden(topEntity)) return;
        double sizeEntity = topEntity.field_70131_O * topEntity.field_70130_N;
        if (!(CarryOnConfig.settings.entitySizeMattersStacking && sizeHeldEntity <= sizeEntity || !CarryOnConfig.settings.entitySizeMattersStacking)) {
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187679_dF, SoundCategory.PLAYERS, 0.5f, 1.5f);
            return;
        }
        if (topEntity instanceof EntityHorse) {
            EntityHorse horse = (EntityHorse)topEntity;
            horse.func_110234_j(true);
        }
        if (distance < 6.0) {
            double tempX = entity.field_70165_t;
            double tempY = entity.field_70163_u;
            double tempZ = entity.field_70161_v;
            entityHeld.func_70107_b(tempX, tempY + 2.6, tempZ);
            world.func_72838_d(entityHeld);
            entityHeld.func_184205_a(topEntity, false);
            entityHeld.func_70634_a(tempX, tempY, tempZ);
        } else {
            entityHeld.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            world.func_72838_d(entityHeld);
            entityHeld.func_184205_a(topEntity, false);
        }
        ItemEntity.clearEntityData(main);
        player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        ItemEvents.sendPacket(player, 9, 0);
        event.setCanceled(true);
        event.setCancellationResult(EnumActionResult.FAIL);
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187726_cu, SoundCategory.PLAYERS, 0.5f, 1.5f);
    }

    public static int getAllPassengers(Entity entity) {
        int passengers = 0;
        while (entity.func_184207_aI()) {
            List pass = entity.func_184188_bt();
            if (pass.isEmpty()) continue;
            entity = (Entity)pass.get(0);
            ++passengers;
        }
        return passengers;
    }

    public static Entity getTopPassenger(Entity entity) {
        Entity top = entity;
        while (entity.func_184207_aI()) {
            List pass = entity.func_184188_bt();
            if (pass.isEmpty()) continue;
            top = entity = (Entity)pass.get(0);
        }
        return top;
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        ItemStack main = entity.func_184614_ca();
        if (!main.func_190926_b() && main.func_77973_b() == RegistrationHandler.itemEntity && ItemEntity.hasEntityData(main)) {
            Entity contained;
            BlockPos pos = entity.func_180425_c();
            BlockPos below = pos.func_177972_a(EnumFacing.DOWN);
            if ((world.func_180495_p(pos).func_185904_a() == Material.field_151586_h || world.func_180495_p(below).func_185904_a() == Material.field_151586_h) && (contained = ItemEntity.getEntity(main, world)) != null) {
                float height = contained.field_70131_O;
                float width = contained.field_70130_N;
                entity.func_70024_g(0.0, -0.01 * (double)height * (double)width, 0.0);
            }
        }
    }
}

