/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import xyz.immortius.chunkbychunk.common.menus.WorldScannerMenu;

public class WorldScannerScreen
extends AbstractContainerScreen<WorldScannerMenu> {
    private static final ResourceLocation CONTAINER_TEXTURE = new ResourceLocation("chunkbychunk:textures/gui/container/worldscanner.png");
    private static final int MAIN_TEXTURE_DIM = 512;
    private static final int MAP_DIMENSIONS = 128;
    private static final float TICKS_PER_FRAME = 4.0f;
    private static final int NUM_FRAMES = 8;
    private float animCounter = 0.0f;
    private MapRenderer mapRenderer;

    public WorldScannerScreen(WorldScannerMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.f_97726_ = 310;
        this.f_97727_ = 166;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.mapRenderer = this.f_96541_.f_91063_.m_109151_();
    }

    public void m_7379_() {
        super.m_7379_();
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float delta) {
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, delta);
        this.m_7025_(stack, mouseX, mouseY);
    }

    protected void m_7025_(PoseStack stack, int cursorX, int cursorY) {
        super.m_7025_(stack, cursorX, cursorY);
        int mapX = cursorX - 174 - this.f_97735_;
        int mapY = cursorY - 18 - this.f_97736_;
        if (mapX >= 0 && mapY >= 0 && mapX < 128 && mapY < 128) {
            mapX = mapX / 4 - 15;
            mapY = mapY / 4 - 15;
            StringBuilder builder = new StringBuilder();
            if (mapY < 0) {
                builder.append(-mapY);
                builder.append(" N ");
            } else if (mapY > 0) {
                builder.append(mapY);
                builder.append(" S ");
            }
            if (mapX < 0) {
                builder.append(-mapX);
                builder.append(" W");
            } else if (mapX > 0) {
                builder.append(mapX);
                builder.append(" E");
            }
            if (builder.length() > 0) {
                this.m_96602_(stack, (Component)new TextComponent(builder.toString()), cursorX, cursorY);
            }
        }
    }

    protected void m_7286_(PoseStack stack, float delta, int mouseX, int mouseY) {
        this.animCounter += delta;
        while (this.animCounter > 32.0f) {
            this.animCounter -= 32.0f;
        }
        int frame = Mth.m_14143_((float)(this.animCounter / 4.0f));
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)CONTAINER_TEXTURE);
        this.m_93228_(stack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if (((WorldScannerMenu)this.f_97732_).getEnergy() > 0) {
            int display = Mth.m_14167_((float)(7.0f * (float)((WorldScannerMenu)this.f_97732_).getEnergy() / (float)((WorldScannerMenu)this.f_97732_).getMaxEnergy()));
            this.m_93228_(stack, this.f_97735_ + 54, this.f_97736_ + 56, 128 + 12 * display, 166 + 12 * frame, 13, 13);
        }
        if (((WorldScannerMenu)this.f_97732_).isMapAvailable()) {
            this.renderMap(stack);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)CONTAINER_TEXTURE);
        this.m_93228_(stack, this.f_97735_ + 234, this.f_97736_ + 78, 124, 166 + frame * 4, 4, 4);
    }

    private void renderMap(PoseStack stack) {
        stack.m_85836_();
        stack.m_85837_((double)(this.f_97735_ + 174), (double)(this.f_97736_ + 18), 1.0);
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        MapItemSavedData mapData = this.f_96541_.f_91073_.m_7489_(((WorldScannerMenu)this.f_97732_).getMapKey());
        if (mapData != null) {
            this.mapRenderer.m_168771_(stack, (MultiBufferSource)buffer, ((WorldScannerMenu)this.f_97732_).getMapId(), mapData, true, 0xFFFFFF);
        }
        buffer.m_109911_();
        stack.m_85849_();
    }

    public void m_93228_(PoseStack stack, int screenX, int screenY, int texX, int texY, int pixelWidth, int pixelHeight) {
        WorldScannerScreen.m_93143_((PoseStack)stack, (int)screenX, (int)screenY, (int)this.m_93252_(), (float)texX, (float)texY, (int)pixelWidth, (int)pixelHeight, (int)512, (int)512);
    }
}

