/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.client.uielements;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import xyz.immortius.chunkbychunk.client.uielements.IntegerSlider;
import xyz.immortius.chunkbychunk.config.ChunkByChunkConfig;
import xyz.immortius.chunkbychunk.config.system.BooleanFieldMetadata;
import xyz.immortius.chunkbychunk.config.system.ConfigMetadata;
import xyz.immortius.chunkbychunk.config.system.EnumFieldMetadata;
import xyz.immortius.chunkbychunk.config.system.FieldMetadata;
import xyz.immortius.chunkbychunk.config.system.IntFieldMetadata;
import xyz.immortius.chunkbychunk.config.system.MetadataBuilder;
import xyz.immortius.chunkbychunk.config.system.SectionMetadata;

public class SettingListWidget
extends ContainerObjectSelectionList<SettingEntry> {
    private EditBox lastFocused = null;
    private int rowWidth;

    public SettingListWidget(Minecraft minecraft, Screen parent, int width, int top, int bottom, int rowWidth) {
        super(minecraft, width, parent.f_96544_, top, bottom, 22);
        this.rowWidth = rowWidth;
        ConfigMetadata metadata = MetadataBuilder.build(ChunkByChunkConfig.class);
        ChunkByChunkConfig defaultConfig = new ChunkByChunkConfig();
        for (SectionMetadata section : metadata.getSections().values()) {
            Object defaultSection = section.getSectionObject(defaultConfig);
            Object configSection = section.getSectionObject(ChunkByChunkConfig.get());
            this.m_7085_((AbstractSelectionList.Entry)new SectionTitleEntry(section.getDisplayName()));
            for (FieldMetadata field : section.getFields().values()) {
                Object defaultValue;
                FieldMetadata fieldMetadata = field;
                if (fieldMetadata instanceof BooleanFieldMetadata) {
                    BooleanFieldMetadata boolField = (BooleanFieldMetadata)fieldMetadata;
                    defaultValue = (Boolean)boolField.getValue(defaultSection);
                    this.m_7085_((AbstractSelectionList.Entry)new BooleanEntry(field.getDisplayName(), () -> (Boolean)boolField.getValue(configSection), x -> boolField.setValue(configSection, x), (Boolean)defaultValue));
                    continue;
                }
                defaultValue = field;
                if (defaultValue instanceof EnumFieldMetadata) {
                    EnumFieldMetadata enumField = (EnumFieldMetadata)defaultValue;
                    defaultValue = (Enum)enumField.getValue(defaultSection);
                    this.m_7085_((AbstractSelectionList.Entry)new EnumEntry(enumField.getDisplayName(), enumField.enumType(), () -> (Enum)enumField.getValue(configSection), x -> enumField.setValue(configSection, x), (Enum<?>)defaultValue));
                    continue;
                }
                defaultValue = field;
                if (!(defaultValue instanceof IntFieldMetadata)) continue;
                IntFieldMetadata intField = (IntFieldMetadata)defaultValue;
                defaultValue = (Integer)intField.getValue(defaultSection);
                if (intField.getMaxValue() - intField.getMinValue() > 256) {
                    this.m_7085_((AbstractSelectionList.Entry)new ExtendedIntegerEntry(field.getDisplayName(), intField.getMinValue(), intField.getMaxValue(), () -> (Integer)intField.getValue(configSection), x -> intField.setValue(configSection, x), (Integer)defaultValue));
                    continue;
                }
                this.m_7085_((AbstractSelectionList.Entry)new IntegerEntry(field.getDisplayName(), intField.getMinValue(), intField.getMaxValue(), () -> (Integer)intField.getValue(configSection), x -> intField.setValue(configSection, x), (Integer)defaultValue));
            }
        }
    }

    public int m_5759_() {
        return this.rowWidth;
    }

    protected int m_5756_() {
        return this.f_93388_ / 2 + this.m_5759_() / 2 + 4;
    }

    public void tick() {
        this.m_6702_().forEach(SettingEntry::tick);
    }

    public void reset() {
        this.m_6702_().forEach(SettingEntry::reset);
    }

    public class SectionTitleEntry
    extends SettingEntry {
        private final Component displayName;

        public SectionTitleEntry(Component displayName) {
            this.displayName = displayName;
        }

        public void m_6311_(PoseStack stack, int listIndex, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
            ((SettingListWidget)SettingListWidget.this).f_93386_.f_91062_.m_92763_(stack, this.displayName, (float)(left + 12), (float)(top + 8), 0xFFFFFF);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return Collections.emptyList();
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }
    }

    public class BooleanEntry
    extends AbstractWidgetEntry<CycleButton<Boolean>> {
        private final Boolean defaultValue;

        public BooleanEntry(Component displayName, Supplier<Boolean> getter, Consumer<Boolean> setter, Boolean defaultValue) {
            super(SettingListWidget.this, (AbstractWidget)new CycleButton.Builder(x -> new TranslatableComponent(x != false ? "gui.yes" : "gui.no")).m_168961_((Object[])new Boolean[]{Boolean.FALSE, Boolean.TRUE}).m_168948_((Object)getter.get()).m_168936_(0, 0, SettingListWidget.this.m_5759_(), 20, displayName, (cycleButton, value) -> setter.accept((Boolean)value)));
            this.defaultValue = defaultValue;
        }

        @Override
        public void reset() {
            ((CycleButton)this.widget).m_168892_((Object)this.defaultValue);
        }
    }

    public class EnumEntry
    extends AbstractWidgetEntry<CycleButton<Enum<?>>> {
        private Enum<?> defaultValue;

        public EnumEntry(Component displayName, Class<? extends Enum<?>> type, Supplier<Enum<?>> getter, Consumer<Enum<?>> setter, Enum<?> defaultValue) {
            super(SettingListWidget.this, (AbstractWidget)new CycleButton.Builder(x -> new TranslatableComponent("enumvalue.chunkbychunk." + type.getSimpleName() + "." + x.name())).m_168961_((Object[])type.getEnumConstants()).m_168948_(getter.get()).m_168936_(0, 0, SettingListWidget.this.m_5759_(), 20, displayName, (cycleButton, value) -> setter.accept((Enum<?>)value)));
            this.defaultValue = defaultValue;
        }

        @Override
        public void reset() {
            ((CycleButton)this.widget).m_168892_(this.defaultValue);
        }
    }

    public class ExtendedIntegerEntry
    extends AbstractWidgetEntry<EditBox> {
        private final Component displayName;
        private final Integer defaultValue;

        public ExtendedIntegerEntry(Component displayName, int min, int max, Supplier<Integer> getter, Consumer<Integer> setter, Integer defaultValue) {
            super(SettingListWidget.this, (AbstractWidget)new EditBox(((SettingListWidget)SettingListWidget.this).f_93386_.f_91062_, 0, 0, SettingListWidget.this.m_5759_(), 20, displayName));
            this.displayName = displayName;
            this.defaultValue = defaultValue;
            ((EditBox)this.widget).m_94153_(x -> {
                if (x.isEmpty() || "-".equals(x)) {
                    return true;
                }
                try {
                    int val = Integer.parseInt(x);
                    return val >= min && val <= max;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            });
            ((EditBox)this.widget).m_94144_(getter.get().toString());
            ((EditBox)this.widget).m_94186_(true);
            ((EditBox)this.widget).m_94151_(value -> {
                if (value.isEmpty() || "-".equals(value)) {
                    if (0 >= min && 0 <= max) {
                        setter.accept(0);
                    }
                } else {
                    setter.accept(Integer.parseInt(value));
                }
            });
        }

        @Override
        public void reset() {
            ((EditBox)this.widget).m_94144_(this.defaultValue.toString());
        }

        @Override
        public boolean m_6375_(double x, double y, int mouseButton) {
            if (super.m_6375_(x, y, mouseButton)) {
                SettingListWidget.this.lastFocused = (EditBox)this.widget;
                return true;
            }
            return false;
        }

        @Override
        public void m_6311_(PoseStack stack, int listIndex, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
            int labelLength = ((SettingListWidget)SettingListWidget.this).f_93386_.f_91062_.m_92852_((FormattedText)this.displayName);
            ((SettingListWidget)SettingListWidget.this).f_93386_.f_91062_.m_92889_(stack, this.displayName, (float)left, (float)(top + 6), 0xFFFFFF);
            ((EditBox)this.widget).f_93620_ = left + labelLength + 6;
            ((EditBox)this.widget).m_93674_(SettingListWidget.this.m_5759_() - labelLength - 6);
            ((EditBox)this.widget).f_93621_ = top;
            ((EditBox)this.widget).m_6305_(stack, mouseX, mouseY, delta);
        }

        public boolean m_5534_(char p_94683_, int p_94684_) {
            return ((EditBox)this.widget).m_5534_(p_94683_, p_94684_);
        }

        @Override
        public void tick() {
            ((EditBox)this.widget).m_94120_();
        }
    }

    public class IntegerEntry
    extends AbstractWidgetEntry<IntegerSlider> {
        private final Integer defaultValue;

        public IntegerEntry(Component displayName, int min, int max, Supplier<Integer> getter, Consumer<Integer> setter, Integer defaultValue) {
            super(SettingListWidget.this, (AbstractWidget)new IntegerSlider(0, 0, SettingListWidget.this.m_5759_(), 20, displayName, min, max, getter, setter));
            this.defaultValue = defaultValue;
        }

        @Override
        public void reset() {
            ((IntegerSlider)this.widget).setValue(this.defaultValue);
        }
    }

    public static abstract class SettingEntry
    extends ContainerObjectSelectionList.Entry<SettingEntry> {
        public void tick() {
        }

        public void reset() {
        }
    }

    public static abstract class AbstractWidgetEntry<T extends AbstractWidget>
    extends SettingEntry {
        protected final T widget;
        private boolean dragging;
        final /* synthetic */ SettingListWidget this$0;

        public AbstractWidgetEntry(T widget) {
            this.this$0 = this$0;
            this.widget = widget;
        }

        public void m_6311_(PoseStack stack, int listIndex, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
            ((AbstractWidget)this.widget).f_93620_ = left;
            ((AbstractWidget)this.widget).f_93621_ = top;
            this.widget.m_6305_(stack, mouseX, mouseY, delta);
        }

        public boolean m_6375_(double x, double y, int mouseButton) {
            if (this.this$0.lastFocused != null && this.this$0.lastFocused != this.widget) {
                this.this$0.lastFocused.m_94178_(false);
            }
            this.dragging = true;
            return this.widget.m_6375_(x, y, mouseButton);
        }

        public boolean m_6348_(double x, double y, int mouseButton) {
            this.dragging = false;
            return this.widget.m_6348_(x, y, mouseButton);
        }

        public boolean m_7979_(double x, double y, int mouseButton, double deltaX, double deltaY) {
            if (this.dragging) {
                return this.widget.m_7979_(x, y, mouseButton, deltaX, deltaY);
            }
            return false;
        }

        public boolean m_5953_(double p_93537_, double p_93538_) {
            return this.widget.m_5953_(p_93537_, p_93538_);
        }

        public boolean m_7933_(int p_94710_, int p_94711_, int p_94712_) {
            return this.widget.m_7933_(p_94710_, p_94711_, p_94712_);
        }

        public boolean m_7920_(int p_94715_, int p_94716_, int p_94717_) {
            return this.widget.m_7920_(p_94715_, p_94716_, p_94717_);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return Collections.emptyList();
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.singletonList(this.widget);
        }
    }
}

