/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.common.blockEntities;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import xyz.immortius.chunkbychunk.common.world.SpawnChunkHelper;

public abstract class AbstractSpawnChunkBlockEntity
extends BlockEntity {
    private static final int TICKS_TO_SPAWN_CHUNK = 1;
    private static final int TICKS_TO_SPAWN_ENTITIES = 20;
    private final Function<BlockPos, ChunkPos> sourceChunkPosFunc;
    private int tickCounter = 0;

    public AbstractSpawnChunkBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, Function<BlockPos, ChunkPos> sourceChunkPosFunc) {
        super(blockEntityType, pos, state);
        this.sourceChunkPosFunc = sourceChunkPosFunc;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, AbstractSpawnChunkBlockEntity entity) {
        ChunkPos targetChunkPos;
        ServerLevel serverLevel = (ServerLevel)level;
        if (serverLevel.m_8795_(p -> true).isEmpty()) {
            return;
        }
        ++entity.tickCounter;
        if (entity.tickCounter == 1) {
            targetChunkPos = new ChunkPos(blockPos);
            if (SpawnChunkHelper.isValidForChunkSpawn(serverLevel) && SpawnChunkHelper.isEmptyChunk((LevelAccessor)serverLevel, targetChunkPos)) {
                SpawnChunkHelper.spawnChunkBlocks(serverLevel, entity.sourceChunkPosFunc.apply(blockPos), targetChunkPos);
            }
        }
        if (entity.tickCounter >= 20) {
            if (SpawnChunkHelper.isValidForChunkSpawn(serverLevel)) {
                targetChunkPos = new ChunkPos(blockPos);
                SpawnChunkHelper.spawnChunkEntities(serverLevel, entity.sourceChunkPosFunc.apply(blockPos), targetChunkPos);
            }
            if (serverLevel.m_8055_(blockPos) == blockState) {
                serverLevel.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
            }
        }
    }
}

