/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.common.blockEntities;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import xyz.immortius.chunkbychunk.interop.SidedBlockEntityInteropBase;

public abstract class BaseFueledBlockEntity
extends SidedBlockEntityInteropBase {
    private final int fuelSlot;
    private final Map<Item, FuelValueSupplier> fuel;
    private int remainingFuel;
    private int chargedFuel;
    private NonNullList<ItemStack> items;

    protected BaseFueledBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, int numItemSlots, int fuelSlot, Map<Item, FuelValueSupplier> fuel) {
        super(blockEntityType, pos, state);
        this.items = NonNullList.m_122780_((int)numItemSlots, (Object)ItemStack.f_41583_);
        this.fuelSlot = fuelSlot;
        this.fuel = fuel;
    }

    public int getChargedFuel() {
        return this.chargedFuel;
    }

    public int getRemainingFuel() {
        return this.remainingFuel;
    }

    public void setRemainingFuel(int value) {
        this.remainingFuel = value;
    }

    protected int consumeFuel(int amount) {
        int consumed = Math.min(amount, this.remainingFuel);
        this.remainingFuel -= consumed;
        return consumed;
    }

    protected boolean checkConsumeFuelItem() {
        ItemStack fuelItem = (ItemStack)this.items.get(this.fuelSlot);
        if (this.remainingFuel == 0 && this.isFuel(fuelItem)) {
            this.chargedFuel = this.remainingFuel = this.getFuelValue(fuelItem);
            fuelItem.m_41774_(1);
            return true;
        }
        return false;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.chargedFuel = tag.m_128451_("ChargedFuel");
        this.remainingFuel = tag.m_128451_("RemainingFuel");
    }

    public CompoundTag m_6945_(CompoundTag tag) {
        CompoundTag result = super.m_6945_(tag);
        result.m_128405_("ChargedFuel", this.chargedFuel);
        result.m_128405_("RemainingFuel", this.remainingFuel);
        ContainerHelper.m_18973_((CompoundTag)result, this.items);
        return result;
    }

    public boolean isFuel(ItemStack itemStack) {
        return this.fuel.getOrDefault(itemStack.m_41720_(), () -> 0).get() > 0;
    }

    public int getFuelValue(ItemStack itemStack) {
        return this.fuel.getOrDefault(itemStack.m_41720_(), () -> 0).get();
    }

    public int m_6643_() {
        return this.items.size();
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public ItemStack m_7407_(int slot, int split) {
        return ContainerHelper.m_18969_(this.items, (int)slot, (int)split);
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.items, (int)slot);
    }

    public void m_6836_(int slot, ItemStack newItem) {
        this.items.set(slot, (Object)newItem);
        if (newItem.m_41613_() > this.m_6893_()) {
            newItem.m_41764_(this.m_6893_());
        }
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void m_5809_(StackedContents contents) {
        for (ItemStack itemstack : this.items) {
            contents.m_36491_(itemstack);
        }
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public boolean m_7155_(int slot, ItemStack itemStack, Direction direction) {
        return this.m_7013_(slot, itemStack);
    }

    public boolean m_7013_(int slot, ItemStack item) {
        if (slot == this.fuelSlot) {
            return this.isFuel(item);
        }
        return true;
    }

    @FunctionalInterface
    public static interface FuelValueSupplier {
        public int get();
    }
}

