/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.common.blockEntities;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import xyz.immortius.chunkbychunk.common.blockEntities.BaseFueledBlockEntity;
import xyz.immortius.chunkbychunk.common.menus.WorldForgeMenu;
import xyz.immortius.chunkbychunk.config.ChunkByChunkConfig;
import xyz.immortius.chunkbychunk.interop.CBCInteropMethods;
import xyz.immortius.chunkbychunk.interop.ChunkByChunkConstants;

public class WorldForgeBlockEntity
extends BaseFueledBlockEntity {
    public static final int NUM_ITEM_SLOTS = 2;
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_RESULT = 1;
    public static final int NUM_DATA_ITEMS = 2;
    public static final int DATA_PROGRESS = 0;
    public static final int DATA_GOAL = 1;
    private static final int GROW_CRYSTAL_AT = 4;
    private static final Map<Item, BaseFueledBlockEntity.FuelValueSupplier> FUEL;
    private static final Map<Item, BaseFueledBlockEntity.FuelValueSupplier> CRYSTAL_COSTS;
    private static final Item INITIAL_CRYSTAL;
    private static final Map<Item, Item> CRYSTAL_STEPS;
    private static final int[] SLOTS_FOR_UP;
    private static final int[] SLOTS_FOR_DOWN;
    private int progress;
    private int goal;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int id) {
            switch (id) {
                case 0: {
                    return WorldForgeBlockEntity.this.progress;
                }
                case 1: {
                    return WorldForgeBlockEntity.this.goal;
                }
            }
            return 0;
        }

        public void m_8050_(int id, int value) {
            switch (id) {
                case 0: {
                    WorldForgeBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    WorldForgeBlockEntity.this.goal = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public WorldForgeBlockEntity(BlockPos pos, BlockState state) {
        super(ChunkByChunkConstants.worldForgeEntity(), pos, state, 2, 0, FUEL);
    }

    protected Component m_6820_() {
        return new TranslatableComponent("container.chunkbychunk.worldforge");
    }

    protected AbstractContainerMenu m_6555_(int menuId, Inventory inventory) {
        return new WorldForgeMenu(menuId, inventory, (Container)this, this.dataAccess);
    }

    public static boolean isWorldForgeFuel(ItemStack itemStack) {
        return FUEL.getOrDefault(itemStack.m_41720_(), () -> 0).get() > 0;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("Progress");
    }

    @Override
    public CompoundTag m_6945_(CompoundTag tag) {
        CompoundTag result = super.m_6945_(tag);
        result.m_128405_("Progress", this.progress);
        return result;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, WorldForgeBlockEntity entity) {
        ItemStack outputItems;
        if (entity.getRemainingFuel() > 0) {
            int consumeAmount = entity.consumeFuel(ChunkByChunkConfig.get().getWorldForge().getProductionRate());
            entity.progress += consumeAmount;
        }
        Item producingItem = (outputItems = entity.m_8020_(1)).m_41619_() ? INITIAL_CRYSTAL : outputItems.m_41720_();
        if (outputItems.m_41613_() == outputItems.m_41741_()) {
            return;
        }
        boolean changed = entity.checkConsumeFuelItem();
        int itemCost = CRYSTAL_COSTS.get(producingItem).get();
        Item nextItem = CRYSTAL_STEPS.get(producingItem);
        entity.goal = itemCost;
        if (entity.progress >= itemCost) {
            entity.progress -= itemCost;
            changed = true;
            if (outputItems.m_41619_()) {
                entity.m_6836_(1, producingItem.m_7968_());
            } else if (outputItems.m_41613_() == 3 && nextItem != null) {
                entity.m_6836_(1, nextItem.m_7968_());
                entity.goal = CRYSTAL_COSTS.get(nextItem).get();
            } else {
                outputItems.m_41769_(1);
            }
        }
        if (changed) {
            WorldForgeBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)blockState);
        }
    }

    public int[] m_7071_(Direction direction) {
        if (direction == Direction.UP) {
            return SLOTS_FOR_UP;
        }
        return SLOTS_FOR_DOWN;
    }

    public boolean m_7157_(int slot, ItemStack itemStack, Direction direction) {
        return slot == 1;
    }

    @Override
    public boolean m_7013_(int slot, ItemStack item) {
        if (slot == 1) {
            return false;
        }
        return super.m_7013_(slot, item);
    }

    static {
        INITIAL_CRYSTAL = ChunkByChunkConstants.worldFragmentItem();
        SLOTS_FOR_UP = new int[]{0};
        SLOTS_FOR_DOWN = new int[]{1};
        ImmutableMap.Builder fuelBuilder = ImmutableMap.builder();
        for (Item value : CBCInteropMethods.getTaggedItems("chunkbychunk:weakworldforgefuel")) {
            fuelBuilder.put((Object)value, () -> ChunkByChunkConfig.get().getWorldForge().getSoilFuelValue());
        }
        for (Item value : CBCInteropMethods.getTaggedItems("chunkbychunk:worldforgefuel")) {
            fuelBuilder.put((Object)value, () -> ChunkByChunkConfig.get().getWorldForge().getStoneFuelValue());
        }
        for (Item value : CBCInteropMethods.getTaggedItems("chunkbychunk:strongworldforgefuel")) {
            fuelBuilder.put((Object)value, () -> ChunkByChunkConfig.get().getWorldForge().getStrongFuelValue());
        }
        fuelBuilder.put((Object)ChunkByChunkConstants.worldFragmentItem(), () -> ChunkByChunkConfig.get().getWorldForge().getFragmentFuelCost());
        fuelBuilder.put((Object)ChunkByChunkConstants.worldShardItem(), () -> ChunkByChunkConfig.get().getWorldForge().getFragmentFuelCost() * 4);
        fuelBuilder.put((Object)ChunkByChunkConstants.worldCrystalItem(), () -> ChunkByChunkConfig.get().getWorldForge().getFragmentFuelCost() * 16);
        FUEL = fuelBuilder.build();
        CRYSTAL_COSTS = ImmutableMap.builder().put((Object)ChunkByChunkConstants.worldFragmentItem(), () -> ChunkByChunkConfig.get().getWorldForge().getFragmentFuelCost()).put((Object)ChunkByChunkConstants.worldShardItem(), () -> ChunkByChunkConfig.get().getWorldForge().getFragmentFuelCost() * 4).put((Object)ChunkByChunkConstants.worldCrystalItem(), () -> ChunkByChunkConfig.get().getWorldForge().getFragmentFuelCost() * 16).put((Object)ChunkByChunkConstants.worldCoreBlockItem(), () -> ChunkByChunkConfig.get().getWorldForge().getFragmentFuelCost() * 64).build();
        CRYSTAL_STEPS = ImmutableMap.builder().put((Object)ChunkByChunkConstants.worldFragmentItem(), (Object)ChunkByChunkConstants.worldShardItem()).put((Object)ChunkByChunkConstants.worldShardItem(), (Object)ChunkByChunkConstants.worldCrystalItem()).put((Object)ChunkByChunkConstants.worldCrystalItem(), (Object)ChunkByChunkConstants.worldCrystalItem()).build();
    }
}

