/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.common.blockEntities;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import xyz.immortius.chunkbychunk.common.blockEntities.BaseFueledBlockEntity;
import xyz.immortius.chunkbychunk.common.menus.WorldScannerMenu;
import xyz.immortius.chunkbychunk.common.util.ChunkUtil;
import xyz.immortius.chunkbychunk.common.util.ColorUtil;
import xyz.immortius.chunkbychunk.common.util.SpiralIterator;
import xyz.immortius.chunkbychunk.common.world.SkyChunkGenerator;
import xyz.immortius.chunkbychunk.config.ChunkByChunkConfig;
import xyz.immortius.chunkbychunk.interop.CBCInteropMethods;
import xyz.immortius.chunkbychunk.interop.ChunkByChunkConstants;

public class WorldScannerBlockEntity
extends BaseFueledBlockEntity {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_FUEL = 1;
    public static final int NUM_ITEM_SLOTS = 2;
    public static final int DATA_MAP = 0;
    public static final int DATA_ENERGY = 1;
    public static final int DATA_MAX_ENERGY = 2;
    public static final int DATA_SCANNING_X = 3;
    public static final int DATA_SCANNING_Z = 4;
    public static final int NUM_DATA_ITEMS = 5;
    public static final int SCAN_CENTER = 15;
    public static final int SCAN_ZOOM = 4;
    public static final int NO_MAP = -1;
    private static final int TICKS_BETWEEN_REPLICATES = 11;
    private static final Map<Item, BaseFueledBlockEntity.FuelValueSupplier> FUEL;
    private static final int[] SLOTS_FOR_UP;
    private static final int[] SLOTS_FOR_SIDES;
    private static final int[] SLOTS_FOR_DOWN;
    private static final byte[] SCAN_COLOR_PALETTE;
    private static final Multimap<Item, Block> SCAN_ITEM_MAPPINGS;
    private static final int[] SCAN_COLOR_THRESHOLD;
    private int map = -1;
    private int scanCharge = 0;
    private final SpiralIterator scanIterator = new SpiralIterator();
    private int tickUntilReplicate = 0;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int id) {
            return switch (id) {
                case 0 -> WorldScannerBlockEntity.this.map;
                case 1 -> WorldScannerBlockEntity.this.getRemainingFuel();
                case 2 -> WorldScannerBlockEntity.this.getChargedFuel();
                case 3 -> WorldScannerBlockEntity.this.scanIterator.getX();
                case 4 -> WorldScannerBlockEntity.this.scanIterator.getY();
                default -> 0;
            };
        }

        public void m_8050_(int id, int value) {
            switch (id) {
                case 0: {
                    WorldScannerBlockEntity.this.map = value;
                }
            }
        }

        public int m_6499_() {
            return 5;
        }
    };

    public WorldScannerBlockEntity(BlockPos pos, BlockState state) {
        super(ChunkByChunkConstants.worldScannerEntity(), pos, state, 2, 1, FUEL);
    }

    protected Component m_6820_() {
        return new TranslatableComponent("container.chunkbychunk.worldscanner");
    }

    protected AbstractContainerMenu m_6555_(int menuId, Inventory inventory) {
        return new WorldScannerMenu(menuId, inventory, (Container)this, this.dataAccess);
    }

    public static boolean isWorldScannerFuel(ItemStack itemStack) {
        return FUEL.getOrDefault(itemStack.m_41720_(), () -> 0).get() > 0;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.map = tag.m_128451_("Map");
        this.scanIterator.load(tag.m_128469_("ScanIterator"));
        this.scanCharge = tag.m_128451_("ScanCharge");
    }

    @Override
    public CompoundTag m_6945_(CompoundTag tag) {
        CompoundTag result = super.m_6945_(tag);
        result.m_128405_("Map", this.map);
        result.m_128365_("ScanIterator", (Tag)this.scanIterator.createTag());
        result.m_128405_("ScanCharge", this.scanCharge);
        return result;
    }

    private boolean validTarget() {
        ItemStack targetItem = this.m_8020_(0);
        Item item = targetItem.m_41720_();
        if (item instanceof BucketItem) {
            BucketItem bucket = (BucketItem)item;
            return CBCInteropMethods.getBucketContents(bucket) instanceof FlowingFluid;
        }
        return targetItem.m_41720_() instanceof BlockItem || SCAN_ITEM_MAPPINGS.keySet().contains(targetItem.m_41720_());
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, WorldScannerBlockEntity entity) {
        ServerLevel serverLevel = (ServerLevel)level;
        boolean changed = false;
        if (entity.scanIterator.getX() >= 0 && entity.validTarget()) {
            ItemStack targetItem = entity.m_8020_(0);
            if (entity.getRemainingFuel() > 0) {
                int consumeAmount = entity.consumeFuel(ChunkByChunkConfig.get().getWorldScannerConfig().getFuelConsumedPerTick());
                entity.scanCharge += consumeAmount;
            }
            changed = entity.checkConsumeFuelItem();
            int chunkCost = ChunkByChunkConfig.get().getWorldScannerConfig().getFuelRequiredPerChunk();
            if (entity.scanCharge >= chunkCost) {
                if (entity.map == -1) {
                    entity.createMap();
                }
                ChunkPos originChunkPos = new ChunkPos(blockPos);
                int chunkX = entity.scanIterator.getX() + originChunkPos.f_45578_ - 15;
                int chunkZ = entity.scanIterator.getY() + originChunkPos.f_45579_ - 15;
                ServerLevel scanLevel = serverLevel.m_7726_().m_8481_() instanceof SkyChunkGenerator ? serverLevel.m_142572_().m_129880_(ChunkByChunkConstants.SKY_CHUNK_GENERATION_LEVEL) : serverLevel;
                LevelChunk chunk = scanLevel.m_6325_(chunkX, chunkZ);
                HashSet<Block> scanForBlocks = new HashSet<Block>();
                Collection mappings = SCAN_ITEM_MAPPINGS.get((Object)targetItem.m_41720_());
                if (!mappings.isEmpty()) {
                    scanForBlocks.addAll(mappings);
                } else {
                    Item item = targetItem.m_41720_();
                    if (item instanceof BucketItem) {
                        BucketItem bucket = (BucketItem)item;
                        scanForBlocks.add(CBCInteropMethods.getBucketContents(bucket).m_76145_().m_76188_().m_60734_());
                    } else {
                        item = targetItem.m_41720_();
                        if (item instanceof BlockItem) {
                            BlockItem blockItem = (BlockItem)item;
                            scanForBlocks.add(blockItem.m_40614_());
                        }
                    }
                }
                int blockCount = ChunkUtil.countBlocks((ChunkAccess)chunk, scanForBlocks);
                byte color = ColorUtil.encode(MaterialColor.f_76365_, 1);
                for (int i = 0; i < SCAN_COLOR_THRESHOLD.length; ++i) {
                    color = SCAN_COLOR_PALETTE[i];
                    if (blockCount <= SCAN_COLOR_THRESHOLD[i]) break;
                }
                MapItemSavedData data = entity.m_58904_().m_7489_(MapItem.m_42848_((int)entity.map));
                for (int innerX = 0; innerX < 4; ++innerX) {
                    for (int innerZ = 0; innerZ < 4; ++innerZ) {
                        int pixelX = entity.scanIterator.getX() * 4 + innerX;
                        int pixelY = entity.scanIterator.getY() * 4 + innerZ;
                        data.m_164803_(pixelX, pixelY, color);
                    }
                }
                entity.scanIterator.next();
                entity.scanCharge -= chunkCost;
                changed = true;
            }
        }
        if (changed) {
            WorldScannerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)blockState);
        }
        if (changed || entity.tickUntilReplicate <= 0) {
            MapItemSavedData mapitemsaveddata = level.m_7489_(MapItem.m_42848_((int)entity.map));
            if (mapitemsaveddata != null) {
                for (ServerPlayer serverplayer : serverLevel.m_6907_()) {
                    mapitemsaveddata.m_77916_((Player)serverplayer);
                    Packet packet = mapitemsaveddata.m_164796_(entity.map, (Player)serverplayer);
                    if (packet == null) continue;
                    serverplayer.f_8906_.m_141995_(packet);
                }
            }
            entity.tickUntilReplicate = 11;
        } else {
            --entity.tickUntilReplicate;
        }
    }

    private void createMap() {
        if (this.map == -1) {
            ChunkPos pos = new ChunkPos(this.m_58899_());
            MapItemSavedData data = MapItemSavedData.m_164780_((double)pos.m_45608_(), (double)pos.m_45609_(), (byte)2, (boolean)false, (boolean)false, (ResourceKey)this.f_58857_.m_46472_()).m_164775_();
            this.map = this.f_58857_.m_7354_();
            this.f_58857_.m_142325_(MapItem.m_42848_((int)this.map), data);
        }
    }

    public int[] m_7071_(Direction direction) {
        return switch (direction) {
            case Direction.UP -> SLOTS_FOR_UP;
            case Direction.DOWN -> SLOTS_FOR_DOWN;
            default -> SLOTS_FOR_SIDES;
        };
    }

    public boolean m_7157_(int slot, ItemStack itemStack, Direction direction) {
        return slot == 0;
    }

    @Override
    public void m_6836_(int slot, ItemStack newItem) {
        boolean targetUnchanged = true;
        if (slot == 0) {
            ItemStack itemStack = this.m_8020_(slot);
            targetUnchanged = !newItem.m_41619_() && newItem.m_41656_(itemStack);
        }
        super.m_6836_(slot, newItem);
        if (!targetUnchanged) {
            this.resetScan();
        }
    }

    private void resetScan() {
        MapItemSavedData data;
        if (this.map != -1 && (data = this.m_58904_().m_7489_(MapItem.m_42848_((int)this.map))) != null) {
            for (int x = 0; x < 128; ++x) {
                for (int y = 0; y < 128; ++y) {
                    data.m_164803_(x, y, ColorUtil.encode(MaterialColor.f_76398_, 1));
                }
            }
        }
        this.scanIterator.reset(15, 15);
        this.m_6596_();
    }

    static {
        SLOTS_FOR_UP = new int[]{0};
        SLOTS_FOR_SIDES = new int[]{1};
        SLOTS_FOR_DOWN = new int[]{1};
        SCAN_COLOR_PALETTE = new byte[]{ColorUtil.encode(MaterialColor.f_76365_, 1), ColorUtil.encode(MaterialColor.f_76371_, 3), ColorUtil.encode(MaterialColor.f_76371_, 0), ColorUtil.encode(MaterialColor.f_76371_, 1), ColorUtil.encode(MaterialColor.f_76371_, 2), ColorUtil.encode(MaterialColor.f_76364_, 3), ColorUtil.encode(MaterialColor.f_76364_, 0), ColorUtil.encode(MaterialColor.f_76364_, 1), ColorUtil.encode(MaterialColor.f_76364_, 2), ColorUtil.encode(MaterialColor.f_76376_, 2), ColorUtil.encode(MaterialColor.f_76416_, 2), ColorUtil.encode(MaterialColor.f_76366_, 2), ColorUtil.encode(MaterialColor.f_76406_, 2)};
        SCAN_ITEM_MAPPINGS = ImmutableMultimap.builder().putAll((Object)Items.f_151053_, (Object[])new Block[]{Blocks.f_49995_, Blocks.f_152467_, Blocks.f_49998_, Blocks.f_152600_}).putAll((Object)Items.f_151050_, (Object[])new Block[]{Blocks.f_49996_, Blocks.f_152468_, Blocks.f_152598_}).putAll((Object)Items.f_151051_, (Object[])new Block[]{Blocks.f_152505_, Blocks.f_152506_, Blocks.f_152599_}).putAll((Object)Items.f_42415_, (Object[])new Block[]{Blocks.f_50089_, Blocks.f_152474_}).putAll((Object)Items.f_42616_, (Object[])new Block[]{Blocks.f_50264_, Blocks.f_152479_}).putAll((Object)Items.f_42413_, (Object[])new Block[]{Blocks.f_49997_, Blocks.f_152469_}).putAll((Object)Items.f_42534_, (Object[])new Block[]{Blocks.f_50059_, Blocks.f_152472_}).putAll((Object)Items.f_42451_, (Object[])new Block[]{Blocks.f_50173_, Blocks.f_152473_}).build();
        SCAN_COLOR_THRESHOLD = new int[]{0, 1, 8, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384};
        FUEL = ImmutableMap.builder().put((Object)ChunkByChunkConstants.worldFragmentItem(), () -> ChunkByChunkConfig.get().getWorldScannerConfig().getFuelPerFragment()).put((Object)ChunkByChunkConstants.worldShardItem(), () -> 4 * ChunkByChunkConfig.get().getWorldScannerConfig().getFuelPerFragment()).put((Object)ChunkByChunkConstants.worldCrystalItem(), () -> 16 * ChunkByChunkConfig.get().getWorldScannerConfig().getFuelPerFragment()).put((Object)ChunkByChunkConstants.worldCoreBlockItem(), () -> 64 * ChunkByChunkConfig.get().getWorldScannerConfig().getFuelPerFragment()).build();
    }
}

