/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.common.blocks;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xyz.immortius.chunkbychunk.common.world.SpawnChunkHelper;
import xyz.immortius.chunkbychunk.interop.ChunkByChunkConstants;

public abstract class AbstractTriggeredSpawnChunkBlock
extends BaseEntityBlock {
    private Function<BlockPos, ChunkPos> sourceChunkFunc;

    public AbstractTriggeredSpawnChunkBlock(BlockBehaviour.Properties blockProperties, Function<BlockPos, ChunkPos> sourceChunkFunc) {
        super(blockProperties);
        this.sourceChunkFunc = sourceChunkFunc;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collisionContext) {
        return Shapes.m_83040_();
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState prevState, boolean p_60570_) {
        super.m_6807_(state, level, pos, prevState, p_60570_);
        if (!level.m_5776_()) {
            ServerLevel targetLevel = (ServerLevel)level;
            ServerLevel sourceLevel = level.m_142572_().m_129880_(ChunkByChunkConstants.SKY_CHUNK_GENERATION_LEVEL);
            if (sourceLevel != null && SpawnChunkHelper.isValidForChunkSpawn(targetLevel)) {
                ChunkPos sourceChunkPos = this.sourceChunkFunc.apply(pos);
                sourceLevel.m_8602_(sourceChunkPos.f_45578_, sourceChunkPos.f_45579_, true);
            }
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState prevState, boolean p_60519_) {
        super.m_6810_(state, level, pos, prevState, p_60519_);
        if (!level.m_5776_()) {
            ServerLevel targetLevel = (ServerLevel)level;
            ServerLevel sourceLevel = level.m_142572_().m_129880_(ChunkByChunkConstants.SKY_CHUNK_GENERATION_LEVEL);
            if (sourceLevel != null && SpawnChunkHelper.isValidForChunkSpawn(targetLevel)) {
                ChunkPos sourceChunkPos = this.sourceChunkFunc.apply(pos);
                sourceLevel.m_8602_(sourceChunkPos.f_45578_, sourceChunkPos.f_45579_, false);
            }
        }
    }
}

