/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.common.blocks;

import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import xyz.immortius.chunkbychunk.common.world.SpawnChunkHelper;
import xyz.immortius.chunkbychunk.interop.ChunkByChunkConstants;

public abstract class BaseSpawnChunkBlock
extends Block {
    private static final EnumSet<Direction> HORIZONTAL_DIR = EnumSet.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST);

    public BaseSpawnChunkBlock(BlockBehaviour.Properties blockProperties) {
        super(blockProperties);
    }

    public abstract BlockState getTriggeredBlockState();

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        Level level2 = level;
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            ArrayList<BlockPos> targetPositions = new ArrayList<BlockPos>();
            BlockPos initialPos = pos.m_175288_(level.m_151558_() - 1);
            targetPositions.add(initialPos);
            Direction targetDirection = hit.m_82434_();
            if (!HORIZONTAL_DIR.contains(targetDirection)) {
                targetDirection = Direction.NORTH;
            }
            targetPositions.add(initialPos.m_142300_(targetDirection.m_122424_()));
            targetPositions.add(initialPos.m_142300_(targetDirection.m_122428_()));
            targetPositions.add(initialPos.m_142300_(targetDirection.m_122427_()));
            targetPositions.add(initialPos.m_142300_(targetDirection));
            for (BlockPos targetPos : targetPositions) {
                ChunkPos targetChunkPos = new ChunkPos(targetPos);
                if (!SpawnChunkHelper.isValidForChunkSpawn(serverLevel) || !SpawnChunkHelper.isEmptyChunk((LevelAccessor)serverLevel, targetChunkPos)) continue;
                serverLevel.m_7731_(targetPos, this.getTriggeredBlockState(), 3);
                if (!pos.equals((Object)targetPos)) {
                    serverLevel.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                }
                level.m_5594_(null, pos, ChunkByChunkConstants.spawnChunkSoundEffect(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }
}

