/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.common.blocks;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.BlockHitResult;
import xyz.immortius.chunkbychunk.common.blockEntities.BedrockChestBlockEntity;
import xyz.immortius.chunkbychunk.config.ChunkByChunkConfig;

public class BedrockChestBlock
extends BaseEntityBlock {
    public BedrockChestBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BedrockChestBlockEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_5833_()) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockentity = level.m_7702_(pos);
        BlockEntity blockEntity = blockentity;
        if (blockEntity instanceof BedrockChestBlockEntity) {
            BedrockChestBlockEntity bedrockChestBlockEntity = (BedrockChestBlockEntity)blockEntity;
            int blockCount = BedrockChestBlock.getBlockCount(level, new ChunkPos(pos), pos.m_123342_());
            if (blockCount <= ChunkByChunkConfig.get().getBedrockChest().getBedrockChestBlocksRemainingThreshold()) {
                player.m_5893_((MenuProvider)bedrockChestBlockEntity);
            } else {
                player.m_5661_((Component)new TranslatableComponent("ui.chunkbychunk.bedrockchest.sealedmessage", new Object[]{new TextComponent(Integer.toString(blockCount - ChunkByChunkConfig.get().getBedrockChest().getBedrockChestBlocksRemainingThreshold())).m_130940_(ChatFormatting.RED)}), true);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private static int getBlockCount(Level level, ChunkPos chunkPos, int aboveY) {
        LevelChunk chunk = level.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
        int count = 0;
        for (int x = chunkPos.m_45604_(); x < chunkPos.m_45608_(); ++x) {
            for (int y = aboveY + 1; y < level.m_151558_(); ++y) {
                for (int z = chunkPos.m_45605_(); z < chunkPos.m_45609_(); ++z) {
                    Block block = chunk.m_8055_(new BlockPos(x, y, z)).m_60734_();
                    if (block instanceof AirBlock || block instanceof LiquidBlock || block instanceof LadderBlock || block instanceof LeavesBlock || block == Blocks.f_152475_ || block == Blocks.f_50191_ || block instanceof TorchBlock) continue;
                    ++count;
                }
            }
        }
        return count;
    }
}

