/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import xyz.immortius.chunkbychunk.common.blocks.TriggeredSpawnRandomChunkBlock;
import xyz.immortius.chunkbychunk.common.world.SpawnChunkHelper;
import xyz.immortius.chunkbychunk.interop.ChunkByChunkConstants;

public class SpawnChunkCommand {
    private static final SimpleCommandExceptionType INVALID_POSITION = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.chunkbychunk.spawnchunk.invalidPosition"));
    private static final SimpleCommandExceptionType INVALID_LEVEL = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.chunkbychunk.spawnchunk.invalidlevel"));
    private static final SimpleCommandExceptionType NON_EMPTY_CHUNK = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.chunkbychunk.spawnchunk.nonemptychunk"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode spawnChunkCommand = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"chunkbychunk:spawnChunk").requires(x -> x.m_6761_(2))).then(Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).executes(cmd -> SpawnChunkCommand.spawnChunk((CommandSourceStack)cmd.getSource(), ((CommandSourceStack)cmd.getSource()).m_81372_(), Vec3Argument.m_120849_((CommandContext)cmd, (String)"location"), false))));
        LiteralCommandNode spawnRandomChunkCommand = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"chunkbychunk:spawnRandomChunk").requires(x -> x.m_6761_(2))).then(Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).executes(cmd -> SpawnChunkCommand.spawnChunk((CommandSourceStack)cmd.getSource(), ((CommandSourceStack)cmd.getSource()).m_81372_(), Vec3Argument.m_120849_((CommandContext)cmd, (String)"location"), true))));
    }

    private static int spawnChunk(CommandSourceStack stack, ServerLevel level, Coordinates specifiedCoords, boolean random) throws CommandSyntaxException {
        Vec3 vec3 = specifiedCoords.m_6955_(stack);
        BlockPos pos = new BlockPos(vec3.f_82479_, (double)(level.m_151558_() - 1), vec3.f_82481_);
        ChunkPos chunkPos = new ChunkPos(pos);
        if (!SpawnChunkHelper.isValidForChunkSpawn(level)) {
            throw INVALID_LEVEL.create();
        }
        if (!Level.m_46741_((BlockPos)pos)) {
            throw INVALID_POSITION.create();
        }
        if (!SpawnChunkHelper.isEmptyChunk((LevelAccessor)level, chunkPos)) {
            throw NON_EMPTY_CHUNK.create();
        }
        if (random) {
            ChunkPos sourceChunk = TriggeredSpawnRandomChunkBlock.getSourceChunk(pos);
            SpawnChunkHelper.spawnChunkBlocks(level, sourceChunk, chunkPos);
            level.m_7731_(pos, ChunkByChunkConstants.triggeredSpawnRandomChunkBlock().m_49966_(), 3);
        } else {
            SpawnChunkHelper.spawnChunkBlocks(level, chunkPos);
            level.m_7731_(pos, ChunkByChunkConstants.triggeredSpawnChunkBlock().m_49966_(), 3);
        }
        return 1;
    }
}

