/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.common.menus;

import com.google.common.base.Preconditions;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import xyz.immortius.chunkbychunk.common.blockEntities.WorldForgeBlockEntity;
import xyz.immortius.chunkbychunk.common.menus.BaseInventoryContainerMenu;
import xyz.immortius.chunkbychunk.common.menus.FilteredSlot;
import xyz.immortius.chunkbychunk.common.menus.TakeOnlySlot;
import xyz.immortius.chunkbychunk.interop.ChunkByChunkConstants;

public class WorldForgeMenu
extends BaseInventoryContainerMenu {
    private final ContainerData containerData;

    public WorldForgeMenu(int menuId, Inventory inventory) {
        this(menuId, inventory, (Container)new SimpleContainer(2), (ContainerData)new SimpleContainerData(2));
    }

    public WorldForgeMenu(int menuId, Inventory inventory, Container container, ContainerData containerData) {
        super(ChunkByChunkConstants.worldForgeMenu(), menuId, container, inventory, 8, 84);
        this.containerData = containerData;
        Preconditions.checkArgument((container.m_6643_() >= 2 ? 1 : 0) != 0, (Object)("Expected 2 item slots, but entity has " + container.m_6643_()));
        Preconditions.checkArgument((containerData.m_6499_() >= 2 ? 1 : 0) != 0, (Object)("Expected 2 data items, but entity has " + containerData.m_6499_()));
        this.m_38897_(new FilteredSlot(container, 0, 58, 35, WorldForgeBlockEntity::isWorldForgeFuel));
        this.m_38897_(new TakeOnlySlot(container, 1, 116, 35));
        this.m_38884_(containerData);
    }

    public int getProgress() {
        return this.containerData.m_6413_(0);
    }

    public int getGoal() {
        return this.containerData.m_6413_(1);
    }

    @Override
    protected boolean quickMoveToContainer(ItemStack stack) {
        if (WorldForgeBlockEntity.isWorldForgeFuel(stack)) {
            return this.moveItemStackToContainerSlot(stack, 0, 1, false);
        }
        return false;
    }
}

