/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.common.menus;

import com.google.common.base.Preconditions;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import xyz.immortius.chunkbychunk.common.blockEntities.WorldScannerBlockEntity;
import xyz.immortius.chunkbychunk.common.menus.BaseInventoryContainerMenu;
import xyz.immortius.chunkbychunk.common.menus.FilteredSlot;
import xyz.immortius.chunkbychunk.interop.ChunkByChunkConstants;

public class WorldScannerMenu
extends BaseInventoryContainerMenu {
    private final ContainerData containerData;

    public WorldScannerMenu(int menuId, Inventory inventory) {
        this(menuId, inventory, (Container)new SimpleContainer(2), (ContainerData)new SimpleContainerData(5));
    }

    public WorldScannerMenu(int menuId, Inventory inventory, Container container, ContainerData containerData) {
        super(ChunkByChunkConstants.worldScannerMenu(), menuId, container, inventory, 8, 84);
        this.containerData = containerData;
        Preconditions.checkArgument((container.m_6643_() >= 2 ? 1 : 0) != 0, (Object)("Expected 2 item slots, but entity has " + container.m_6643_()));
        Preconditions.checkArgument((containerData.m_6499_() >= 5 ? 1 : 0) != 0, (Object)("Expected 5 data items, but entity has " + containerData.m_6499_()));
        this.m_38897_(new Slot(container, 0, 27, 21));
        this.m_38897_(new FilteredSlot(container, 1, 27, 50, WorldScannerBlockEntity::isWorldScannerFuel));
        this.m_38884_(containerData);
    }

    public int getEnergy() {
        return this.containerData.m_6413_(1);
    }

    public int getMaxEnergy() {
        return this.containerData.m_6413_(2);
    }

    public int getCurrentChunkX() {
        return this.containerData.m_6413_(3);
    }

    public int getCurrentChunkZ() {
        return this.containerData.m_6413_(4);
    }

    public boolean isMapAvailable() {
        return this.containerData.m_6413_(0) != -1;
    }

    public String getMapKey() {
        return MapItem.m_42848_((int)this.containerData.m_6413_(0));
    }

    public int getMapId() {
        return this.containerData.m_6413_(0);
    }

    @Override
    protected boolean quickMoveToContainer(ItemStack stack) {
        if (WorldScannerBlockEntity.isWorldScannerFuel(stack)) {
            return this.moveItemStackToContainerSlot(stack, 1, 2, false);
        }
        return this.moveItemStackToContainerSlot(stack, 0, 1, false);
    }
}

