/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.common.world;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.immortius.chunkbychunk.common.world.SkyChunkGenerator;
import xyz.immortius.chunkbychunk.config.ChunkByChunkConfig;
import xyz.immortius.chunkbychunk.interop.CBCInteropMethods;
import xyz.immortius.chunkbychunk.interop.ChunkByChunkConstants;

public final class SpawnChunkHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Random random = new Random();

    private SpawnChunkHelper() {
    }

    public static boolean isEmptyChunk(LevelAccessor level, ChunkPos chunkPos) {
        BlockPos bedrockCheckBlock = chunkPos.m_151384_(8, level.m_141937_(), 8);
        return !Blocks.f_50752_.equals(level.m_8055_(bedrockCheckBlock).m_60734_());
    }

    public static boolean isValidForChunkSpawn(ServerLevel level) {
        return level != null && level.m_7726_().m_8481_() instanceof SkyChunkGenerator;
    }

    public static void spawnChunkBlocks(ServerLevel targetLevel, ChunkPos chunkPos) {
        SpawnChunkHelper.spawnChunkBlocks(targetLevel, chunkPos, chunkPos);
    }

    public static void spawnChunkBlocks(ServerLevel targetLevel, ChunkPos sourceChunkPos, ChunkPos targetChunkPos) {
        if (!SpawnChunkHelper.isValidForChunkSpawn(targetLevel)) {
            LOGGER.warn("Attempted to spawn a chunk in a non-SkyChunk world");
            return;
        }
        ServerLevel sourceLevel = Objects.requireNonNull(targetLevel.m_142572_()).m_129880_(ChunkByChunkConstants.SKY_CHUNK_GENERATION_LEVEL);
        if (sourceLevel != null) {
            SpawnChunkHelper.copyBlocks(sourceLevel, sourceChunkPos, targetLevel, targetChunkPos);
            if (ChunkByChunkConfig.get().getGeneration().spawnNewChunkChest()) {
                SpawnChunkHelper.createNextSpawner(targetLevel, targetChunkPos);
            }
        }
    }

    public static void spawnChunkEntities(ServerLevel targetLevel, ChunkPos sourceChunkPos, ChunkPos targetChunkPos) {
        if (!SpawnChunkHelper.isValidForChunkSpawn(targetLevel)) {
            LOGGER.warn("Attempted to spawn a chunk in a non-SkyChunk world");
            return;
        }
        ServerLevel sourceLevel = Objects.requireNonNull(targetLevel.m_142572_()).m_129880_(ChunkByChunkConstants.SKY_CHUNK_GENERATION_LEVEL);
        if (sourceLevel != null) {
            SpawnChunkHelper.copyEntities(sourceLevel, sourceChunkPos, targetLevel, targetChunkPos);
        }
    }

    private static void copyBlocks(ServerLevel from, ChunkPos sourceChunkPos, ServerLevel to, ChunkPos targetChunkPos) {
        BlockPos.MutableBlockPos sourceBlock = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos targetBlock = new BlockPos.MutableBlockPos();
        int xOffset = targetChunkPos.m_45604_() - sourceChunkPos.m_45604_();
        int zOffset = targetChunkPos.m_45605_() - sourceChunkPos.m_45605_();
        for (int z = targetChunkPos.m_45605_(); z <= targetChunkPos.m_45609_(); ++z) {
            for (int x = targetChunkPos.m_45604_(); x <= targetChunkPos.m_45608_(); ++x) {
                targetBlock.m_122178_(x, to.m_141937_(), z);
                to.m_7731_((BlockPos)targetBlock, Blocks.f_50752_.m_49966_(), 3);
            }
        }
        for (int y = to.m_141937_() + 1; y < to.m_151558_() - 1; ++y) {
            for (int z = sourceChunkPos.m_45605_(); z <= sourceChunkPos.m_45609_(); ++z) {
                for (int x = sourceChunkPos.m_45604_(); x <= sourceChunkPos.m_45608_(); ++x) {
                    sourceBlock.m_122178_(x, y, z);
                    targetBlock.m_122178_(x + xOffset, y, z + zOffset);
                    Block existingBlock = to.m_8055_((BlockPos)targetBlock).m_60734_();
                    if (!(existingBlock instanceof LeavesBlock) && !(existingBlock instanceof AirBlock) && !(existingBlock instanceof LiquidBlock) && existingBlock != Blocks.f_50752_ && existingBlock != Blocks.f_50652_) continue;
                    to.m_7731_((BlockPos)targetBlock, from.m_8055_((BlockPos)sourceBlock), 3);
                    BlockEntity fromBlockEntity = from.m_7702_((BlockPos)sourceBlock);
                    BlockEntity toBlockEntity = to.m_7702_((BlockPos)targetBlock);
                    if (fromBlockEntity == null || toBlockEntity == null) continue;
                    CompoundTag tag = new CompoundTag();
                    toBlockEntity.m_142466_(fromBlockEntity.m_6945_(tag));
                }
            }
        }
    }

    public static void copyEntities(ServerLevel from, ChunkPos sourceChunkPos, ServerLevel to, ChunkPos targetChunkPos) {
        List entities = from.m_6249_((Entity)null, new AABB((double)sourceChunkPos.m_45604_(), (double)from.m_141937_(), (double)sourceChunkPos.m_45605_(), (double)sourceChunkPos.m_45608_(), (double)from.m_151558_(), (double)sourceChunkPos.m_45609_()), x -> true);
        for (Entity e : entities) {
            Vec3 pos;
            Entity movedEntity = CBCInteropMethods.changeDimension(e, to, new PortalInfo(pos = new Vec3(e.m_20185_() + (double)((targetChunkPos.f_45578_ - sourceChunkPos.f_45578_) * 16), e.m_20186_(), e.m_20189_() + (double)((targetChunkPos.f_45579_ - sourceChunkPos.f_45579_) * 16)), Vec3.f_82478_, e.f_19860_, e.f_19859_));
            if (movedEntity == null) continue;
            movedEntity.m_146884_(pos);
        }
    }

    private static void createNextSpawner(ServerLevel targetLevel, ChunkPos chunkPos) {
        int maxPos;
        int minPos = ChunkByChunkConfig.get().getGeneration().getMinChestSpawnDepth();
        for (maxPos = ChunkByChunkConfig.get().getGeneration().getMaxChestSpawnDepth(); maxPos > minPos && targetLevel.m_8055_(new BlockPos(chunkPos.m_151390_(), maxPos, chunkPos.m_151393_())).m_60734_() instanceof AirBlock; --maxPos) {
        }
        int yPos = minPos == maxPos ? minPos : random.nextInt(maxPos - minPos + 1) + minPos;
        BlockPos blockPos = new BlockPos(chunkPos.m_151390_(), yPos, chunkPos.m_151393_());
        if (ChunkByChunkConfig.get().getGeneration().useBedrockChest()) {
            targetLevel.m_7731_(blockPos, ChunkByChunkConstants.bedrockChestBlock().m_49966_(), 3);
        } else {
            targetLevel.m_7731_(blockPos, Blocks.f_50087_.m_49966_(), 3);
        }
        BlockEntity blockEntity = targetLevel.m_7702_(blockPos);
        if (blockEntity instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity chestEntity = (RandomizableContainerBlockEntity)blockEntity;
            chestEntity.m_6836_(0, ChunkByChunkConfig.get().getGeneration().getChestContents().getItem(ChunkByChunkConfig.get().getGeneration().getChestQuantity()));
        }
    }
}

