/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.config.system;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.immortius.chunkbychunk.config.system.ConfigException;
import xyz.immortius.chunkbychunk.config.system.FieldMetadata;

public class BooleanFieldMetadata
extends FieldMetadata<Boolean> {
    public static final Logger LOGGER = LogManager.getLogger((String)"chunkbychunk");
    private final Field field;

    public BooleanFieldMetadata(Field field, String name, String comment) {
        super(field, name, comment);
        Preconditions.checkArgument((boolean)Boolean.TYPE.equals(field.getType()));
        this.field = field;
        this.field.setAccessible(true);
    }

    @Override
    public String serializeValue(Object object) {
        try {
            return this.field.get(object).toString();
        }
        catch (IllegalAccessException e) {
            throw new ConfigException("Failed to retrieve " + this.getName() + " from object " + object, e);
        }
    }

    @Override
    public void deserializeValue(Object object, String value) {
        try {
            if ("true".equalsIgnoreCase(value)) {
                this.field.set(object, true);
            } else if ("false".equalsIgnoreCase(value)) {
                this.field.set(object, false);
            } else {
                LOGGER.warn("Invalid boolean value {} for configuration item {}", (Object)value, (Object)this.getName());
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to set " + this.getName() + " to value " + value, e);
        }
    }
}

