/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.config.system;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.immortius.chunkbychunk.config.system.ConfigMetadata;
import xyz.immortius.chunkbychunk.config.system.FieldMetadata;
import xyz.immortius.chunkbychunk.config.system.MetadataBuilder;
import xyz.immortius.chunkbychunk.config.system.ObjectMetadata;
import xyz.immortius.chunkbychunk.config.system.SectionMetadata;

public class ConfigSystem {
    private static final Logger LOGGER = LogManager.getLogger((String)"chunkbychunk");
    private static final String NEWLINE = "\n";
    private static final String START_COMMENT = "#";
    private static final String EQUALS = " = ";
    private static final String START_SECTION = "[";
    private static final String END_SECTION = "]";
    private static final String INDENT = "\t";
    private final Map<Class<?>, ConfigMetadata> metadataMap = new HashMap();

    public void synchConfig(Path configFile, Object object) {
        if (!this.createPathTo(configFile)) {
            return;
        }
        if (Files.exists(configFile, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(configFile);){
                this.readInto(reader, object);
            }
            catch (IOException e) {
                LOGGER.error("Failed to read server config at '{}'", (Object)configFile, (Object)e);
            }
        } else {
            try (BufferedWriter writer = Files.newBufferedWriter(configFile, new OpenOption[0]);){
                this.write(writer, object);
            }
            catch (IOException e) {
                LOGGER.error("Failed to write server config at {}", (Object)configFile, (Object)e);
            }
        }
    }

    public void write(Path configFile, Object object) {
        if (!this.createPathTo(configFile)) {
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(configFile, new OpenOption[0]);){
            this.write(writer, object);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write server config at {}", (Object)configFile, (Object)e);
        }
    }

    private boolean createPathTo(Path configFile) {
        if (configFile.getParent() != null && !Files.exists(configFile.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
                return true;
            }
            catch (IOException e) {
                LOGGER.error("Failed to create server config path '{}'", (Object)configFile.getParent(), (Object)e);
                return false;
            }
        }
        return true;
    }

    public void readInto(BufferedReader reader, Object into) {
        ConfigMetadata metadata = this.getMetadata(into);
        try {
            Object currentObject = into;
            ObjectMetadata currentMetadata = metadata;
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).startsWith(START_SECTION)) {
                    int endIndex = line.indexOf(END_SECTION);
                    if (endIndex != -1) {
                        String sectionName = line.substring(START_SECTION.length(), endIndex);
                        SectionMetadata sectionMetadata = metadata.getSections().get(sectionName.toLowerCase(Locale.ROOT));
                        if (sectionMetadata != null) {
                            currentMetadata = sectionMetadata;
                            currentObject = sectionMetadata.getSectionObject(into);
                        } else {
                            LOGGER.warn("Encountered unexpected section {}", (Object)sectionName);
                        }
                    } else {
                        LOGGER.warn("Invalid section statement {}", (Object)line);
                    }
                } else if (!line.startsWith(START_COMMENT) && !line.isEmpty()) {
                    String[] parts = line.split(EQUALS);
                    if (parts.length == 2) {
                        String fieldName = parts[0].trim();
                        String value = parts[1].trim();
                        FieldMetadata<?> fieldMetadata = currentMetadata.getFields().get(fieldName.toLowerCase(Locale.ROOT));
                        if (fieldMetadata != null) {
                            fieldMetadata.deserializeValue(currentObject, value);
                        } else {
                            LOGGER.warn("Unexpected field {}", (Object)fieldName);
                        }
                    } else {
                        LOGGER.warn("Bad config line {}", (Object)line);
                    }
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to read config", (Throwable)e);
        }
    }

    public void write(Writer writer, Object object) {
        ConfigMetadata metadata = this.getMetadata(object);
        try {
            for (FieldMetadata field : metadata.getFields().values()) {
                this.writeField(writer, object, field, "");
            }
            for (SectionMetadata section : metadata.getSections().values()) {
                writer.write(NEWLINE);
                writer.write(START_SECTION);
                writer.write(section.getName());
                writer.write(END_SECTION);
                writer.write(NEWLINE);
                Object sectionObject = section.getSectionObject(object);
                for (FieldMetadata field : section.getFields().values()) {
                    this.writeField(writer, sectionObject, field, INDENT);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to write config", (Throwable)e);
        }
    }

    private void writeField(Writer writer, Object object, FieldMetadata<?> field, String indentation) throws IOException {
        for (String commentLine : field.getComments()) {
            for (String line : commentLine.split("[\n\r]+")) {
                writer.write(indentation);
                writer.write(START_COMMENT);
                writer.write(line);
                writer.write(NEWLINE);
            }
        }
        writer.write(indentation);
        writer.write(field.getName());
        writer.write(EQUALS);
        writer.write(field.serializeValue(object));
        writer.write(NEWLINE);
    }

    private ConfigMetadata getMetadata(Object o) {
        ConfigMetadata metadata = this.metadataMap.get(o.getClass());
        if (metadata == null) {
            metadata = MetadataBuilder.build(o.getClass());
            this.metadataMap.put(o.getClass(), metadata);
        }
        return metadata;
    }
}

