/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.config.system;

import com.google.common.base.Strings;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import xyz.immortius.chunkbychunk.config.system.ConfigException;

public abstract class FieldMetadata<T> {
    private final String name;
    private final String comment;
    private final Component displayName;
    private final Field field;

    public FieldMetadata(Field field, String name, String comment) {
        this.field = field;
        this.field.setAccessible(true);
        this.name = name;
        this.comment = comment;
        this.displayName = new TranslatableComponent("config.chunkbychunk.option." + field.getName());
    }

    public String getName() {
        return this.name;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public List<String> getComments() {
        if (Strings.isNullOrEmpty((String)this.comment)) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.comment);
    }

    public T getValue(Object object) {
        try {
            return (T)this.field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new ConfigException("Failed to retrieve " + this.getName() + " from object " + object, e);
        }
    }

    public void setValue(Object object, T value) {
        try {
            this.field.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new ConfigException("Failed to set " + this.getName() + " to value " + value, e);
        }
    }

    public abstract String serializeValue(Object var1);

    public abstract void deserializeValue(Object var1, String var2);
}

