/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.config.system;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import xyz.immortius.chunkbychunk.config.system.BooleanFieldMetadata;
import xyz.immortius.chunkbychunk.config.system.Comment;
import xyz.immortius.chunkbychunk.config.system.ConfigMetadata;
import xyz.immortius.chunkbychunk.config.system.EnumFieldMetadata;
import xyz.immortius.chunkbychunk.config.system.FieldMetadata;
import xyz.immortius.chunkbychunk.config.system.IntFieldMetadata;
import xyz.immortius.chunkbychunk.config.system.IntRange;
import xyz.immortius.chunkbychunk.config.system.Name;
import xyz.immortius.chunkbychunk.config.system.SectionMetadata;

public final class MetadataBuilder {
    private MetadataBuilder() {
    }

    public static ConfigMetadata build(Class<?> type) {
        List<FieldMetadata<?>> fields = MetadataBuilder.processFields(type);
        ArrayList<SectionMetadata> sections = new ArrayList<SectionMetadata>();
        for (Field declaredField : type.getDeclaredFields()) {
            Class<?> fieldType;
            if (Modifier.isStatic(declaredField.getModifiers()) || !Object.class.isAssignableFrom(fieldType = declaredField.getType()) || Enum.class.isAssignableFrom(fieldType)) continue;
            sections.add(MetadataBuilder.processSection(fieldType, declaredField));
        }
        return new ConfigMetadata(sections, fields);
    }

    private static SectionMetadata processSection(Class<?> type, Field field) {
        String name = MetadataBuilder.getName(field);
        List<FieldMetadata<?>> fields = MetadataBuilder.processFields(type);
        return new SectionMetadata(name, fields, field);
    }

    private static List<FieldMetadata<?>> processFields(Class<?> type) {
        ArrayList fields = new ArrayList();
        for (Field declaredField : type.getDeclaredFields()) {
            Class<?> fieldType = declaredField.getType();
            if (Integer.TYPE.equals(fieldType)) {
                fields.add(MetadataBuilder.processIntField(declaredField));
                continue;
            }
            if (Boolean.TYPE.equals(fieldType)) {
                fields.add(MetadataBuilder.processBooleanField(declaredField));
                continue;
            }
            if (!Enum.class.isAssignableFrom(fieldType)) continue;
            fields.add(MetadataBuilder.processEnumField(declaredField));
        }
        return fields;
    }

    private static FieldMetadata processEnumField(Field field) {
        String name = MetadataBuilder.getName(field);
        String comment = MetadataBuilder.getComment(field);
        return new EnumFieldMetadata(field, name, comment);
    }

    private static FieldMetadata processBooleanField(Field field) {
        String name = MetadataBuilder.getName(field);
        String comment = MetadataBuilder.getComment(field);
        return new BooleanFieldMetadata(field, name, comment);
    }

    private static FieldMetadata processIntField(Field field) {
        String name = MetadataBuilder.getName(field);
        String comment = MetadataBuilder.getComment(field);
        int min = Integer.MIN_VALUE;
        int max = Integer.MAX_VALUE;
        IntRange intRange = field.getAnnotation(IntRange.class);
        if (intRange != null) {
            min = intRange.min();
            max = intRange.max();
        }
        return new IntFieldMetadata(field, name, comment, min, max);
    }

    private static String getName(Field field) {
        Name annotation = field.getAnnotation(Name.class);
        if (annotation != null) {
            return annotation.value();
        }
        return field.getName();
    }

    private static String getComment(Field field) {
        Comment annotation = field.getAnnotation(Comment.class);
        if (annotation != null) {
            return annotation.value();
        }
        return "";
    }
}

