/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.config.system;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import xyz.immortius.chunkbychunk.config.system.ConfigException;
import xyz.immortius.chunkbychunk.config.system.FieldMetadata;
import xyz.immortius.chunkbychunk.config.system.ObjectMetadata;

public class SectionMetadata
extends ObjectMetadata {
    private final Field sectionField;
    private final String name;
    private final Component displayName;

    public SectionMetadata(String name, Collection<FieldMetadata<?>> fields, Field sectionField) {
        super(fields);
        this.name = name;
        this.sectionField = sectionField;
        this.sectionField.setAccessible(true);
        this.displayName = new TranslatableComponent("config.chunkbychunk.section." + name.toLowerCase(Locale.ROOT));
    }

    public String getName() {
        return this.name;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public Object getSectionObject(Object source) {
        try {
            return this.sectionField.get(source);
        }
        catch (IllegalAccessException e) {
            throw new ConfigException("Failed to access section object " + this.name, e);
        }
    }
}

