/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.forge;

import com.mojang.brigadier.CommandDispatcher;
import java.nio.file.Paths;
import java.util.Optional;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.fmllegacy.network.NetworkDirection;
import net.minecraftforge.fmllegacy.network.NetworkRegistry;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import net.minecraftforge.fmllegacy.network.simple.SimpleChannel;
import net.minecraftforge.fmlserverevents.FMLServerAboutToStartEvent;
import net.minecraftforge.fmlserverevents.FMLServerStartedEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import xyz.immortius.chunkbychunk.client.screens.BedrockChestScreen;
import xyz.immortius.chunkbychunk.client.screens.WorldForgeScreen;
import xyz.immortius.chunkbychunk.client.screens.WorldScannerScreen;
import xyz.immortius.chunkbychunk.common.CommonEventHandler;
import xyz.immortius.chunkbychunk.common.blockEntities.BedrockChestBlockEntity;
import xyz.immortius.chunkbychunk.common.blockEntities.TriggeredSpawnChunkBlockEntity;
import xyz.immortius.chunkbychunk.common.blockEntities.TriggeredSpawnRandomChunkBlockEntity;
import xyz.immortius.chunkbychunk.common.blockEntities.WorldForgeBlockEntity;
import xyz.immortius.chunkbychunk.common.blockEntities.WorldScannerBlockEntity;
import xyz.immortius.chunkbychunk.common.blocks.BedrockChestBlock;
import xyz.immortius.chunkbychunk.common.blocks.SpawnChunkBlock;
import xyz.immortius.chunkbychunk.common.blocks.TriggeredSpawnChunkBlock;
import xyz.immortius.chunkbychunk.common.blocks.TriggeredSpawnRandomChunkBlock;
import xyz.immortius.chunkbychunk.common.blocks.UnstableSpawnChunkBlock;
import xyz.immortius.chunkbychunk.common.blocks.WorldForgeBlock;
import xyz.immortius.chunkbychunk.common.blocks.WorldScannerBlock;
import xyz.immortius.chunkbychunk.common.commands.SpawnChunkCommand;
import xyz.immortius.chunkbychunk.common.menus.BedrockChestMenu;
import xyz.immortius.chunkbychunk.common.menus.WorldForgeMenu;
import xyz.immortius.chunkbychunk.common.menus.WorldScannerMenu;
import xyz.immortius.chunkbychunk.common.world.SkyChunkGenerator;
import xyz.immortius.chunkbychunk.config.ChunkByChunkConfig;
import xyz.immortius.chunkbychunk.config.system.ConfigSystem;
import xyz.immortius.chunkbychunk.forge.ChunkByChunkClientMod;
import xyz.immortius.chunkbychunk.server.ServerEventHandler;

@Mod(value="chunkbychunk")
public class ChunkByChunkMod {
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"chunkbychunk");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"chunkbychunk");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"chunkbychunk");
    private static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"chunkbychunk");
    private static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"chunkbychunk");
    public static final RegistryObject<Block> SPAWN_CHUNK_BLOCK = BLOCKS.register("chunkspawner", () -> new SpawnChunkBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_)));
    public static final RegistryObject<Block> UNSTABLE_SPAWN_CHUNK_BLOCK = BLOCKS.register("unstablechunkspawner", () -> new UnstableSpawnChunkBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_)));
    public static final RegistryObject<Block> BEDROCK_CHEST_BLOCK = BLOCKS.register("bedrockchest", () -> new BedrockChestBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(-1.0f, 3600000.0f).m_60993_().m_60922_((p_61031_, p_61032_, p_61033_, p_61034_) -> false)));
    public static final RegistryObject<Block> WORLD_CORE_BLOCK = BLOCKS.register("worldcore", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(3.0f).m_60953_(state -> 7)));
    public static final RegistryObject<Block> WORLD_FORGE_BLOCK = BLOCKS.register("worldforge", () -> new WorldForgeBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(3.5f).m_60953_(state -> 7)));
    public static final RegistryObject<Block> WORLD_SCANNER_BLOCK = BLOCKS.register("worldscanner", () -> new WorldScannerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(3.5f).m_60953_(state -> 4)));
    public static final RegistryObject<Block> TRIGGERED_SPAWN_CHUNK_BLOCK = BLOCKS.register("triggeredchunkspawner", () -> new TriggeredSpawnChunkBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76296_)));
    public static final RegistryObject<Block> TRIGGERED_SPAWN_RANDOM_CHUNK_BLOCK = BLOCKS.register("triggeredrandomchunkspawner", () -> new TriggeredSpawnRandomChunkBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76296_)));
    public static final RegistryObject<Item> SPAWN_CHUNK_BLOCK_ITEM = ITEMS.register("chunkspawner", () -> new BlockItem((Block)SPAWN_CHUNK_BLOCK.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    public static final RegistryObject<Item> UNSTABLE_SPAWN_CHUNK_BLOCK_ITEM = ITEMS.register("unstablechunkspawner", () -> new BlockItem((Block)UNSTABLE_SPAWN_CHUNK_BLOCK.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    public static final RegistryObject<Item> BEDROCK_CHEST_ITEM = ITEMS.register("bedrockchest", () -> new BlockItem((Block)BEDROCK_CHEST_BLOCK.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    public static final RegistryObject<Item> WORLD_CORE_BLOCK_ITEM = ITEMS.register("worldcore", () -> new BlockItem((Block)WORLD_CORE_BLOCK.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    public static final RegistryObject<Item> WORLD_FORGE_BLOCK_ITEM = ITEMS.register("worldforge", () -> new BlockItem((Block)WORLD_FORGE_BLOCK.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    public static final RegistryObject<Item> WORLD_SCANNER_BLOCK_ITEM = ITEMS.register("worldscanner", () -> new BlockItem((Block)WORLD_SCANNER_BLOCK.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    public static final RegistryObject<Item> WORLD_FRAGMENT_ITEM = ITEMS.register("worldfragment", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    public static final RegistryObject<Item> WORLD_SHARD_ITEM = ITEMS.register("worldshard", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    public static final RegistryObject<Item> WORLD_CRYSTAL_ITEM = ITEMS.register("worldcrystal", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    public static final RegistryObject<BlockEntityType<?>> BEDROCK_CHEST_BLOCK_ENTITY = BLOCK_ENTITIES.register("bedrockchestentity", () -> BlockEntityType.Builder.m_155273_(BedrockChestBlockEntity::new, (Block[])new Block[]{(Block)BEDROCK_CHEST_BLOCK.get()}).m_58966_(null));
    public static final RegistryObject<BlockEntityType<?>> WORLD_FORGE_BLOCK_ENTITY = BLOCK_ENTITIES.register("worldforgeentity", () -> BlockEntityType.Builder.m_155273_(WorldForgeBlockEntity::new, (Block[])new Block[]{(Block)WORLD_FORGE_BLOCK.get()}).m_58966_(null));
    public static final RegistryObject<BlockEntityType<?>> WORLD_SCANNER_BLOCK_ENTITY = BLOCK_ENTITIES.register("worldscannerentity", () -> BlockEntityType.Builder.m_155273_(WorldScannerBlockEntity::new, (Block[])new Block[]{(Block)WORLD_SCANNER_BLOCK.get()}).m_58966_(null));
    public static final RegistryObject<BlockEntityType<?>> TRIGGERED_SPAWN_CHUNK_BLOCK_ENTITY = BLOCK_ENTITIES.register("triggeredspawnchunkentity", () -> BlockEntityType.Builder.m_155273_(TriggeredSpawnChunkBlockEntity::new, (Block[])new Block[]{(Block)TRIGGERED_SPAWN_CHUNK_BLOCK.get()}).m_58966_(null));
    public static final RegistryObject<BlockEntityType<?>> TRIGGERED_SPAWN_RANDOM_CHUNK_BLOCK_ENTITY = BLOCK_ENTITIES.register("triggeredspawnrandomchunkentity", () -> BlockEntityType.Builder.m_155273_(TriggeredSpawnRandomChunkBlockEntity::new, (Block[])new Block[]{(Block)TRIGGERED_SPAWN_RANDOM_CHUNK_BLOCK.get()}).m_58966_(null));
    public static final RegistryObject<MenuType<BedrockChestMenu>> BEDROCK_CHEST_MENU = CONTAINERS.register("bedrockchestmenu", () -> new MenuType(BedrockChestMenu::new));
    public static final RegistryObject<MenuType<WorldForgeMenu>> WORLD_FORGE_MENU = CONTAINERS.register("worldforgemenu", () -> new MenuType(WorldForgeMenu::new));
    public static final RegistryObject<MenuType<WorldScannerMenu>> WORLD_SCANNER_MENU = CONTAINERS.register("worldscannermenu", () -> new MenuType(WorldScannerMenu::new));
    public static final RegistryObject<SoundEvent> SPAWN_CHUNK_SOUND_EVENT = SOUNDS.register("spawnchunkevent", () -> new SoundEvent(new ResourceLocation("chunkbychunk", "chunk_spawn_sound")));
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel CONFIG_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("chunkbychunk", "configchannel"), () -> "1", "1"::equals, "1"::equals);

    public ChunkByChunkMod() {
        new ConfigSystem().synchConfig(Paths.get("defaultconfigs", "chunkbychunk.toml"), ChunkByChunkConfig.get());
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        BLOCK_ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        CONTAINERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        SOUNDS.register(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        int packetId = 1;
        CONFIG_CHANNEL.registerMessage(packetId++, ConfigMessage.class, (configMessage, friendlyByteBuf) -> friendlyByteBuf.writeBoolean(configMessage.blockPlacementAllowed), friendlyByteBuf -> new ConfigMessage(friendlyByteBuf.readBoolean()), (configMessage, contextSupplier) -> ChunkByChunkConfig.get().getGameplayConfig().setBlockPlacementAllowedOutsideSpawnedChunks(configMessage.blockPlacementAllowed), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ChunkByChunkClientMod.registerConfigScreen();
            MenuScreens.m_96206_((MenuType)((MenuType)BEDROCK_CHEST_MENU.get()), BedrockChestScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)WORLD_FORGE_MENU.get()), WorldForgeScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)WORLD_SCANNER_MENU.get()), WorldScannerScreen::new);
        });
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        SpawnChunkCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onPlaceItem(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos = event.getPos();
        BlockPos placePos = pos.m_142300_(event.getFace());
        if (!CommonEventHandler.isBlockPlacementAllowed(placePos, event.getEntity(), (LevelAccessor)event.getWorld())) {
            event.setUseItem(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onServerStarted(FMLServerStartedEvent event) {
        ServerEventHandler.onServerStarted(event.getServer());
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerAboutToStartEvent event) {
        ServerEventHandler.onServerStarting(event.getServer());
    }

    @SubscribeEvent
    public void onServerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        CONFIG_CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer()), (Object)new ConfigMessage(ChunkByChunkConfig.get().getGameplayConfig().isBlockPlacementAllowedOutsideSpawnedChunks()));
    }

    static {
        Registry.m_122965_((Registry)Registry.f_122890_, (ResourceLocation)new ResourceLocation("chunkbychunk", "skychunkgenerator"), SkyChunkGenerator.CODEC);
    }

    private static class ConfigMessage {
        boolean blockPlacementAllowed;

        public ConfigMessage(boolean blockPlacementAllowed) {
            this.blockPlacementAllowed = blockPlacementAllowed;
        }
    }
}

