/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.ServerLevelData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.immortius.chunkbychunk.common.util.ChunkUtil;
import xyz.immortius.chunkbychunk.common.util.SpiralIterator;
import xyz.immortius.chunkbychunk.common.world.SkyChunkGenerator;
import xyz.immortius.chunkbychunk.common.world.SpawnChunkHelper;
import xyz.immortius.chunkbychunk.config.ChunkByChunkConfig;
import xyz.immortius.chunkbychunk.config.system.ConfigSystem;
import xyz.immortius.chunkbychunk.interop.ChunkByChunkConstants;

public final class ServerEventHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"chunkbychunk");
    private static final int MAX_FIND_CHUNK_ATTEMPTS = 512;
    private static final String SERVERCONFIG = "serverconfig";
    private static final ConfigSystem configSystem = new ConfigSystem();
    private static final List<List<int[]>> CHUNK_SPAWN_OFFSETS = ImmutableList.builder().add((Object)ImmutableList.of((Object)new int[]{0, 0})).add((Object)ImmutableList.of((Object)new int[]{0, 0}, (Object)new int[]{1, 0})).add((Object)ImmutableList.of((Object)new int[]{0, 0}, (Object)new int[]{1, 0}, (Object)new int[]{0, 1})).add((Object)ImmutableList.of((Object)new int[]{0, 0}, (Object)new int[]{1, 0}, (Object)new int[]{0, 1}, (Object)new int[]{1, 1})).add((Object)ImmutableList.of((Object)new int[]{0, 0}, (Object)new int[]{1, 0}, (Object)new int[]{0, 1}, (Object)new int[]{-1, 0}, (Object)new int[]{0, -1})).add((Object)ImmutableList.of((Object)new int[]{0, 0}, (Object)new int[]{1, 0}, (Object)new int[]{0, 1}, (Object)new int[]{-1, 0}, (Object)new int[]{0, -1}, (Object)new int[]{1, 1})).add((Object)ImmutableList.of((Object)new int[]{0, 0}, (Object)new int[]{1, 0}, (Object)new int[]{0, 1}, (Object)new int[]{-1, 0}, (Object)new int[]{0, -1}, (Object)new int[]{1, 1}, (Object)new int[]{-1, -1})).add((Object)ImmutableList.of((Object)new int[]{0, 0}, (Object)new int[]{1, 0}, (Object)new int[]{0, 1}, (Object)new int[]{-1, 0}, (Object)new int[]{0, -1}, (Object)new int[]{1, 1}, (Object)new int[]{-1, -1}, (Object)new int[]{1, -1})).add((Object)ImmutableList.of((Object)new int[]{0, 0}, (Object)new int[]{1, 0}, (Object)new int[]{0, 1}, (Object)new int[]{-1, 0}, (Object)new int[]{0, -1}, (Object)new int[]{1, 1}, (Object)new int[]{-1, -1}, (Object)new int[]{1, -1}, (Object)new int[]{-1, 1})).build();

    private ServerEventHandler() {
    }

    public static void onServerStarting(MinecraftServer server) {
        configSystem.synchConfig(server.m_129843_(LevelResource.f_78182_).resolve(SERVERCONFIG).resolve("chunkbychunk.toml"), ChunkByChunkConfig.get());
        if (ChunkByChunkConfig.get().getGeneration().isEnabled()) {
            ServerEventHandler.applyChunkByChunkWorldGeneration(server);
        }
    }

    private static void applyChunkByChunkWorldGeneration(MinecraftServer server) {
        WorldGenSettings worldGenSettings = server.m_129910_().m_5961_();
        LevelStem overworldStem = (LevelStem)worldGenSettings.m_64663_().m_7745_(Level.f_46428_.m_135782_());
        LevelStem generationStem = (LevelStem)worldGenSettings.m_64663_().m_7745_(ChunkByChunkConstants.SKY_CHUNK_GENERATION_LEVEL.m_135782_());
        if (!(overworldStem.m_63990_() instanceof SkyChunkGenerator)) {
            Registry dimensionTypeRegistry = server.m_129911_().m_175515_(Registry.f_122818_);
            if (generationStem == null) {
                ResourceKey skychunkgeneration = ResourceKey.m_135785_((ResourceKey)Registry.f_122820_, (ResourceLocation)new ResourceLocation("chunkbychunk", "skychunkgeneration"));
                generationStem = new LevelStem(() -> (DimensionType)dimensionTypeRegistry.m_6246_(DimensionType.f_63845_), overworldStem.m_63990_());
                worldGenSettings.m_64663_().m_7135_(skychunkgeneration, (Object)generationStem, Lifecycle.stable());
            }
            StructureSettings structureSettingsCopy = (StructureSettings)StructureSettings.f_64579_.parse((DynamicOps)NbtOps.f_128958_, (Object)((Tag)StructureSettings.f_64579_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)overworldStem.m_63990_().m_62205_()).result().get())).result().get();
            LevelStem newOverworldStem = new LevelStem(() -> (DimensionType)dimensionTypeRegistry.m_6246_(DimensionType.f_63845_), (ChunkGenerator)new SkyChunkGenerator(overworldStem.m_63990_(), ChunkByChunkConfig.get().getGeneration().sealWorld(), structureSettingsCopy));
            worldGenSettings.m_64663_().m_7794_(OptionalInt.empty(), ResourceKey.m_135785_((ResourceKey)Registry.f_122820_, (ResourceLocation)Level.f_46428_.m_135782_()), (Object)newOverworldStem, Lifecycle.stable());
        }
    }

    public static void onServerStarted(MinecraftServer server) {
        if (ChunkByChunkConfig.get().getGeneration().isEnabled()) {
            ServerEventHandler.checkSpawnInitialChunks(server);
        }
    }

    private static void checkSpawnInitialChunks(MinecraftServer server) {
        BlockPos spawnPos;
        ChunkPos chunkSpawnPos;
        ServerLevel overworldLevel = server.m_129880_(Level.f_46428_);
        ServerLevel generationLevel = server.m_129880_(ChunkByChunkConstants.SKY_CHUNK_GENERATION_LEVEL);
        if (overworldLevel != null && generationLevel != null && SpawnChunkHelper.isEmptyChunk((LevelAccessor)overworldLevel, chunkSpawnPos = new ChunkPos(spawnPos = generationLevel.m_8900_()))) {
            ServerEventHandler.findAppropriateSpawnChunk(overworldLevel, generationLevel);
            ServerEventHandler.spawnInitialChunks(overworldLevel);
        }
    }

    private static void findAppropriateSpawnChunk(ServerLevel overworldLevel, ServerLevel generationLevel) {
        int attempts;
        ImmutableSet logs = ImmutableSet.copyOf((Collection)BlockTags.f_13106_.m_6497_());
        ImmutableSet leaves = ImmutableSet.copyOf((Collection)BlockTags.f_13035_.m_6497_());
        ImmutableSet redstone = ImmutableSet.of((Object)Blocks.f_50173_, (Object)Blocks.f_152473_);
        ImmutableSet copper = ImmutableSet.of((Object)Blocks.f_152505_, (Object)Blocks.f_152506_, (Object)Blocks.f_152599_);
        ChunkPos initialChunkPos = new ChunkPos(overworldLevel.m_8900_());
        SpiralIterator iterator = new SpiralIterator(initialChunkPos.f_45578_, initialChunkPos.f_45579_);
        for (attempts = 0; attempts < 512; ++attempts) {
            LevelChunk chunk = generationLevel.m_6325_(iterator.getX(), iterator.getY());
            if (ChunkUtil.countBlocks((ChunkAccess)chunk, (Set<Block>)logs) > 1 && ChunkUtil.countBlocks((ChunkAccess)chunk, (Set<Block>)leaves) > 1 && ChunkUtil.countBlocks((ChunkAccess)chunk, (Set<Block>)redstone) >= 36 && ChunkUtil.countBlocks((ChunkAccess)chunk, (Set<Block>)copper) >= 36) {
                ServerLevelData levelData = (ServerLevelData)overworldLevel.m_6106_();
                levelData.m_7250_(new BlockPos(chunk.m_7697_().m_151390_(), ChunkUtil.getSafeSpawnHeight((ChunkAccess)chunk, chunk.m_7697_().m_151390_(), chunk.m_7697_().m_151393_()), chunk.m_7697_().m_151393_()), levelData.m_6790_());
                break;
            }
            iterator.next();
        }
        if (attempts < 512) {
            LOGGER.info("Found appropriate spawn chunk in {} attempts", (Object)attempts);
        } else {
            LOGGER.info("No appropriate spawn chunk found :(");
        }
    }

    private static void spawnInitialChunks(ServerLevel overworldLevel) {
        ChunkPos centerChunkPos = new ChunkPos(overworldLevel.m_8900_());
        List<int[]> chunkOffsets = CHUNK_SPAWN_OFFSETS.get(ChunkByChunkConfig.get().getGeneration().getInitialChunks() - 1);
        for (int[] offset : chunkOffsets) {
            ChunkPos targetPos = new ChunkPos(centerChunkPos.f_45578_ + offset[0], centerChunkPos.f_45579_ + offset[1]);
            ChunkPos sourcePos = new ChunkPos(targetPos.f_45578_, targetPos.f_45579_);
            SpawnChunkHelper.spawnChunkBlocks(overworldLevel, sourcePos, targetPos);
            overworldLevel.m_7731_(new BlockPos(targetPos.m_151390_(), overworldLevel.m_151558_() - 1, targetPos.m_151393_()), ChunkByChunkConstants.triggeredSpawnChunkBlock().m_49966_(), 3);
        }
    }
}

