/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.common.blockEntities;

import java.util.Map;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1662;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_6862;
import xyz.immortius.chunkbychunk.interop.SidedBlockEntityInteropBase;

public abstract class BaseFueledBlockEntity
extends SidedBlockEntityInteropBase {
    private final int fuelSlot;
    private final Map<class_1792, FuelValueSupplier> itemFuel;
    private final Map<class_6862<class_1792>, FuelValueSupplier> tagFuel;
    private int remainingFuel;
    private int chargedFuel;
    private class_2371<class_1799> items;

    protected BaseFueledBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 state, int numItemSlots, int fuelSlot, Map<class_1792, FuelValueSupplier> itemFuel, Map<class_6862<class_1792>, FuelValueSupplier> tagFuel) {
        super(blockEntityType, pos, state);
        this.items = class_2371.method_10213((int)numItemSlots, (Object)class_1799.field_8037);
        this.fuelSlot = fuelSlot;
        this.itemFuel = itemFuel;
        this.tagFuel = tagFuel;
    }

    public int getChargedFuel() {
        return this.chargedFuel;
    }

    public int getRemainingFuel() {
        return this.remainingFuel;
    }

    public void setRemainingFuel(int value) {
        this.remainingFuel = value;
    }

    protected int consumeFuel(int amount) {
        int consumed = Math.min(amount, this.remainingFuel);
        this.remainingFuel -= consumed;
        return consumed;
    }

    protected boolean checkConsumeFuelItem() {
        class_1799 fuelItem = (class_1799)this.items.get(this.fuelSlot);
        if (this.remainingFuel == 0 && this.isFuel(fuelItem)) {
            this.chargedFuel = this.remainingFuel = this.getFuelValue(fuelItem);
            fuelItem.method_7934(1);
            return true;
        }
        return false;
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)tag, this.items);
        this.chargedFuel = tag.method_10550("ChargedFuel");
        this.remainingFuel = tag.method_10550("RemainingFuel");
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("ChargedFuel", this.chargedFuel);
        tag.method_10569("RemainingFuel", this.remainingFuel);
        class_1262.method_5426((class_2487)tag, this.items);
    }

    public boolean isFuel(class_1799 itemStack) {
        if (this.itemFuel.getOrDefault(itemStack.method_7909(), () -> 0).get() > 0) {
            return true;
        }
        for (Map.Entry<class_6862<class_1792>, FuelValueSupplier> entry : this.tagFuel.entrySet()) {
            if (!itemStack.method_31573(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    public int getFuelValue(class_1799 itemStack) {
        FuelValueSupplier fuelValueSupplier = this.itemFuel.get(itemStack.method_7909());
        if (fuelValueSupplier == null) {
            for (Map.Entry<class_6862<class_1792>, FuelValueSupplier> entry : this.tagFuel.entrySet()) {
                if (!itemStack.method_31573(entry.getKey())) continue;
                fuelValueSupplier = entry.getValue();
            }
        }
        if (fuelValueSupplier != null) {
            return fuelValueSupplier.get();
        }
        return 0;
    }

    public int method_5439() {
        return this.items.size();
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.items.get(slot);
    }

    public class_1799 method_5434(int slot, int split) {
        return class_1262.method_5430(this.items, (int)slot, (int)split);
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.items, (int)slot);
    }

    public void method_5447(int slot, class_1799 newItem) {
        this.items.set(slot, (Object)newItem);
        if (newItem.method_7947() > this.method_5444()) {
            newItem.method_7939(this.method_5444());
        }
    }

    public boolean method_5442() {
        for (class_1799 itemstack : this.items) {
            if (itemstack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public void method_5448() {
        this.items.clear();
    }

    public void method_7683(class_1662 contents) {
        for (class_1799 itemstack : this.items) {
            contents.method_7400(itemstack);
        }
    }

    public boolean method_5443(class_1657 player) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public boolean method_5492(int slot, class_1799 itemStack, class_2350 direction) {
        return this.method_5437(slot, itemStack);
    }

    public boolean method_5437(int slot, class_1799 item) {
        if (slot == this.fuelSlot) {
            return this.isFuel(item);
        }
        return true;
    }

    @FunctionalInterface
    public static interface FuelValueSupplier {
        public int get();
    }
}

