/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.common.blockEntities;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3913;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import xyz.immortius.chunkbychunk.common.blockEntities.BaseFueledBlockEntity;
import xyz.immortius.chunkbychunk.common.menus.WorldForgeMenu;
import xyz.immortius.chunkbychunk.config.ChunkByChunkConfig;
import xyz.immortius.chunkbychunk.interop.ChunkByChunkConstants;

public class WorldForgeBlockEntity
extends BaseFueledBlockEntity {
    public static final int NUM_ITEM_SLOTS = 2;
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_RESULT = 1;
    public static final int NUM_DATA_ITEMS = 2;
    public static final int DATA_PROGRESS = 0;
    public static final int DATA_GOAL = 1;
    private static final int GROW_CRYSTAL_AT = 4;
    private static final Map<class_1792, BaseFueledBlockEntity.FuelValueSupplier> FUEL;
    private static final Map<class_6862<class_1792>, BaseFueledBlockEntity.FuelValueSupplier> FUEL_TAGS;
    private static final Map<class_1792, BaseFueledBlockEntity.FuelValueSupplier> CRYSTAL_COSTS;
    private static final class_1792 INITIAL_CRYSTAL;
    private static final Map<class_1792, class_1792> CRYSTAL_STEPS;
    private static final int[] SLOTS_FOR_UP;
    private static final int[] SLOTS_FOR_DOWN;
    private static final class_6862<class_1792> SOIL_FUEL_TAG;
    private static final class_6862<class_1792> STONE_FUEL_TAG;
    private static final class_6862<class_1792> STRONG_FUEL_TAG;
    private int progress;
    private int goal;
    protected final class_3913 dataAccess = new class_3913(){

        public int method_17390(int id) {
            switch (id) {
                case 0: {
                    return WorldForgeBlockEntity.this.progress;
                }
                case 1: {
                    return WorldForgeBlockEntity.this.goal;
                }
            }
            return 0;
        }

        public void method_17391(int id, int value) {
            switch (id) {
                case 0: {
                    WorldForgeBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    WorldForgeBlockEntity.this.goal = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };

    public WorldForgeBlockEntity(class_2338 pos, class_2680 state) {
        super(ChunkByChunkConstants.worldForgeEntity(), pos, state, 2, 0, FUEL, FUEL_TAGS);
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.chunkbychunk.worldforge");
    }

    protected class_1703 method_5465(int menuId, class_1661 inventory) {
        return new WorldForgeMenu(menuId, inventory, (class_1263)this, this.dataAccess);
    }

    public static boolean isWorldForgeFuel(class_1799 itemStack) {
        return FUEL.get(itemStack.method_7909()) != null || itemStack.method_31573(SOIL_FUEL_TAG) || itemStack.method_31573(STONE_FUEL_TAG);
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.progress = tag.method_10550("Progress");
    }

    @Override
    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("Progress", this.progress);
    }

    public static void serverTick(class_1937 level, class_2338 blockPos, class_2680 blockState, WorldForgeBlockEntity entity) {
        class_1799 outputItems;
        if (entity.getRemainingFuel() > 0) {
            int consumeAmount = entity.consumeFuel(ChunkByChunkConfig.get().getWorldForge().getProductionRate());
            entity.progress += consumeAmount;
        }
        class_1792 producingItem = (outputItems = entity.method_5438(1)).method_7960() ? INITIAL_CRYSTAL : outputItems.method_7909();
        if (outputItems.method_7947() == outputItems.method_7914()) {
            return;
        }
        boolean changed = entity.checkConsumeFuelItem();
        int itemCost = CRYSTAL_COSTS.get(producingItem).get();
        class_1792 nextItem = CRYSTAL_STEPS.get(producingItem);
        entity.goal = itemCost;
        if (entity.progress >= itemCost) {
            entity.progress -= itemCost;
            changed = true;
            if (outputItems.method_7960()) {
                entity.method_5447(1, producingItem.method_7854());
            } else if (outputItems.method_7947() == 3 && nextItem != null) {
                entity.method_5447(1, nextItem.method_7854());
                entity.goal = CRYSTAL_COSTS.get(nextItem).get();
            } else {
                outputItems.method_7933(1);
            }
        }
        if (changed) {
            WorldForgeBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)blockState);
        }
    }

    public int[] method_5494(class_2350 direction) {
        if (direction == class_2350.field_11036) {
            return SLOTS_FOR_UP;
        }
        return SLOTS_FOR_DOWN;
    }

    public boolean method_5493(int slot, class_1799 itemStack, class_2350 direction) {
        return slot == 1;
    }

    @Override
    public boolean method_5437(int slot, class_1799 item) {
        if (slot == 1) {
            return false;
        }
        return super.method_5437(slot, item);
    }

    static {
        INITIAL_CRYSTAL = ChunkByChunkConstants.worldFragmentItem();
        SLOTS_FOR_UP = new int[]{0};
        SLOTS_FOR_DOWN = new int[]{1};
        SOIL_FUEL_TAG = class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)new class_2960("chunkbychunk:weakworldforgefuel"));
        STONE_FUEL_TAG = class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)new class_2960("chunkbychunk:worldforgefuel"));
        STRONG_FUEL_TAG = class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)new class_2960("chunkbychunk:strongworldforgefuel"));
        ImmutableMap.Builder fuelBuilder = ImmutableMap.builder();
        fuelBuilder.put((Object)ChunkByChunkConstants.worldFragmentItem(), () -> ChunkByChunkConfig.get().getWorldForge().getFragmentFuelCost());
        fuelBuilder.put((Object)ChunkByChunkConstants.worldShardItem(), () -> ChunkByChunkConfig.get().getWorldForge().getFragmentFuelCost() * 4);
        fuelBuilder.put((Object)ChunkByChunkConstants.worldCrystalItem(), () -> ChunkByChunkConfig.get().getWorldForge().getFragmentFuelCost() * 16);
        FUEL = fuelBuilder.build();
        FUEL_TAGS = ImmutableMap.of(SOIL_FUEL_TAG, () -> ChunkByChunkConfig.get().getWorldForge().getSoilFuelValue(), STONE_FUEL_TAG, () -> ChunkByChunkConfig.get().getWorldForge().getStoneFuelValue(), STRONG_FUEL_TAG, () -> ChunkByChunkConfig.get().getWorldForge().getStrongFuelValue());
        CRYSTAL_COSTS = ImmutableMap.builder().put((Object)ChunkByChunkConstants.worldFragmentItem(), () -> ChunkByChunkConfig.get().getWorldForge().getFragmentFuelCost()).put((Object)ChunkByChunkConstants.worldShardItem(), () -> ChunkByChunkConfig.get().getWorldForge().getFragmentFuelCost() * 4).put((Object)ChunkByChunkConstants.worldCrystalItem(), () -> ChunkByChunkConfig.get().getWorldForge().getFragmentFuelCost() * 16).put((Object)ChunkByChunkConstants.worldCoreBlockItem(), () -> ChunkByChunkConfig.get().getWorldForge().getFragmentFuelCost() * 64).build();
        CRYSTAL_STEPS = ImmutableMap.builder().put((Object)ChunkByChunkConstants.worldFragmentItem(), (Object)ChunkByChunkConstants.worldShardItem()).put((Object)ChunkByChunkConstants.worldShardItem(), (Object)ChunkByChunkConstants.worldCrystalItem()).put((Object)ChunkByChunkConstants.worldCrystalItem(), (Object)ChunkByChunkConstants.worldCoreBlockItem()).build();
    }
}

