/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.common.blockEntities;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2919;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3609;
import net.minecraft.class_3620;
import net.minecraft.class_3913;
import net.minecraft.class_5321;
import xyz.immortius.chunkbychunk.common.blockEntities.BaseFueledBlockEntity;
import xyz.immortius.chunkbychunk.common.menus.WorldScannerMenu;
import xyz.immortius.chunkbychunk.common.util.ChunkUtil;
import xyz.immortius.chunkbychunk.common.util.SpiralIterator;
import xyz.immortius.chunkbychunk.common.world.SkyChunkGenerator;
import xyz.immortius.chunkbychunk.config.ChunkByChunkConfig;
import xyz.immortius.chunkbychunk.interop.CBCInteropMethods;
import xyz.immortius.chunkbychunk.interop.ChunkByChunkConstants;

public class WorldScannerBlockEntity
extends BaseFueledBlockEntity {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_FUEL = 1;
    public static final int NUM_ITEM_SLOTS = 2;
    public static final int DATA_MAP = 0;
    public static final int DATA_ENERGY = 1;
    public static final int DATA_MAX_ENERGY = 2;
    public static final int DATA_SCANNING_X = 3;
    public static final int DATA_SCANNING_Z = 4;
    public static final int NUM_DATA_ITEMS = 5;
    public static final int SCAN_CENTER = 15;
    public static final int SCAN_ZOOM = 4;
    public static final int NO_MAP = -1;
    private static final int TICKS_BETWEEN_REPLICATES = 11;
    private static final Map<class_1792, BaseFueledBlockEntity.FuelValueSupplier> FUEL;
    private static final int[] SLOTS_FOR_UP;
    private static final int[] SLOTS_FOR_SIDES;
    private static final int[] SLOTS_FOR_DOWN;
    private static final byte[] SCAN_COLOR_PALETTE;
    private static final Multimap<class_1792, class_2248> SCAN_ITEM_MAPPINGS;
    private static final int[] SCAN_COLOR_THRESHOLD;
    private int map = -1;
    private int scanCharge = 0;
    private final SpiralIterator scanIterator = new SpiralIterator();
    private int tickUntilReplicate = 0;
    protected final class_3913 dataAccess = new class_3913(){

        public int method_17390(int id) {
            return switch (id) {
                case 0 -> WorldScannerBlockEntity.this.map;
                case 1 -> WorldScannerBlockEntity.this.getRemainingFuel();
                case 2 -> WorldScannerBlockEntity.this.getChargedFuel();
                case 3 -> WorldScannerBlockEntity.this.scanIterator.getX();
                case 4 -> WorldScannerBlockEntity.this.scanIterator.getY();
                default -> 0;
            };
        }

        public void method_17391(int id, int value) {
            switch (id) {
                case 0: {
                    WorldScannerBlockEntity.this.map = value;
                }
            }
        }

        public int method_17389() {
            return 5;
        }
    };

    public WorldScannerBlockEntity(class_2338 pos, class_2680 state) {
        super(ChunkByChunkConstants.worldScannerEntity(), pos, state, 2, 1, FUEL, Collections.emptyMap());
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.chunkbychunk.worldscanner");
    }

    protected class_1703 method_5465(int menuId, class_1661 inventory) {
        return new WorldScannerMenu(menuId, inventory, (class_1263)this, this.dataAccess);
    }

    public static boolean isWorldScannerFuel(class_1799 itemStack) {
        return FUEL.getOrDefault(itemStack.method_7909(), () -> 0).get() > 0;
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.map = tag.method_10550("Map");
        this.scanIterator.load(tag.method_10562("ScanIterator"));
        this.scanCharge = tag.method_10550("ScanCharge");
    }

    @Override
    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("Map", this.map);
        tag.method_10566("ScanIterator", (class_2520)this.scanIterator.createTag());
        tag.method_10569("ScanCharge", this.scanCharge);
    }

    private boolean validTarget() {
        class_1799 targetItem = this.method_5438(0);
        class_1792 class_17922 = targetItem.method_7909();
        if (class_17922 instanceof class_1755) {
            class_1755 bucket = (class_1755)class_17922;
            return CBCInteropMethods.getBucketContents(bucket) instanceof class_3609;
        }
        if (class_1802.field_8777.equals(targetItem.method_7909())) {
            return true;
        }
        return targetItem.method_7909() instanceof class_1747 || SCAN_ITEM_MAPPINGS.keySet().contains(targetItem.method_7909());
    }

    public static void serverTick(class_1937 level, class_2338 blockPos, class_2680 blockState, WorldScannerBlockEntity entity) {
        class_3218 serverLevel = (class_3218)level;
        boolean changed = false;
        if (entity.scanIterator.getX() >= 0 && entity.validTarget()) {
            class_1799 targetItem = entity.method_5438(0);
            if (entity.getRemainingFuel() > 0) {
                int consumeAmount = entity.consumeFuel(ChunkByChunkConfig.get().getWorldScannerConfig().getFuelConsumedPerTick());
                entity.scanCharge += consumeAmount;
            }
            changed = entity.checkConsumeFuelItem();
            int chunkCost = ChunkByChunkConfig.get().getWorldScannerConfig().getFuelRequiredPerChunk();
            if (entity.scanCharge >= chunkCost) {
                int blockCount;
                if (entity.map == -1) {
                    entity.createMap();
                }
                class_1923 originChunkPos = new class_1923(blockPos);
                int chunkX = entity.scanIterator.getX() + originChunkPos.field_9181 - 15;
                int chunkZ = entity.scanIterator.getY() + originChunkPos.field_9180 - 15;
                class_3218 scanLevel = serverLevel.method_14178().method_12129() instanceof SkyChunkGenerator ? serverLevel.method_8503().method_3847(ChunkByChunkConstants.SKY_CHUNK_GENERATION_LEVEL) : serverLevel;
                class_2818 chunk = scanLevel.method_8497(chunkX, chunkZ);
                if (targetItem.method_7909().equals(class_1802.field_8777) || targetItem.method_7909().equals(class_1802.field_8828)) {
                    blockCount = class_2919.method_12662((int)chunkX, (int)chunkZ, (long)scanLevel.method_8412(), (long)987234911L).method_43048(10) == 0 ? 20000 : 0;
                } else {
                    HashSet<class_2248> scanForBlocks = new HashSet<class_2248>();
                    Collection mappings = SCAN_ITEM_MAPPINGS.get((Object)targetItem.method_7909());
                    if (!mappings.isEmpty()) {
                        scanForBlocks.addAll(mappings);
                    } else {
                        class_1792 class_17922 = targetItem.method_7909();
                        if (class_17922 instanceof class_1755) {
                            class_1755 bucket = (class_1755)class_17922;
                            scanForBlocks.add(CBCInteropMethods.getBucketContents(bucket).method_15785().method_15759().method_26204());
                        } else {
                            class_17922 = targetItem.method_7909();
                            if (class_17922 instanceof class_1747) {
                                class_1747 blockItem = (class_1747)class_17922;
                                scanForBlocks.add(blockItem.method_7711());
                            }
                        }
                    }
                    blockCount = ChunkUtil.countBlocks((class_2791)chunk, scanForBlocks);
                }
                byte color = class_3620.field_16009.method_38481(class_3620.class_6594.field_34760);
                for (int i = 0; i < SCAN_COLOR_THRESHOLD.length; ++i) {
                    color = SCAN_COLOR_PALETTE[i];
                    if (blockCount <= SCAN_COLOR_THRESHOLD[i]) break;
                }
                class_22 data = entity.method_10997().method_17891(class_1806.method_17440((int)entity.map));
                for (int innerX = 0; innerX < 4; ++innerX) {
                    for (int innerZ = 0; innerZ < 4; ++innerZ) {
                        int pixelX = entity.scanIterator.getX() * 4 + innerX;
                        int pixelY = entity.scanIterator.getY() * 4 + innerZ;
                        data.method_32370(pixelX, pixelY, color);
                    }
                }
                entity.scanIterator.next();
                entity.scanCharge -= chunkCost;
                changed = true;
            }
        }
        if (changed) {
            WorldScannerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)blockState);
        }
        if (changed || entity.tickUntilReplicate <= 0) {
            class_22 mapitemsaveddata = level.method_17891(class_1806.method_17440((int)entity.map));
            if (mapitemsaveddata != null) {
                for (class_3222 serverplayer : serverLevel.method_18456()) {
                    mapitemsaveddata.method_101((class_1657)serverplayer);
                    class_2596 packet = mapitemsaveddata.method_100(entity.map, (class_1657)serverplayer);
                    if (packet == null) continue;
                    serverplayer.field_13987.method_14364(packet);
                }
            }
            entity.tickUntilReplicate = 11;
        } else {
            --entity.tickUntilReplicate;
        }
    }

    private void createMap() {
        if (this.map == -1) {
            class_1923 pos = new class_1923(this.method_11016());
            class_22 data = class_22.method_32363((double)pos.method_8327(), (double)pos.method_8329(), (byte)2, (boolean)false, (boolean)false, (class_5321)this.field_11863.method_27983()).method_32361();
            this.map = this.field_11863.method_17889();
            this.field_11863.method_17890(class_1806.method_17440((int)this.map), data);
        }
    }

    public int[] method_5494(class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11036 -> SLOTS_FOR_UP;
            case class_2350.field_11033 -> SLOTS_FOR_DOWN;
            default -> SLOTS_FOR_SIDES;
        };
    }

    public boolean method_5493(int slot, class_1799 itemStack, class_2350 direction) {
        return slot == 0;
    }

    @Override
    public void method_5447(int slot, class_1799 newItem) {
        boolean targetUnchanged = true;
        if (slot == 0) {
            class_1799 itemStack = this.method_5438(slot);
            targetUnchanged = !newItem.method_7960() && newItem.method_7962(itemStack);
        }
        super.method_5447(slot, newItem);
        if (!targetUnchanged) {
            this.resetScan();
        }
    }

    private void resetScan() {
        class_22 data;
        if (this.map != -1 && (data = this.method_10997().method_17891(class_1806.method_17440((int)this.map))) != null) {
            for (int x = 0; x < 128; ++x) {
                for (int y = 0; y < 128; ++y) {
                    data.method_32370(x, y, class_3620.field_16008.method_38481(class_3620.class_6594.field_34760));
                }
            }
        }
        this.scanIterator.reset(15, 15);
        this.method_5431();
    }

    static {
        SLOTS_FOR_UP = new int[]{0};
        SLOTS_FOR_SIDES = new int[]{1};
        SLOTS_FOR_DOWN = new int[]{1};
        SCAN_COLOR_PALETTE = new byte[]{class_3620.field_16009.method_38481(class_3620.class_6594.field_34760), class_3620.field_16012.method_38481(class_3620.class_6594.field_34762), class_3620.field_16012.method_38481(class_3620.class_6594.field_34759), class_3620.field_16012.method_38481(class_3620.class_6594.field_34760), class_3620.field_16012.method_38481(class_3620.class_6594.field_34761), class_3620.field_16020.method_38481(class_3620.class_6594.field_34762), class_3620.field_16020.method_38481(class_3620.class_6594.field_34759), class_3620.field_16020.method_38481(class_3620.class_6594.field_34760), class_3620.field_16020.method_38481(class_3620.class_6594.field_34761), class_3620.field_16013.method_38481(class_3620.class_6594.field_34761), class_3620.field_16010.method_38481(class_3620.class_6594.field_34761), class_3620.field_15994.method_38481(class_3620.class_6594.field_34761), class_3620.field_16022.method_38481(class_3620.class_6594.field_34761)};
        SCAN_ITEM_MAPPINGS = ImmutableMultimap.builder().putAll((Object)class_1802.field_33402, (Object[])new class_2248[]{class_2246.field_10571, class_2246.field_29026, class_2246.field_23077, class_2246.field_33510}).putAll((Object)class_1802.field_33400, (Object[])new class_2248[]{class_2246.field_10212, class_2246.field_29027, class_2246.field_33508}).putAll((Object)class_1802.field_33401, (Object[])new class_2248[]{class_2246.field_27120, class_2246.field_29221, class_2246.field_33509}).putAll((Object)class_1802.field_8477, (Object[])new class_2248[]{class_2246.field_10442, class_2246.field_29029}).putAll((Object)class_1802.field_8687, (Object[])new class_2248[]{class_2246.field_10013, class_2246.field_29220}).putAll((Object)class_1802.field_8713, (Object[])new class_2248[]{class_2246.field_10418, class_2246.field_29219}).putAll((Object)class_1802.field_8759, (Object[])new class_2248[]{class_2246.field_10090, class_2246.field_29028}).putAll((Object)class_1802.field_8725, (Object[])new class_2248[]{class_2246.field_10080, class_2246.field_29030}).build();
        SCAN_COLOR_THRESHOLD = new int[]{0, 1, 8, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384};
        FUEL = ImmutableMap.builder().put((Object)ChunkByChunkConstants.worldFragmentItem(), () -> ChunkByChunkConfig.get().getWorldScannerConfig().getFuelPerFragment()).put((Object)ChunkByChunkConstants.worldShardItem(), () -> 4 * ChunkByChunkConfig.get().getWorldScannerConfig().getFuelPerFragment()).put((Object)ChunkByChunkConstants.worldCrystalItem(), () -> 16 * ChunkByChunkConfig.get().getWorldScannerConfig().getFuelPerFragment()).put((Object)ChunkByChunkConstants.worldCoreBlockItem(), () -> 64 * ChunkByChunkConfig.get().getWorldScannerConfig().getFuelPerFragment()).build();
    }
}

