/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2267;
import net.minecraft.class_2277;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import xyz.immortius.chunkbychunk.common.blocks.TriggeredSpawnRandomChunkBlock;
import xyz.immortius.chunkbychunk.common.world.SpawnChunkHelper;
import xyz.immortius.chunkbychunk.interop.ChunkByChunkConstants;

public class SpawnChunkCommand {
    private static final SimpleCommandExceptionType INVALID_POSITION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.chunkbychunk.spawnchunk.invalidPosition"));
    private static final SimpleCommandExceptionType INVALID_LEVEL = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.chunkbychunk.spawnchunk.invalidlevel"));
    private static final SimpleCommandExceptionType NON_EMPTY_CHUNK = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.chunkbychunk.spawnchunk.nonemptychunk"));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralCommandNode spawnChunkCommand = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"chunkbychunk:spawnChunk").requires(x -> x.method_9259(2))).then(class_2170.method_9244((String)"location", (ArgumentType)class_2277.method_9737()).executes(cmd -> SpawnChunkCommand.spawnChunk((class_2168)cmd.getSource(), ((class_2168)cmd.getSource()).method_9225(), class_2277.method_9734((CommandContext)cmd, (String)"location"), false))));
        LiteralCommandNode spawnRandomChunkCommand = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"chunkbychunk:spawnRandomChunk").requires(x -> x.method_9259(2))).then(class_2170.method_9244((String)"location", (ArgumentType)class_2277.method_9737()).executes(cmd -> SpawnChunkCommand.spawnChunk((class_2168)cmd.getSource(), ((class_2168)cmd.getSource()).method_9225(), class_2277.method_9734((CommandContext)cmd, (String)"location"), true))));
    }

    private static int spawnChunk(class_2168 stack, class_3218 level, class_2267 specifiedCoords, boolean random) throws CommandSyntaxException {
        class_243 vec3 = specifiedCoords.method_9708(stack);
        class_2338 pos = new class_2338(vec3.field_1352, (double)(level.method_31600() - 1), vec3.field_1350);
        class_1923 chunkPos = new class_1923(pos);
        if (!SpawnChunkHelper.isValidForChunkSpawn(level)) {
            throw INVALID_LEVEL.create();
        }
        if (!class_1937.method_25953((class_2338)pos)) {
            throw INVALID_POSITION.create();
        }
        if (!SpawnChunkHelper.isEmptyChunk((class_1936)level, chunkPos)) {
            throw NON_EMPTY_CHUNK.create();
        }
        if (random) {
            class_1923 sourceChunk = TriggeredSpawnRandomChunkBlock.getSourceChunk(pos);
            SpawnChunkHelper.spawnChunkBlocks(level, sourceChunk, chunkPos);
            level.method_8652(pos, ChunkByChunkConstants.triggeredSpawnRandomChunkBlock().method_9564(), 3);
        } else {
            SpawnChunkHelper.spawnChunkBlocks(level, chunkPos);
            level.method_8652(pos, ChunkByChunkConstants.triggeredSpawnChunkBlock().method_9564(), 3);
        }
        return 1;
    }
}

