/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.common.util;

import net.minecraft.class_2487;

public class SpiralIterator {
    private static final int[][] SCAN_DIRECTION_OFFSET = new int[][]{{1, 0}, {0, 1}, {-1, 0}, {0, -1}};
    private static final int[] SCAN_DISTANCE_INCREASE = new int[]{0, 1, 0, 1};
    private int currentX;
    private int currentY;
    private int direction = 0;
    private int lineLength = 1;
    private int lineRemaining = 1;

    public SpiralIterator() {
        this(0, 0);
    }

    public SpiralIterator(int startX, int startY) {
        this.currentX = startX;
        this.currentY = startY;
    }

    public int getX() {
        return this.currentX;
    }

    public int getY() {
        return this.currentY;
    }

    public void reset() {
        this.reset(0, 0);
    }

    public void reset(int x, int y) {
        this.currentX = x;
        this.currentY = y;
        this.direction = 0;
        this.lineLength = 1;
        this.lineRemaining = 1;
    }

    public void next() {
        this.currentX += SCAN_DIRECTION_OFFSET[this.direction][0];
        this.currentY += SCAN_DIRECTION_OFFSET[this.direction][1];
        --this.lineRemaining;
        if (this.lineRemaining == 0) {
            this.lineLength += SCAN_DISTANCE_INCREASE[this.direction];
            this.lineRemaining = this.lineLength;
            this.direction = (this.direction + 1) % SCAN_DIRECTION_OFFSET.length;
        }
    }

    public void load(class_2487 tag) {
        this.currentX = tag.method_10550("X");
        this.currentY = tag.method_10550("Y");
        this.direction = tag.method_10550("Direction");
        this.lineLength = tag.method_10550("LineLength");
        this.lineRemaining = tag.method_10550("LineRemaining");
    }

    public class_2487 createTag() {
        class_2487 tag = new class_2487();
        tag.method_10569("X", this.currentX);
        tag.method_10569("Y", this.currentY);
        tag.method_10569("Direction", this.direction);
        tag.method_10569("LineLength", this.lineLength);
        tag.method_10569("LineRemaining", this.lineRemaining);
        return tag;
    }
}

