/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.common.world;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2189;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2397;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2794;
import net.minecraft.class_3218;
import net.minecraft.class_5454;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.immortius.chunkbychunk.common.world.BaseSkyChunkGenerator;
import xyz.immortius.chunkbychunk.config.ChunkByChunkConfig;
import xyz.immortius.chunkbychunk.interop.CBCInteropMethods;
import xyz.immortius.chunkbychunk.interop.ChunkByChunkConstants;

public final class SpawnChunkHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Random random = new Random();

    private SpawnChunkHelper() {
    }

    public static boolean isEmptyChunk(class_1936 level, class_1923 chunkPos) {
        class_2338 bedrockCheckBlock = chunkPos.method_35231(8, level.method_31607(), 8);
        return !class_2246.field_9987.equals(level.method_8320(bedrockCheckBlock).method_26204());
    }

    public static boolean isValidForChunkSpawn(class_3218 level) {
        return level != null && level.method_14178().method_12129() instanceof BaseSkyChunkGenerator;
    }

    public static void spawnChunkBlocks(class_3218 targetLevel, class_1923 chunkPos) {
        SpawnChunkHelper.spawnChunkBlocks(targetLevel, chunkPos, chunkPos);
    }

    public static void spawnChunkBlocks(class_3218 targetLevel, class_1923 sourceChunkPos, class_1923 targetChunkPos) {
        class_2794 class_27942 = targetLevel.method_14178().method_12129();
        if (class_27942 instanceof BaseSkyChunkGenerator) {
            BaseSkyChunkGenerator generator = (BaseSkyChunkGenerator)class_27942;
            class_3218 sourceLevel = Objects.requireNonNull(targetLevel.method_8503()).method_3847(generator.getGenerationLevel());
            if (sourceLevel != null) {
                SpawnChunkHelper.spawnChunkBlocks(targetLevel, targetChunkPos, sourceLevel, sourceChunkPos);
            }
        } else {
            LOGGER.warn("Attempted to spawn a chunk in a non-SkyChunk world");
        }
    }

    public static void spawnChunkBlocks(class_3218 targetLevel, class_1923 targetChunkPos, class_3218 sourceLevel, class_1923 sourceChunkPos) {
        if (!SpawnChunkHelper.isValidForChunkSpawn(targetLevel)) {
            LOGGER.warn("Attempted to spawn a chunk in a non-SkyChunk world");
            return;
        }
        SpawnChunkHelper.copyBlocks(sourceLevel, sourceChunkPos, targetLevel, targetChunkPos);
        if (ChunkByChunkConfig.get().getGeneration().spawnNewChunkChest()) {
            SpawnChunkHelper.createNextSpawner(targetLevel, targetChunkPos);
        }
    }

    public static void spawnChunkEntities(class_3218 targetLevel, class_1923 sourceChunkPos, class_1923 targetChunkPos) {
        class_2794 class_27942 = targetLevel.method_14178().method_12129();
        if (class_27942 instanceof BaseSkyChunkGenerator) {
            BaseSkyChunkGenerator generator = (BaseSkyChunkGenerator)class_27942;
            class_3218 sourceLevel = Objects.requireNonNull(targetLevel.method_8503()).method_3847(generator.getGenerationLevel());
            if (sourceLevel != null) {
                SpawnChunkHelper.copyEntities(sourceLevel, sourceChunkPos, targetLevel, targetChunkPos);
            }
        } else {
            LOGGER.warn("Attempted to spawn a chunk in a non-SkyChunk world");
        }
    }

    private static void copyBlocks(class_3218 from, class_1923 sourceChunkPos, class_3218 to, class_1923 targetChunkPos) {
        class_2338.class_2339 sourceBlock = new class_2338.class_2339();
        class_2338.class_2339 targetBlock = new class_2338.class_2339();
        int xOffset = targetChunkPos.method_8326() - sourceChunkPos.method_8326();
        int zOffset = targetChunkPos.method_8328() - sourceChunkPos.method_8328();
        for (int z = targetChunkPos.method_8328(); z <= targetChunkPos.method_8329(); ++z) {
            for (int x = targetChunkPos.method_8326(); x <= targetChunkPos.method_8327(); ++x) {
                targetBlock.method_10103(x, to.method_31607(), z);
                to.method_8652((class_2338)targetBlock, class_2246.field_9987.method_9564(), 3);
            }
        }
        for (int y = to.method_31607() + 1; y < to.method_31600() - 1; ++y) {
            for (int z = sourceChunkPos.method_8328(); z <= sourceChunkPos.method_8329(); ++z) {
                for (int x = sourceChunkPos.method_8326(); x <= sourceChunkPos.method_8327(); ++x) {
                    sourceBlock.method_10103(x, y, z);
                    targetBlock.method_10103(x + xOffset, y, z + zOffset);
                    class_2248 existingBlock = to.method_8320((class_2338)targetBlock).method_26204();
                    if (!(existingBlock instanceof class_2397) && !(existingBlock instanceof class_2189) && !(existingBlock instanceof class_2404) && existingBlock != class_2246.field_9987 && existingBlock != class_2246.field_10445) continue;
                    to.method_8652((class_2338)targetBlock, from.method_8320((class_2338)sourceBlock), 3);
                    class_2586 fromBlockEntity = from.method_8321((class_2338)sourceBlock);
                    class_2586 toBlockEntity = to.method_8321((class_2338)targetBlock);
                    if (fromBlockEntity == null || toBlockEntity == null) continue;
                    toBlockEntity.method_11014(fromBlockEntity.method_38242());
                }
            }
        }
    }

    public static void copyEntities(class_3218 from, class_1923 sourceChunkPos, class_3218 to, class_1923 targetChunkPos) {
        List entities = from.method_8333((class_1297)null, new class_238((double)sourceChunkPos.method_8326(), (double)from.method_31607(), (double)sourceChunkPos.method_8328(), (double)sourceChunkPos.method_8327(), (double)from.method_31600(), (double)sourceChunkPos.method_8329()), x -> true);
        for (class_1297 e : entities) {
            class_243 pos;
            class_1297 movedEntity = CBCInteropMethods.changeDimension(e, to, new class_5454(pos = new class_243(e.method_23317() + (double)((targetChunkPos.field_9181 - sourceChunkPos.field_9181) * 16), e.method_23318(), e.method_23321() + (double)((targetChunkPos.field_9180 - sourceChunkPos.field_9180) * 16)), class_243.field_1353, e.field_6004, e.field_5982));
            if (movedEntity == null) continue;
            movedEntity.method_33574(pos);
        }
    }

    private static void createNextSpawner(class_3218 targetLevel, class_1923 chunkPos) {
        int maxPos;
        int minPos = Math.min(ChunkByChunkConfig.get().getGeneration().getMinChestSpawnDepth(), ChunkByChunkConfig.get().getGeneration().getMaxChestSpawnDepth());
        for (maxPos = Math.max(ChunkByChunkConfig.get().getGeneration().getMinChestSpawnDepth(), ChunkByChunkConfig.get().getGeneration().getMaxChestSpawnDepth()); maxPos > minPos && targetLevel.method_8320(new class_2338(chunkPos.method_33940(), maxPos, chunkPos.method_33942())).method_26204() instanceof class_2189; --maxPos) {
        }
        int yPos = minPos == maxPos ? minPos : random.nextInt(minPos, maxPos + 1);
        class_2338 blockPos = new class_2338(chunkPos.method_33940(), yPos, chunkPos.method_33942());
        if (ChunkByChunkConfig.get().getGeneration().useBedrockChest()) {
            targetLevel.method_8652(blockPos, ChunkByChunkConstants.bedrockChestBlock().method_9564(), 3);
        } else {
            targetLevel.method_8652(blockPos, class_2246.field_10034.method_9564(), 3);
        }
        class_2586 class_25862 = targetLevel.method_8321(blockPos);
        if (class_25862 instanceof class_2621) {
            class_2621 chestEntity = (class_2621)class_25862;
            chestEntity.method_5447(0, ChunkByChunkConfig.get().getGeneration().getChestContents().getItem(ChunkByChunkConfig.get().getGeneration().getChestQuantity()));
        }
    }
}

