/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.config.system;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.immortius.chunkbychunk.config.system.FieldMetadata;

public class EnumFieldMetadata
extends FieldMetadata<Enum> {
    private static final Logger LOGGER = LogManager.getLogger((String)"chunkbychunk");
    private static final Joiner VALUE_JOINER = Joiner.on((String)", ");
    private final Map<String, Enum<?>> lowercaseValueMap = new HashMap();
    private final Class<? extends Enum<?>> type;

    public EnumFieldMetadata(Field field, String name, String comment) {
        super(field, name, comment);
        ?[] enumValues;
        Preconditions.checkArgument((boolean)Enum.class.isAssignableFrom(field.getType()));
        this.type = field.getType();
        for (Object value : enumValues = field.getType().getEnumConstants()) {
            Enum enumValue = (Enum)value;
            this.lowercaseValueMap.put(enumValue.name().toLowerCase(Locale.ROOT), enumValue);
        }
    }

    public Class<? extends Enum<?>> enumType() {
        return this.type;
    }

    @Override
    public List<String> getComments() {
        List<String> values = this.lowercaseValueMap.values().stream().map(Enum::name).toList();
        return ImmutableList.builder().addAll(super.getComments()).add((Object)("Allowed Values: " + VALUE_JOINER.join(values))).build();
    }

    @Override
    public String serializeValue(Object object) {
        Enum value = (Enum)this.getValue(object);
        return "\"" + value.name() + "\"";
    }

    @Override
    public void deserializeValue(Object object, String value) {
        Enum<?> enumValue;
        String processedValue = value.toLowerCase(Locale.ROOT);
        if (processedValue.startsWith("\"") && processedValue.endsWith("\"")) {
            processedValue = processedValue.substring(1, value.length() - 1);
        }
        if ((enumValue = this.lowercaseValueMap.get(processedValue)) == null) {
            LOGGER.warn("Invalid value {} for config field {}", (Object)value, (Object)this.getName());
        } else {
            this.setValue(object, enumValue);
        }
    }
}

