/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.config.system;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.immortius.chunkbychunk.config.system.FieldMetadata;

public class IntFieldMetadata
extends FieldMetadata<Integer> {
    public static final Logger LOGGER = LogManager.getLogger((String)"chunkbychunk");
    private final int minValue;
    private final int maxValue;

    public IntFieldMetadata(Field field, String name, String comment, int minValue, int maxValue) {
        super(field, name, comment);
        Preconditions.checkArgument((boolean)Integer.TYPE.equals(field.getType()));
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    @Override
    public List<String> getComments() {
        return ImmutableList.builder().addAll(super.getComments()).add((Object)("Range: " + this.minValue + " ~ " + this.maxValue)).build();
    }

    @Override
    public String serializeValue(Object object) {
        return ((Integer)this.getValue(object)).toString();
    }

    @Override
    public void deserializeValue(Object object, String value) {
        try {
            int intValue = Integer.parseInt(value);
            if (intValue > this.maxValue) {
                LOGGER.warn("Invalid value {} for config field {} - greater than max value {}", (Object)value, (Object)this.getName(), (Object)this.maxValue);
            } else if (intValue < this.minValue) {
                LOGGER.warn("Invalid value {} for config field {} - less than min value {}", (Object)value, (Object)this.getName(), (Object)this.minValue);
            } else {
                this.setValue(object, intValue);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid value {} for config field {}", (Object)value, (Object)this.getName());
        }
    }
}

