/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.chunkbychunk.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Lifecycle;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_5218;
import net.minecraft.class_5268;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_6862;
import net.minecraft.class_7134;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.immortius.chunkbychunk.common.util.ChunkUtil;
import xyz.immortius.chunkbychunk.common.util.SpiralIterator;
import xyz.immortius.chunkbychunk.common.world.BaseSkyChunkGenerator;
import xyz.immortius.chunkbychunk.common.world.NetherChunkByChunkGenerator;
import xyz.immortius.chunkbychunk.common.world.SkyChunkGenerator;
import xyz.immortius.chunkbychunk.common.world.SpawnChunkHelper;
import xyz.immortius.chunkbychunk.config.ChunkByChunkConfig;
import xyz.immortius.chunkbychunk.config.system.ConfigSystem;
import xyz.immortius.chunkbychunk.fabric.mixins.DefrostedRegistry;
import xyz.immortius.chunkbychunk.interop.ChunkByChunkConstants;

public final class ServerEventHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"chunkbychunk");
    private static final int MAX_FIND_CHUNK_ATTEMPTS = 512;
    private static final String SERVERCONFIG = "serverconfig";
    private static final ConfigSystem configSystem = new ConfigSystem();
    private static final List<List<int[]>> CHUNK_SPAWN_OFFSETS = ImmutableList.builder().add((Object)ImmutableList.of((Object)new int[]{0, 0})).add((Object)ImmutableList.of((Object)new int[]{0, 0}, (Object)new int[]{1, 0})).add((Object)ImmutableList.of((Object)new int[]{0, 0}, (Object)new int[]{1, 0}, (Object)new int[]{0, 1})).add((Object)ImmutableList.of((Object)new int[]{0, 0}, (Object)new int[]{1, 0}, (Object)new int[]{0, 1}, (Object)new int[]{1, 1})).add((Object)ImmutableList.of((Object)new int[]{0, 0}, (Object)new int[]{1, 0}, (Object)new int[]{0, 1}, (Object)new int[]{-1, 0}, (Object)new int[]{0, -1})).add((Object)ImmutableList.of((Object)new int[]{0, 0}, (Object)new int[]{1, 0}, (Object)new int[]{0, 1}, (Object)new int[]{-1, 0}, (Object)new int[]{0, -1}, (Object)new int[]{1, 1})).add((Object)ImmutableList.of((Object)new int[]{0, 0}, (Object)new int[]{1, 0}, (Object)new int[]{0, 1}, (Object)new int[]{-1, 0}, (Object)new int[]{0, -1}, (Object)new int[]{1, 1}, (Object)new int[]{-1, -1})).add((Object)ImmutableList.of((Object)new int[]{0, 0}, (Object)new int[]{1, 0}, (Object)new int[]{0, 1}, (Object)new int[]{-1, 0}, (Object)new int[]{0, -1}, (Object)new int[]{1, 1}, (Object)new int[]{-1, -1}, (Object)new int[]{1, -1})).add((Object)ImmutableList.of((Object)new int[]{0, 0}, (Object)new int[]{1, 0}, (Object)new int[]{0, 1}, (Object)new int[]{-1, 0}, (Object)new int[]{0, -1}, (Object)new int[]{1, 1}, (Object)new int[]{-1, -1}, (Object)new int[]{1, -1}, (Object)new int[]{-1, 1})).build();

    private ServerEventHandler() {
    }

    public static void onServerStarting(MinecraftServer server) {
        configSystem.synchConfig(server.method_27050(class_5218.field_24188).resolve(SERVERCONFIG).resolve("chunkbychunk.toml"), ChunkByChunkConfig.get());
        if (ChunkByChunkConfig.get().getGeneration().isEnabled()) {
            ServerEventHandler.applyChunkByChunkWorldGeneration(server);
        }
    }

    private static void applyChunkByChunkWorldGeneration(MinecraftServer server) {
        class_5285 worldGenSettings = server.method_27728().method_28057();
        class_5363 overworldStem = (class_5363)worldGenSettings.method_28609().method_10223(class_1937.field_25179.method_29177());
        class_5363 generationStem = (class_5363)worldGenSettings.method_28609().method_10223(ChunkByChunkConstants.SKY_CHUNK_GENERATION_LEVEL.method_29177());
        class_2370 dimensions = (class_2370)worldGenSettings.method_28609();
        class_2378 dimensionTypeRegistry = server.method_30611().method_30530(class_2378.field_25095);
        ((DefrostedRegistry)dimensions).setFrozen(false);
        if (!(overworldStem.method_29571() instanceof SkyChunkGenerator)) {
            if (generationStem == null) {
                skychunkgeneration = class_5321.method_29179((class_5321)class_2378.field_25490, (class_2960)ChunkByChunkConstants.SKY_CHUNK_GENERATION_LEVEL.method_29177());
                generationStem = new class_5363(dimensionTypeRegistry.method_40290(class_7134.field_37666), overworldStem.method_29571());
                dimensions.method_10272(skychunkgeneration, (Object)generationStem, Lifecycle.stable());
            }
            class_5363 newOverworldStem = new class_5363(dimensionTypeRegistry.method_40290(class_7134.field_37666), (class_2794)new SkyChunkGenerator(overworldStem.method_29571(), ChunkByChunkConfig.get().getGeneration().sealWorld()));
            dimensions.method_31062(OptionalInt.empty(), class_5321.method_29179((class_5321)class_2378.field_25490, (class_2960)class_1937.field_25179.method_29177()), (Object)newOverworldStem, Lifecycle.stable());
        } else if (generationStem == null) {
            skychunkgeneration = class_5321.method_29179((class_5321)class_2378.field_25490, (class_2960)ChunkByChunkConstants.SKY_CHUNK_GENERATION_LEVEL.method_29177());
            generationStem = new class_5363(dimensionTypeRegistry.method_40290(class_7134.field_37666), ((BaseSkyChunkGenerator)overworldStem.method_29571()).getParent());
            dimensions.method_10272(skychunkgeneration, (Object)generationStem, Lifecycle.stable());
        }
        if (ChunkByChunkConfig.get().getGeneration().isSynchNether()) {
            class_5363 netherStem = (class_5363)worldGenSettings.method_28609().method_10223(class_1937.field_25180.method_29177());
            class_5363 netherGenerationStem = (class_5363)worldGenSettings.method_28609().method_10223(ChunkByChunkConstants.NETHER_CHUNK_GENERATION_LEVEL.method_29177());
            if (!(netherStem.method_29571() instanceof NetherChunkByChunkGenerator)) {
                if (netherGenerationStem == null) {
                    class_5321 netherchunkgeneration = class_5321.method_29179((class_5321)class_2378.field_25490, (class_2960)ChunkByChunkConstants.NETHER_CHUNK_GENERATION_LEVEL.method_29177());
                    netherGenerationStem = new class_5363(dimensionTypeRegistry.method_40290(class_7134.field_37667), netherStem.method_29571());
                    dimensions.method_10272(netherchunkgeneration, (Object)netherGenerationStem, Lifecycle.stable());
                }
                class_5363 newNetherStem = new class_5363(dimensionTypeRegistry.method_40290(class_7134.field_37667), (class_2794)new NetherChunkByChunkGenerator(netherStem.method_29571()));
                dimensions.method_31062(OptionalInt.empty(), class_5321.method_29179((class_5321)class_2378.field_25490, (class_2960)class_1937.field_25180.method_29177()), (Object)newNetherStem, Lifecycle.stable());
            } else if (netherGenerationStem == null) {
                class_5321 netherchunkgeneration = class_5321.method_29179((class_5321)class_2378.field_25490, (class_2960)ChunkByChunkConstants.NETHER_CHUNK_GENERATION_LEVEL.method_29177());
                netherGenerationStem = new class_5363(dimensionTypeRegistry.method_40290(class_7134.field_37667), ((BaseSkyChunkGenerator)netherStem.method_29571()).getParent());
                dimensions.method_10272(netherchunkgeneration, (Object)netherGenerationStem, Lifecycle.stable());
            }
        }
        ((DefrostedRegistry)dimensions).setFrozen(true);
    }

    public static void onServerStarted(MinecraftServer server) {
        if (ChunkByChunkConfig.get().getGeneration().isEnabled()) {
            ServerEventHandler.checkSpawnInitialChunks(server);
        }
    }

    private static void checkSpawnInitialChunks(MinecraftServer server) {
        class_2338 spawnPos;
        class_1923 chunkSpawnPos;
        class_3218 overworldLevel = server.method_3847(class_1937.field_25179);
        class_3218 generationLevel = server.method_3847(ChunkByChunkConstants.SKY_CHUNK_GENERATION_LEVEL);
        if (overworldLevel != null && generationLevel != null && SpawnChunkHelper.isEmptyChunk((class_1936)overworldLevel, chunkSpawnPos = new class_1923(spawnPos = generationLevel.method_43126()))) {
            ServerEventHandler.findAppropriateSpawnChunk(overworldLevel, generationLevel);
            ServerEventHandler.spawnInitialChunks(overworldLevel);
        }
    }

    private static void findAppropriateSpawnChunk(class_3218 overworldLevel, class_3218 generationLevel) {
        int attempts;
        class_6862 logsTag = class_3481.field_15475;
        class_6862 leavesTag = class_3481.field_15503;
        ImmutableSet redstone = ImmutableSet.of((Object)class_2246.field_10080, (Object)class_2246.field_29030);
        ImmutableSet copper = ImmutableSet.of((Object)class_2246.field_27120, (Object)class_2246.field_29221, (Object)class_2246.field_33509);
        class_1923 initialChunkPos = new class_1923(overworldLevel.method_43126());
        SpiralIterator iterator = new SpiralIterator(initialChunkPos.field_9181, initialChunkPos.field_9180);
        for (attempts = 0; attempts < 512; ++attempts) {
            class_2818 chunk = generationLevel.method_8497(iterator.getX(), iterator.getY());
            if (ChunkUtil.countBlocks((class_2791)chunk, (class_6862<class_2248>)logsTag) > 1 && ChunkUtil.countBlocks((class_2791)chunk, (class_6862<class_2248>)leavesTag) > 1 && ChunkUtil.countBlocks((class_2791)chunk, (Set<class_2248>)redstone) >= 36 && ChunkUtil.countBlocks((class_2791)chunk, (Set<class_2248>)copper) >= 36) {
                class_5268 levelData = (class_5268)overworldLevel.method_8401();
                levelData.method_187(new class_2338(chunk.method_12004().method_33940(), ChunkUtil.getSafeSpawnHeight((class_2791)chunk, chunk.method_12004().method_33940(), chunk.method_12004().method_33942()), chunk.method_12004().method_33942()), levelData.method_30656());
                break;
            }
            iterator.next();
        }
        if (attempts < 512) {
            LOGGER.info("Found appropriate spawn chunk in {} attempts", (Object)attempts);
        } else {
            LOGGER.info("No appropriate spawn chunk found :(");
        }
    }

    private static void spawnInitialChunks(class_3218 overworldLevel) {
        class_1923 centerChunkPos = new class_1923(overworldLevel.method_43126());
        List<int[]> chunkOffsets = CHUNK_SPAWN_OFFSETS.get(ChunkByChunkConfig.get().getGeneration().getInitialChunks() - 1);
        for (int[] offset : chunkOffsets) {
            class_1923 targetPos = new class_1923(centerChunkPos.field_9181 + offset[0], centerChunkPos.field_9180 + offset[1]);
            SpawnChunkHelper.spawnChunkBlocks(overworldLevel, targetPos);
            overworldLevel.method_8652(new class_2338(targetPos.method_33940(), overworldLevel.method_31600() - 1, targetPos.method_33942()), ChunkByChunkConstants.triggeredSpawnChunkBlock().method_9564(), 3);
        }
    }
}

