/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.items;

import java.util.List;
import java.util.UUID;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pavocado.exoticbirds.entity.Birds.EntityParrot;
import pavocado.exoticbirds.init.handlers.ConfigHandler;
import pavocado.exoticbirds.models.ModelShoulderMacaw;
import pavocado.exoticbirds.models.ModelShoulderParrot;

public class ItemShoulderParrot
extends ItemArmor {
    public int birdType = 0;
    private String birdName = "";
    private float birdHealth = 12.0f;

    public ItemShoulderParrot(ItemArmor.ArmorMaterial armormaterial, int renderID, EntityEquipmentSlot partID, int parrotType) {
        super(armormaterial, renderID, partID);
        this.field_77777_bU = 1;
        this.birdType = parrotType;
    }

    public String getArmorTexture(ItemStack itemstack, Entity entity, EntityEquipmentSlot slot, String layer) {
        switch (this.birdType) {
            case 0: {
                return ConfigHandler.detailed_parrots == false ? "exoticbirds:textures/entity/parrot/shoulder_parrot_scarlet.png" : "exoticbirds:textures/entity/parrot/macaw/shoulder_macaw_scarlet.png";
            }
            case 1: {
                return ConfigHandler.detailed_parrots == false ? "exoticbirds:textures/entity/parrot/shoulder_parrot_blueyellow.png" : "exoticbirds:textures/entity/parrot/macaw/shoulder_macaw_blueyellow.png";
            }
            case 2: {
                return ConfigHandler.detailed_parrots == false ? "exoticbirds:textures/entity/parrot/shoulder_parrot_military.png" : "exoticbirds:textures/entity/parrot/macaw/shoulder_macaw_military.png";
            }
            case 3: {
                return ConfigHandler.detailed_parrots == false ? "exoticbirds:textures/entity/parrot/shoulder_parrot_hyacinth.png" : "exoticbirds:textures/entity/parrot/macaw/shoulder_macaw_hyacinth.png";
            }
        }
        return ConfigHandler.detailed_parrots == false ? "exoticbirds:textures/entity/parrot/shoulder_parrot_scarlet.png" : "exoticbirds:textures/entity/parrot/macaw/shoulder_macaw_scarlet.png";
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, itemstack)) {
            return EnumActionResult.FAIL;
        }
        EntityParrot parrot = new EntityParrot(worldIn);
        if (itemstack.func_77978_p() != null && itemstack.func_77978_p().func_74764_b("parrotInfo")) {
            String s;
            NBTTagCompound nbt = (NBTTagCompound)itemstack.func_77978_p().func_74781_a("parrotInfo");
            this.birdHealth = nbt.func_74760_g("birdHealth");
            this.birdName = nbt.func_74779_i("birdName");
            if (nbt.func_150297_b("OwnerUUID", 8)) {
                s = nbt.func_74779_i("OwnerUUID");
            } else {
                String s1 = nbt.func_74779_i("Owner");
                s = PreYggdrasilConverter.func_187473_a((MinecraftServer)parrot.func_184102_h(), (String)s1);
            }
            if (!s.isEmpty()) {
                try {
                    parrot.setOwnerId(UUID.fromString(s));
                    parrot.setTamed(true);
                }
                catch (Throwable var4) {
                    parrot.setTamed(false);
                }
            }
            parrot.func_70873_a(nbt.func_74762_e("birdGrowingAge"));
        }
        parrot.setBirdType(this.birdType);
        BlockPos blockpos = pos.func_177972_a(facing);
        parrot.func_70012_b((double)blockpos.func_177958_n() + 0.5, blockpos.func_177956_o(), (double)blockpos.func_177952_p() + 0.5, 0.0f, 0.0f);
        if (this.birdName != "") {
            parrot.func_96094_a(this.birdName);
        }
        parrot.func_70606_j(this.birdHealth);
        worldIn.func_72838_d((Entity)parrot);
        if (!player.field_71075_bZ.field_75098_d) {
            --itemstack.field_77994_a;
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        RayTraceResult raytraceresult = this.func_77621_a(worldIn, playerIn, true);
        if (raytraceresult != null && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.func_178782_a();
            if (!(worldIn.func_180495_p(blockpos).func_177230_c() instanceof BlockLiquid)) {
                return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
            }
            if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos, raytraceresult.field_178784_b, itemstack)) {
                EntityParrot parrot = new EntityParrot(worldIn);
                if (itemstack.func_77978_p() != null && itemstack.func_77978_p().func_74764_b("parrotInfo")) {
                    String s;
                    NBTTagCompound nbt = (NBTTagCompound)itemstack.func_77978_p().func_74781_a("parrotInfo");
                    this.birdHealth = nbt.func_74760_g("birdHealth");
                    this.birdName = nbt.func_74779_i("birdName");
                    if (nbt.func_150297_b("OwnerUUID", 8)) {
                        s = nbt.func_74779_i("OwnerUUID");
                    } else {
                        String s1 = nbt.func_74779_i("Owner");
                        s = PreYggdrasilConverter.func_187473_a((MinecraftServer)parrot.func_184102_h(), (String)s1);
                    }
                    if (!s.isEmpty()) {
                        try {
                            parrot.setOwnerId(UUID.fromString(s));
                            parrot.setTamed(true);
                        }
                        catch (Throwable var4) {
                            parrot.setTamed(false);
                        }
                    }
                    parrot.func_70873_a(nbt.func_74762_e("birdGrowingAge"));
                }
                parrot.setBirdType(this.birdType);
                parrot.func_70012_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5, 0.0f, 0.0f);
                if (this.birdName != "") {
                    parrot.func_96094_a(this.birdName);
                }
                parrot.func_70606_j(this.birdHealth);
                worldIn.func_72838_d((Entity)parrot);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    --itemstack.field_77994_a;
                }
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }

    public Entity createEntity(World world, Entity entity, ItemStack itemstack) {
        EntityParrot parrot = new EntityParrot(world);
        if (itemstack.func_77978_p() != null && itemstack.func_77978_p().func_74764_b("parrotInfo")) {
            String s;
            NBTTagCompound nbt = (NBTTagCompound)itemstack.func_77978_p().func_74781_a("parrotInfo");
            this.birdHealth = nbt.func_74760_g("birdHealth");
            this.birdName = nbt.func_74779_i("birdName");
            if (nbt.func_150297_b("OwnerUUID", 8)) {
                s = nbt.func_74779_i("OwnerUUID");
            } else {
                String s1 = nbt.func_74779_i("Owner");
                s = PreYggdrasilConverter.func_187473_a((MinecraftServer)parrot.func_184102_h(), (String)s1);
            }
            if (!s.isEmpty()) {
                try {
                    parrot.setOwnerId(UUID.fromString(s));
                    parrot.setTamed(true);
                }
                catch (Throwable var4) {
                    parrot.setTamed(false);
                }
            }
            parrot.func_70873_a(nbt.func_74762_e("birdGrowingAge"));
        }
        parrot.setBirdType(this.birdType);
        parrot.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0f, 0.0f);
        parrot.field_70159_w = entity.field_70159_w;
        parrot.field_70181_x = entity.field_70181_x;
        parrot.field_70179_y = entity.field_70179_y;
        if (this.birdName != "") {
            parrot.func_96094_a(this.birdName);
        }
        parrot.func_70606_j(this.birdHealth);
        return parrot;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List tooltip, boolean advanced) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("parrotInfo")) {
            NBTTagCompound nbt = (NBTTagCompound)stack.func_77978_p().func_74781_a("parrotInfo");
            if (nbt.func_74779_i("birdName") != "") {
                tooltip.add(I18n.func_135052_a((String)"item.parrot.tooltip.name", (Object[])new Object[]{"\u00a7o" + nbt.func_74779_i("birdName")}));
            }
            if (nbt.func_150297_b("OwnerUUID", 8)) {
                tooltip.add("\u00a7o" + I18n.func_135052_a((String)"item.parrot.tooltip.tamed", (Object[])new Object[0]));
            }
        }
    }

    public EnumAction func_77661_b(ItemStack p_77661_1_) {
        return EnumAction.BLOCK;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack stack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        NBTTagCompound nbt;
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("parrotInfo") && (nbt = (NBTTagCompound)stack.func_77978_p().func_74781_a("parrotInfo")).func_74762_e("birdGrowingAge") != 0) {
            return ConfigHandler.detailed_parrots == false ? new ModelShoulderParrot(true) : new ModelShoulderMacaw(true);
        }
        return ConfigHandler.detailed_parrots == false ? new ModelShoulderParrot(false) : new ModelShoulderMacaw(false);
    }
}

