/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.render;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import pavocado.exoticbirds.entity.Birds.EntityDuck;
import pavocado.exoticbirds.models.ModelDuck;

public class RenderDuck
extends RenderLiving<EntityDuck> {
    private static final ResourceLocation maleTexture = new ResourceLocation("exoticbirds:textures/entity/duck/mallard_drake.png");
    private static final ResourceLocation femaleTexture = new ResourceLocation("exoticbirds:textures/entity/duck/mallard_duck.png");
    private static final ResourceLocation babyTexture = new ResourceLocation("exoticbirds:textures/entity/duck/mallard_duckling.png");

    public RenderDuck(RenderManager manager) {
        super(manager, (ModelBase)new ModelDuck(), 0.3f);
    }

    protected float handleRotationFloat(EntityDuck livingBase, float partialTicks) {
        float f1 = livingBase.wingRotation + (livingBase.startRotation - livingBase.wingRotation) * partialTicks;
        float f2 = livingBase.groundOffset + (livingBase.destPos - livingBase.groundOffset) * partialTicks;
        return (MathHelper.func_76126_a((float)f1) + 1.0f) * f2;
    }

    protected ResourceLocation getEntityTexture(EntityDuck entity) {
        if (entity.func_70631_g_()) {
            return babyTexture;
        }
        switch (entity.getBirdType()) {
            case 0: {
                return maleTexture;
            }
            case 1: {
                return femaleTexture;
            }
        }
        return maleTexture;
    }
}

