/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.render;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import pavocado.exoticbirds.entity.Birds.EntityParrot;
import pavocado.exoticbirds.models.ModelMacaw;

public class RenderMacaw
extends RenderLiving<EntityParrot> {
    private static final ResourceLocation birdTexture1 = new ResourceLocation("exoticbirds:textures/entity/parrot/macaw/macaw_scarlet.png");
    private static final ResourceLocation birdTexture2 = new ResourceLocation("exoticbirds:textures/entity/parrot/macaw/macaw_blueyellow.png");
    private static final ResourceLocation birdTexture3 = new ResourceLocation("exoticbirds:textures/entity/parrot/macaw/macaw_military.png");
    private static final ResourceLocation birdTexture4 = new ResourceLocation("exoticbirds:textures/entity/parrot/macaw/macaw_hyacinth.png");

    public RenderMacaw(RenderManager manager) {
        super(manager, (ModelBase)new ModelMacaw(), 0.3f);
    }

    protected float handleRotationFloat(EntityParrot livingBase, float partialTicks) {
        float f1 = livingBase.wingRotation + (livingBase.startRotation - livingBase.wingRotation) * partialTicks;
        float f2 = livingBase.groundOffset + (livingBase.destPos - livingBase.groundOffset) * partialTicks;
        return (MathHelper.func_76126_a((float)f1) + 1.0f) * f2;
    }

    protected ResourceLocation getEntityTexture(EntityParrot entity) {
        switch (entity.getBirdType()) {
            case 0: {
                return birdTexture1;
            }
            case 1: {
                return birdTexture2;
            }
            case 2: {
                return birdTexture3;
            }
            case 3: {
                return birdTexture4;
            }
        }
        return birdTexture1;
    }
}

