/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.render;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import pavocado.exoticbirds.entity.Birds.EntityOwl;
import pavocado.exoticbirds.models.ModelOwl;
import pavocado.exoticbirds.render.LayerOwlEyes;

public class RenderOwl
extends RenderLiving<EntityOwl> {
    private static final ResourceLocation birdTexture1 = new ResourceLocation("exoticbirds:textures/entity/owl/owl_longeared.png");
    private static final ResourceLocation birdTexture2 = new ResourceLocation("exoticbirds:textures/entity/owl/owl_snowy.png");
    private static final ResourceLocation birdTexture3 = new ResourceLocation("exoticbirds:textures/entity/owl/owl_barn.png");

    public RenderOwl(RenderManager manager) {
        super(manager, (ModelBase)new ModelOwl(), 0.3f);
        this.func_177094_a(new LayerOwlEyes(this));
    }

    protected float handleRotationFloat(EntityOwl livingBase, float partialTicks) {
        float f1 = livingBase.wingRotation + (livingBase.startRotation - livingBase.wingRotation) * partialTicks;
        float f2 = livingBase.groundOffset + (livingBase.destPos - livingBase.groundOffset) * partialTicks;
        return (MathHelper.func_76126_a((float)f1) + 1.0f) * f2;
    }

    protected ResourceLocation getEntityTexture(EntityOwl entity) {
        switch (entity.getBirdType()) {
            case 0: {
                return birdTexture1;
            }
            case 1: {
                return birdTexture2;
            }
            case 2: {
                return birdTexture3;
            }
        }
        return birdTexture1;
    }
}

