/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki;

import java.io.IOException;
import java.nio.file.Files;
import net.infstudio.goki.api.capability.CapabilityStat;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.api.stat.Stats;
import net.infstudio.goki.common.CommonProxy;
import net.infstudio.goki.common.StatsCommand;
import net.infstudio.goki.common.adapters.StatFix;
import net.infstudio.goki.common.config.ConfigManager;
import net.infstudio.goki.common.config.Configurable;
import net.infstudio.goki.common.config.GokiConfig;
import net.infstudio.goki.common.loot.conditions.LevelCondition;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="gokistats", useMetadata=true, updateJSON="https://infinitystudio.github.io/Updates/gokistats.json", acceptedMinecraftVersions="[1.12.2]")
public class GokiStats {
    @Mod.Instance(value="gokistats")
    public static GokiStats instance;
    @SidedProxy(clientSide="net.infstudio.goki.client.ClientProxy", serverSide="net.infstudio.goki.common.CommonProxy")
    public static CommonProxy proxy;
    public static final Logger log;
    private static final Class<?>[] loadClasses;

    @Mod.EventHandler
    public void construct(FMLConstructionEvent event) {
        try {
            for (Class<?> clz : loadClasses) {
                Class.forName(clz.getName());
            }
        }
        catch (ClassNotFoundException e) {
            log.warn("Cannot load classes, this may cause some issues", (Throwable)e);
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        instance = this;
        if (GokiConfig.version.equals("v2")) {
            try {
                Files.deleteIfExists(event.getModConfigurationDirectory().toPath().resolve("gokistats_v2.cfg"));
                Files.list(event.getModConfigurationDirectory().toPath().resolve("gokistats")).forEach(path -> {
                    try {
                        Files.deleteIfExists(path);
                    }
                    catch (IOException e) {
                        log.warn("Unable to remove v2 config files", (Throwable)e);
                    }
                });
                Files.deleteIfExists(event.getModConfigurationDirectory().toPath().resolve("gokistats"));
                net.minecraftforge.common.config.ConfigManager.sync((String)"gokistats", (Config.Type)Config.Type.INSTANCE);
            }
            catch (IOException e) {
                log.warn("Unable to remove v2 config files", (Throwable)e);
            }
        }
        LootConditionManager.func_186639_a((LootCondition.Serializer)new LevelCondition.Serializer(new ResourceLocation("gokistats", "min_level"), LevelCondition.class));
        CapabilityStat.register();
        new ConfigManager(event.getModConfigurationDirectory().toPath().resolve("gokistats"));
        StatBase.stats.forEach(Configurable::reloadConfig);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerHandlers();
        FMLCommonHandler.instance().getDataFixer().func_188255_a((IFixType)FixTypes.PLAYER, (IDataWalker)new StatFix());
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        StatBase.stats.forEach(Configurable::reloadConfig);
        ConfigManager.INSTANCE.reloadConfig();
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        ICommandManager command = server.func_71187_D();
        ServerCommandManager serverCommand = (ServerCommandManager)command;
        serverCommand.func_71560_a((ICommand)new StatsCommand());
    }

    static {
        log = LogManager.getLogger((String)"gokistats");
        loadClasses = new Class[]{Stats.class};
    }
}

