/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.api.stat;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.infstudio.goki.api.stat.Stat;
import net.infstudio.goki.common.config.Configurable;
import net.infstudio.goki.common.config.GokiConfig;
import net.infstudio.goki.common.config.stats.StatConfig;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class StatBase<T extends StatConfig>
extends IForgeRegistryEntry.Impl<Stat>
implements Stat,
Configurable<T> {
    public static final Map<String, StatBase> statKeyMap = new HashMap<String, StatBase>(16);
    public static final ObjectList<StatBase> stats = new ObjectArrayList(16);
    public static int totalStats = 0;
    public int imageID;
    public String key;
    public float costMultiplier = 1.0f;
    public float limitMultiplier = 1.0f;
    public float bonusMultiplier = 1.0f;
    public boolean enabled = true;
    private int limit;

    public StatBase(int imgId, String key, int limit) {
        this.imageID = imgId;
        this.limit = limit;
        this.key = key;
        stats.add((Object)this);
        ++totalStats;
        statKeyMap.put(key, this);
        this.setRegistryName("gokistats", this.getKey().toLowerCase());
    }

    protected static float getFinalBonus(float currentBonus) {
        return currentBonus * GokiConfig.globalModifiers.globalBonusMultiplier;
    }

    @Override
    public T createConfig() {
        return (T)new StatConfig();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void save() {
        ((StatConfig)this.getConfig()).bonusMultiplier = this.bonusMultiplier;
    }

    @Override
    public void reload() {
        this.bonusMultiplier = ((StatConfig)this.getConfig()).bonusMultiplier;
    }

    @Override
    public float getBonus(EntityPlayer player) {
        return this.getBonus(DataHelper.getPlayerStatLevel(player, this)) * this.bonusMultiplier;
    }

    @Override
    public float[] getDescriptionFormatArguments(EntityPlayer player) {
        return new float[]{DataHelper.trimDecimals(this.getBonus(player) * 100.0f, 1)};
    }

    @Override
    public int getCost(int level) {
        return (int)((Math.pow(level, 1.6) + 6.0 + (double)level) * (double)GokiConfig.globalModifiers.globalCostMultiplier);
    }

    @Override
    public boolean isEffectiveOn(Object ... obj) {
        if (obj[1] instanceof ItemStack && obj[2] instanceof BlockPos && obj[3] instanceof World) {
            ItemStack stack = (ItemStack)obj[1];
            BlockPos pos = (BlockPos)obj[2];
            World world = (World)obj[3];
            return ForgeHooks.isToolEffective((IBlockAccess)world, (BlockPos)pos, (ItemStack)stack);
        }
        return false;
    }

    @Override
    public int getLimit() {
        if (GokiConfig.globalModifiers.globalLimitMultiplier <= 0.0f) {
            return 127;
        }
        return (int)((float)this.limit * GokiConfig.globalModifiers.globalLimitMultiplier);
    }

    @Override
    public float getAppliedBonus(EntityPlayer player, Object object) {
        if (this.isEffectiveOn(object)) {
            return this.getBonus(player);
        }
        return 0.0f;
    }

    protected final int getPlayerStatLevel(EntityPlayer player) {
        return DataHelper.getPlayerStatLevel(player, this);
    }

    @Override
    public final boolean isEffectiveOn(ItemStack stack, BlockPos pos, World world) {
        if (ForgeHooks.isToolEffective((IBlockAccess)world, (BlockPos)pos, (ItemStack)stack)) {
            return true;
        }
        return this.isEffectiveOn(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedName() {
        return I18n.func_135052_a((String)(this.key + ".name"), (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedDescription(EntityPlayer player) {
        return I18n.func_135052_a((String)(this.key + ".des"), (Object[])new Object[]{Float.valueOf(this.getDescriptionFormatArguments(player)[0])});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StatBase)) {
            return false;
        }
        StatBase statBase = (StatBase)o;
        return Objects.equals(this.getKey(), statBase.getKey());
    }

    public int hashCode() {
        return Objects.hash(this.getKey());
    }

    public String toString() {
        return this.getKey();
    }
}

