/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.common.config.ConfigManager;
import net.infstudio.goki.common.config.Configurable;
import net.infstudio.goki.common.network.GokiPacketHandler;
import net.infstudio.goki.common.network.message.S2COpenGui;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandNotFoundException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class StatsCommand
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "gokistats";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "/gokistats";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new WrongUsageException("Invalid usage! Valid commands: /gokistats reload, /gokistats gui", new Object[0]);
        }
        if (args[0].equals("reload")) {
            StatBase.stats.forEach(Configurable::reloadConfig);
            ConfigManager.INSTANCE.reloadConfig();
            if (sender instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)sender;
                player.func_145747_a((ITextComponent)new TextComponentString("Reloaded gokistats configuration file."));
                return;
            } else {
                server.func_71244_g("Reloaded gokistats configuration file.");
            }
            return;
        } else {
            if (!args[0].equals("gui")) throw new CommandNotFoundException("No sub-command " + args[0], new Object[0]);
            EntityPlayerMP player = null;
            if (args.length == 1) {
                if (!(sender instanceof EntityPlayerMP)) throw new WrongUsageException("This command should be only used by player", new Object[0]);
                player = (EntityPlayerMP)sender;
            } else if (args.length == 2) {
                player = server.func_184103_al().func_152612_a(args[1]);
            }
            if (player == null) {
                throw new PlayerNotFoundException(args[1]);
            }
            GokiPacketHandler.CHANNEL.sendTo((IMessage)new S2COpenGui(0), player);
        }
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            String s = args[args.length - 1];
            if (args[0].isEmpty()) {
                return Arrays.asList("reload", "gui");
            }
            if (StatsCommand.func_71523_a((String)s, (String)"reload")) {
                return Collections.singletonList("reload");
            }
            if (StatsCommand.func_71523_a((String)s, (String)"gui")) {
                return Collections.singletonList("gui");
            }
        } else if (args.length == 2 && args[0].equals("gui")) {
            ArrayList list = Lists.newArrayList();
            for (GameProfile gameprofile : server.func_152357_F()) {
                if (server.func_184103_al().func_152596_g(gameprofile) || !StatsCommand.func_71523_a((String)args[1], (String)gameprofile.getName())) continue;
                list.add(gameprofile.getName());
            }
            return list;
        }
        return Arrays.asList("reload", "gui");
    }

    public String getCommandUsage(ICommandSender sender) {
        return null;
    }
}

