/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FilenameUtils;

public class ConfigManager {
    public static Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).setPrettyPrinting().create();
    public static ConfigManager INSTANCE;
    private final Path configPath;
    private final Map<String, Object> configMap = new HashMap<String, Object>();
    private final Map<String, Type> typeMap = new HashMap<String, Type>();

    public ConfigManager(Path configPath) {
        this.configPath = configPath;
        INSTANCE = this;
        if (!Files.isDirectory(configPath, new LinkOption[0]) || Files.notExists(configPath, new LinkOption[0])) {
            try {
                Files.createDirectories(configPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Map<String, Object> getConfigMap() {
        return this.configMap;
    }

    @Nullable
    public <T> T getConfig(String key) {
        return (T)this.configMap.get(key);
    }

    public <T> T getOrCreateConfig(String key, T instance) {
        if (!this.typeMap.containsKey(key)) {
            this.typeMap.put(key, instance.getClass());
        }
        if (this.configMap.containsKey(key)) {
            return this.getConfig(key);
        }
        this.createConfig(key, instance);
        return instance;
    }

    public void createConfig(String key, Object instance) {
        this.configMap.put(key, instance);
        this.typeMap.put(key, instance.getClass());
        this.saveConfig(key);
        System.out.println("Created config for " + key);
    }

    public void saveConfig(String key) {
        try {
            Files.write(this.configPath.resolve(key + ".json"), GSON.toJson(this.getConfig(key)).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadConfig(String key) {
        try {
            byte[] bytes = Files.readAllBytes(this.configPath.resolve(key + ".json"));
            this.configMap.put(key, GSON.fromJson(new String(bytes, 0, bytes.length, StandardCharsets.UTF_8), this.typeMap.get(key)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void registerConfig(String key, Type type) {
        this.typeMap.put(key, type);
    }

    public void reloadConfig(String key) {
        if (Files.notExists(this.configPath.resolve(key + ".json"), new LinkOption[0])) {
            this.saveConfig(key);
            return;
        }
        this.loadConfig(key);
        this.saveConfig(key);
    }

    public void reloadConfig() {
        try {
            Files.list(this.configPath).forEach(path -> {
                String key = FilenameUtils.getBaseName((String)path.getFileName().toString());
                if (this.configMap.containsKey(key)) {
                    this.reloadConfig(key);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean hasConfig(String key) {
        return Files.exists(this.configPath.resolve(key + ".json"), new LinkOption[0]);
    }
}

