/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.config;

import net.minecraftforge.common.config.Config;

@Config(modid="gokistats", name="gokistats_v2")
public class GokiConfig {
    @Config.Name(value="Configuration Version")
    public static String version = "v3";
    @Config.Name(value="Keybinding Enabled")
    @Config.Comment(value={"Should register gokistats keybinding (default Y)", "If set to false, player can only use /gokistats gui to open gui"})
    @Config.RequiresMcRestart
    public static boolean keyBindingEnabled = true;
    @Config.Name(value="Initiative stat synchronization")
    @Config.Comment(value={"Enables synchronizing all stat data in a period"})
    public static boolean initiativeSync = false;
    @Config.Name(value="Ticks for initiative sync")
    @Config.Comment(value={"Default 400 Ticks (20s)"})
    @Config.RangeInt(min=20)
    public static int syncTicks = 400;
    public static String[] treasureFinderLootTables = new String[]{"ore:dirt|gokistats:treasure_finder/dirt", "ore:treeLeaves|gokistats:treasure_finder/leaves", "minecraft:tallgrass|gokistats:treasure_finder/grass"};
    public static String[] miningMagicianLootTables = new String[]{"ore:oreIron|gokistats:mining_magician/ore", "ore:oreCoal|gokistats:mining_magician/ore", "ore:oreRedstone|gokistats:mining_magician/ore", "ore:oreDiamond|gokistats:mining_magician/ore", "ore:oreGold|gokistats:mining_magician/ore", "ore:oreEmerald|gokistats:mining_magician/ore"};
    @Config.Name(value="Global Modifiers")
    public static GlobalModifiers globalModifiers = new GlobalModifiers();
    @Config.Name(value="Support")
    public static Support support = new Support();

    public static class GlobalModifiers {
        @Config.Name(value="Cost Multiplier")
        @Config.Comment(value={"A flat multiplier on the cost to upgrade all stats."})
        public float globalCostMultiplier = 1.0f;
        @Config.Name(value="Limit Multiplier")
        @Config.Comment(value={"A flat multiplier on the amount limit of all stats."})
        public float globalLimitMultiplier = 2.5f;
        @Config.Name(value="Bonus Multiplier")
        @Config.Comment(value={"A flat multiplier on the bonus all stats gives."})
        public float globalBonusMultiplier = 1.0f;
        @Config.Name(value="Death Loss")
        @Config.Comment(value={"Lose stats on death?"})
        public boolean loseStatsOnDeath = false;
        @Config.Name(value="Death Loss Multiplier")
        @Config.Comment(value={"Multiplier of levels you will lose, between 0~1."})
        public float loseStatsMultiplier = 1.0f;
        @Config.Name(value="Maximum revertable skill amount")
        @Config.Comment(value={"An integer that constrains the max number of amount of the skill can be reverted. -1 for no limit. 0 to disable reverting."})
        public int globalMaxRevertLevel = -1;
        @Config.Name(value="Revert Factor")
        @Config.Comment(value={"How much percentage of exp will be given back to player if a player revert a skill."})
        public float globalRevertFactor = 0.8f;
    }

    public static class Support {
        @Config.Name(value="Reaper Limit")
        public float reaperLimit = 20.0f;
    }
}

