/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.handlers;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Random;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.api.stat.StatSpecial;
import net.infstudio.goki.api.stat.Stats;
import net.infstudio.goki.common.config.GokiConfig;
import net.infstudio.goki.common.init.GokiSounds;
import net.infstudio.goki.common.loot.LootConfigDeserializer;
import net.infstudio.goki.common.network.GokiPacketHandler;
import net.infstudio.goki.common.network.message.S2CSyncAll;
import net.infstudio.goki.common.stat.tool.IDMDTuple;
import net.infstudio.goki.common.stat.tool.StatMiningMagician;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@GameRegistry.ObjectHolder(value="gokistats")
public class CommonHandler {
    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public void harvestBlock(BlockEvent.HarvestDropsEvent event) {
        EntityPlayer player = event.getHarvester();
        Block block = event.getState().func_177230_c();
        if (player == null) {
            return;
        }
        if (DataHelper.getPlayerStatLevel(player, Stats.TREASURE_FINDER) > 0) {
            LootConfigDeserializer.TREASURE_FINDER.getLocationForBlock(event.getState()).map(arg_0 -> ((LootTableManager)event.getWorld().func_184146_ak()).func_186521_a(arg_0)).ifPresent(lootTable -> lootTable.func_186462_a(event.getWorld().field_73012_v, new LootContext(1.0f, (WorldServer)event.getWorld(), event.getWorld().func_184146_ak(), null, null, null)));
            boolean treasureFound = false;
            Random random = player.func_70681_au();
            List<ItemStack> items = Stats.TREASURE_FINDER.getApplicableItemStackList(block, block.func_176201_c(event.getState()), DataHelper.getPlayerStatLevel(player, Stats.TREASURE_FINDER));
            IntList chances = Stats.TREASURE_FINDER.getApplicableChanceList(block, block.func_176201_c(event.getState()), DataHelper.getPlayerStatLevel(player, Stats.TREASURE_FINDER));
            for (int i = 0; i < items.size(); ++i) {
                int roll = random.nextInt(10000);
                if (roll > chances.getInt(i)) continue;
                if (items.get(i) != null) {
                    event.getDrops().add(items.get(i));
                    treasureFound = true;
                    continue;
                }
                System.out.println("Tried to add an item from Treasure Finder, but it failed!");
            }
            if (treasureFound) {
                player.field_70170_p.func_184133_a(player, event.getPos(), GokiSounds.TREASURE, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
        if (DataHelper.getPlayerStatLevel(player, Stats.MINING_MAGICIAN) > 0) {
            boolean magicHappened = false;
            IDMDTuple mme = new IDMDTuple(block, block.func_176201_c(event.getState()));
            if (Stats.MINING_MAGICIAN.isEffectiveOn(mme)) {
                block1: for (int i = 0; i < event.getDrops().size(); ++i) {
                    IDMDTuple entry;
                    if (!(player.func_70681_au().nextDouble() * 100.0 <= (double)Stats.MINING_MAGICIAN.getBonus(player))) continue;
                    ItemStack item = (ItemStack)event.getDrops().get(i);
                    if (item.func_77973_b() instanceof ItemBlock && ItemBlock.func_150891_b((Item)item.func_77973_b()) == Block.func_149682_b((Block)block)) {
                        if (item.func_77952_i() != block.func_176201_c(event.getState())) continue;
                        int randomEntry = player.func_70681_au().nextInt(StatMiningMagician.blockEntries.size());
                        entry = StatMiningMagician.blockEntries.get(randomEntry);
                        ItemStack stack = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entry.id)), 1, entry.metadata);
                        stack.func_190920_e(((ItemStack)event.getDrops().get(i)).func_190916_E());
                        event.getDrops().add(stack);
                        magicHappened = true;
                        continue;
                    }
                    for (int j = 0; j < StatMiningMagician.itemEntries.size(); ++j) {
                        entry = StatMiningMagician.itemEntries.get(j);
                        if (!item.func_77973_b().getRegistryName().toString().equals(entry.id) || item.func_77952_i() != entry.metadata) continue;
                        int randomEntry = player.func_70681_au().nextInt(StatMiningMagician.itemEntries.size());
                        IDMDTuple chosenEntry = StatMiningMagician.itemEntries.get(randomEntry);
                        ItemStack stack = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(chosenEntry.id)), 1, chosenEntry.metadata);
                        stack.func_190920_e(((ItemStack)event.getDrops().get(i)).func_190916_E());
                        event.getDrops().add(stack);
                        magicHappened = true;
                        continue block1;
                    }
                }
                if (magicHappened) {
                    player.field_70170_p.func_184133_a(player, event.getPos(), GokiSounds.MAGICIAN, SoundCategory.BLOCKS, 0.3f, 1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public void playerFall(LivingFallEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            int featherFallLevel = DataHelper.getPlayerStatLevel(player, Stats.STAT_FEATHER_FALL);
            if ((double)event.getDistance() < 3.0 + (double)featherFallLevel * 0.1) {
                event.setDistance(0.0f);
            }
        }
    }

    @SubscribeEvent
    public void playerJoinWorld(PlayerEvent.PlayerChangedDimensionEvent event) {
        DataHelper.resetMaxHealth(event.player);
    }

    @SubscribeEvent
    public void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer player = event.player;
        if (!player.field_70170_p.field_72995_K) {
            if (GokiConfig.globalModifiers.loseStatsOnDeath) {
                for (int stat = 0; stat < StatBase.totalStats; ++stat) {
                    DataHelper.multiplyPlayerStatLevel(player, (StatBase)StatBase.stats.get(stat), level -> level - (int)(GokiConfig.globalModifiers.loseStatsMultiplier * (float)level));
                }
            }
            GokiPacketHandler.CHANNEL.sendTo((IMessage)new S2CSyncAll(player), (EntityPlayerMP)player);
            player.func_70691_i(player.func_110138_aP());
        }
    }

    @SubscribeEvent
    public void playerBreakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack heldItem = event.getEntityPlayer().func_184614_ca();
        EntityPlayer player = event.getEntityPlayer();
        float multiplier = 1.0f;
        if (Stats.MINING.isEffectiveOn(heldItem, event.getPos(), player.field_70170_p)) {
            multiplier += Stats.MINING.getBonus(player);
        }
        if (Stats.DIGGING.isEffectiveOn(heldItem, event.getPos(), player.field_70170_p)) {
            multiplier += Stats.DIGGING.getBonus(player);
        }
        if (Stats.CHOPPING.isEffectiveOn(heldItem, event.getPos(), player.field_70170_p)) {
            multiplier += Stats.CHOPPING.getBonus(player);
        }
        if (Stats.TRIMMING.isEffectiveOn(heldItem, event.getPos(), player.field_70170_p)) {
            multiplier += Stats.TRIMMING.getBonus(player);
        }
        event.setNewSpeed(event.getOriginalSpeed() * multiplier);
    }

    @SubscribeEvent
    public void playerJump(LivingEvent.LivingJumpEvent event) {
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && (player = (EntityPlayer)event.getEntityLiving()).func_70051_ag()) {
            player.field_70181_x *= (double)(1.0f + Stats.LEAPER_V.getBonus(player));
            player.field_70159_w *= (double)(1.0f + Stats.LEAPER_H.getBonus(player));
            player.field_70179_y *= (double)(1.0f + Stats.LEAPER_H.getBonus(player));
        }
    }

    @SubscribeEvent
    public void entityKnockback(LivingKnockBackEvent event) {
        Entity attacker;
        if (event.getOriginalAttacker() == null && event.getAttacker() == null) {
            return;
        }
        Entity entity = attacker = event.getOriginalAttacker() != null ? event.getOriginalAttacker() : event.getAttacker();
        if (attacker.func_184216_O().contains("knockback")) {
            attacker.func_184197_b("knockback");
            event.setStrength(event.getStrength() * 2.0f);
            attacker.func_145747_a((ITextComponent)new TextComponentTranslation("grpg_Roll.knockback", new Object[0]));
        }
    }

    @SubscribeEvent
    public void entityHurt(LivingHurtEvent event) {
        Entity src;
        DamageSource source = event.getSource();
        EntityLivingBase victim = event.getEntityLiving();
        if (victim instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)victim;
            if (!source.func_76347_k() && !source.func_151517_h() && player.func_130014_f_().field_73012_v.nextFloat() >= 1.0f - Stats.ROLL.getBonus(player)) {
                event.setCanceled(true);
                player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 20, 2));
                victim.func_184211_a("knockback");
                player.func_145747_a((ITextComponent)new TextComponentTranslation("grpg_Roll.message", new Object[0]));
                return;
            }
            float damageMultiplier = 1.0f - (Stats.PROTECTION.getAppliedBonus(player, source) + Stats.TOUGH_SKIN.getAppliedBonus(player, source) + Stats.STAT_FEATHER_FALL.getAppliedBonus(player, source) + Stats.TEMPERING.getAppliedBonus(player, source));
            event.setAmount(event.getAmount() * damageMultiplier);
        }
        if ((src = source.func_76346_g()) instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)src;
            ItemStack heldItem = player.func_184614_ca();
            float damage = event.getAmount();
            float bonus = 0.0f;
            if (!heldItem.func_190926_b()) {
                if (Stats.SWORDSMANSHIP.isItemSupported(heldItem)) {
                    bonus = Math.round(damage * Stats.SWORDSMANSHIP.getAppliedBonus(player, heldItem));
                } else if (Stats.BOWMANSHIP.isItemSupported(heldItem)) {
                    bonus = Math.round(damage * Stats.BOWMANSHIP.getAppliedBonus(player, heldItem));
                }
            } else {
                bonus = Math.round(damage + Stats.PUGILISM.getBonus(player));
            }
            event.setAmount(bonus + damage);
            if (Stats.REAPER.isEffectiveOn(victim)) {
                float reap = Stats.REAPER.getBonus(player);
                float reapBonus = 0.0f;
                if (Stats.STEALTH.isEffectiveOn(player)) {
                    reapBonus = reap * ((StatSpecial)((Object)Stats.STEALTH)).getSecondaryBonus(player) / 100.0f;
                }
                float reapChance = reap + reapBonus;
                if (player.func_70681_au().nextFloat() <= reapChance) {
                    player.func_71047_c((Entity)victim);
                    player.field_70170_p.func_184133_a(player, event.getEntity().func_180425_c(), GokiSounds.REAPER, SoundCategory.MASTER, 1.0f, 1.0f);
                    event.setAmount(100000.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public void configChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("gokistats")) {
            ConfigManager.sync((String)"gokistats", (Config.Type)Config.Type.INSTANCE);
            LootConfigDeserializer.reloadAll();
        }
    }
}

