/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.loot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.infstudio.goki.common.config.GokiConfig;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class LootConfigDeserializer {
    public static final LootConfigDeserializer TREASURE_FINDER = new LootConfigDeserializer(GokiConfig.treasureFinderLootTables);
    public static final LootConfigDeserializer MINING_MAGICIAN = new LootConfigDeserializer(GokiConfig.miningMagicianLootTables);
    public List<String> configValue;
    public List<Function<IBlockState, ResourceLocation>> lootFunctions = new ArrayList<Function<IBlockState, ResourceLocation>>();

    public LootConfigDeserializer(String[] configValue) {
        this.configValue = Arrays.asList(configValue);
    }

    public Optional<ResourceLocation> getLocationForBlock(IBlockState state) {
        return this.lootFunctions.stream().map(it -> (ResourceLocation)it.apply(state)).filter(Objects::nonNull).findFirst();
    }

    public void reload() {
        for (String s : this.configValue) {
            if (!s.contains("|")) {
                throw new IllegalArgumentException(s + " does not contain | split character!");
            }
            String[] split = s.split("\\|");
            ResourceLocation blockLocation = new ResourceLocation(split[0]);
            ResourceLocation lootLocation = new ResourceLocation(split[1]);
            this.lootFunctions.add(state -> {
                if (blockLocation.func_110624_b().equals("ore")) {
                    if (Arrays.stream(OreDictionary.getOreIDs((ItemStack)new ItemStack(state.func_177230_c()))).mapToObj(OreDictionary::getOreName).anyMatch(blockLocation.func_110623_a()::equals)) {
                        return lootLocation;
                    }
                } else if (state.func_177230_c().getRegistryName().equals((Object)blockLocation)) {
                    return lootLocation;
                }
                return null;
            });
        }
    }

    public static void reloadAll() {
        TREASURE_FINDER.reload();
        MINING_MAGICIAN.reload();
    }
}

