/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.network.handler;

import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.common.config.GokiConfig;
import net.infstudio.goki.common.network.GokiPacketHandler;
import net.infstudio.goki.common.network.message.C2SRequestStatSync;
import net.infstudio.goki.common.network.message.C2SStatSync;
import net.infstudio.goki.common.network.message.MessageXPSync;
import net.infstudio.goki.common.network.message.S2CStatSync;
import net.infstudio.goki.common.network.message.S2CSyncAll;
import net.infstudio.goki.common.stat.StatMaxHealth;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSyncHandler {

    public static class RequestSync
    implements IMessageHandler<C2SRequestStatSync, S2CSyncAll> {
        public S2CSyncAll onMessage(C2SRequestStatSync message, MessageContext ctx) {
            return new S2CSyncAll((EntityPlayer)ctx.getServerHandler().field_147369_b);
        }
    }

    public static class XP
    implements IMessageHandler<MessageXPSync, IMessage> {
        public IMessage onMessage(MessageXPSync message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> DataHelper.setPlayersExpTo((EntityPlayer)player, message.experience));
            return null;
        }
    }

    public static class Stat
    implements IMessageHandler<C2SStatSync, IMessage> {
        public IMessage onMessage(C2SStatSync message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            StatBase stat = (StatBase)StatBase.stats.get(message.stat);
            if (!stat.enabled) {
                return null;
            }
            int level = DataHelper.getPlayerStatLevel((EntityPlayer)player, stat);
            if (message.amount < 0 && level == 0) {
                return null;
            }
            if (level + message.amount > stat.getLimit()) {
                return null;
            }
            int cost = stat.getCost(level + message.amount - 1);
            int currentXP = DataHelper.getXPTotal(player.field_71068_ca, player.field_71106_cc);
            player.func_71121_q().func_152344_a(() -> {
                int reverted = DataHelper.getPlayerRevertStatLevel((EntityPlayer)player, stat);
                if (GokiConfig.globalModifiers.globalMaxRevertLevel < (reverted = Math.max(reverted - message.amount, 0)) && GokiConfig.globalModifiers.globalMaxRevertLevel != -1) {
                    return;
                }
                if (message.amount <= 0) {
                    DataHelper.setPlayerRevertStatLevel((EntityPlayer)player, stat, reverted);
                }
                if (currentXP >= cost) {
                    DataHelper.setPlayerStatLevel((EntityPlayer)player, stat, level + message.amount);
                    GokiPacketHandler.CHANNEL.sendTo((IMessage)new S2CStatSync(StatBase.stats.indexOf((Object)stat), level + message.amount, reverted), player);
                    if (stat instanceof StatMaxHealth) {
                        DataHelper.addMaxHealth((EntityPlayer)player, (int)stat.getBonus(level) + message.amount);
                    }
                    if (message.amount <= 0) {
                        DataHelper.setPlayersExpTo((EntityPlayer)player, currentXP + (int)((float)stat.getCost(level + message.amount + 1) * GokiConfig.globalModifiers.globalRevertFactor));
                    } else {
                        DataHelper.setPlayersExpTo((EntityPlayer)player, currentXP - cost);
                    }
                } else {
                    if (message.amount <= 0) {
                        if (stat instanceof StatMaxHealth) {
                            DataHelper.addMaxHealth((EntityPlayer)player, (int)stat.getBonus(level) + message.amount);
                        }
                        DataHelper.setPlayersExpTo((EntityPlayer)player, currentXP + (int)((float)stat.getCost(level + message.amount + 1) * GokiConfig.globalModifiers.globalRevertFactor));
                    }
                    GokiPacketHandler.CHANNEL.sendTo((IMessage)new S2CStatSync(StatBase.stats.indexOf((Object)stat), level, reverted), player);
                }
            });
            return null;
        }
    }
}

