/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.stat.tool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.common.config.stats.MiningMagicianConfig;
import net.infstudio.goki.common.stat.tool.IDMDTuple;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;

public class StatMiningMagician
extends StatBase<MiningMagicianConfig> {
    public static List<IDMDTuple> blockEntries = new ArrayList<IDMDTuple>();
    public static List<IDMDTuple> itemEntries = new ArrayList<IDMDTuple>();
    private static IDMDTuple[] defaultBlockEntries = new IDMDTuple[]{new IDMDTuple(Blocks.field_150365_q, 0), new IDMDTuple(Blocks.field_150482_ag, 0), new IDMDTuple(Blocks.field_150412_bA, 0), new IDMDTuple(Blocks.field_150352_o, 0), new IDMDTuple(Blocks.field_150366_p, 0), new IDMDTuple(Blocks.field_150369_x, 0), new IDMDTuple(Blocks.field_150449_bY, 0), new IDMDTuple(Blocks.field_150450_ax, 0)};
    private static IDMDTuple[] defaultItemEntries = new IDMDTuple[]{new IDMDTuple(Items.field_151044_h, 0), new IDMDTuple(Items.field_151045_i, 0), new IDMDTuple(Items.field_151166_bC, 0), new IDMDTuple(Items.field_151043_k, 0), new IDMDTuple(Items.field_151042_j, 0), new IDMDTuple(Items.field_151100_aR, 4), new IDMDTuple(Items.field_151128_bU, 0), new IDMDTuple(Items.field_151137_ax, 0)};

    public StatMiningMagician(int id, String key, int limit) {
        super(id, key, limit);
        Collections.addAll(blockEntries, defaultBlockEntries);
        Collections.addAll(itemEntries, defaultItemEntries);
    }

    @Override
    public void save() {
        super.save();
        ((MiningMagicianConfig)this.getConfig()).blockEntries.clear();
        ((MiningMagicianConfig)this.getConfig()).blockEntries.addAll(blockEntries);
        ((MiningMagicianConfig)this.getConfig()).itemEntries.clear();
        ((MiningMagicianConfig)this.getConfig()).itemEntries.addAll(itemEntries);
    }

    @Override
    public MiningMagicianConfig createConfig() {
        MiningMagicianConfig config = new MiningMagicianConfig();
        Collections.addAll(config.blockEntries, defaultBlockEntries);
        Collections.addAll(config.itemEntries, defaultItemEntries);
        return config;
    }

    @Override
    public void reload() {
        super.reload();
        blockEntries.clear();
        itemEntries.clear();
        blockEntries.addAll(((MiningMagicianConfig)this.getConfig()).blockEntries);
        itemEntries.addAll(((MiningMagicianConfig)this.getConfig()).itemEntries);
    }

    @Override
    public float getBonus(int level) {
        return StatMiningMagician.getFinalBonus((float)level * 0.3f);
    }

    @Override
    public float[] getDescriptionFormatArguments(EntityPlayer player) {
        return new float[]{DataHelper.trimDecimals(this.getBonus(player), 1)};
    }

    @Override
    public boolean isEffectiveOn(Object ... obj) {
        if (obj[0] instanceof IDMDTuple) {
            IDMDTuple idmd = (IDMDTuple)obj[0];
            for (IDMDTuple entry : blockEntries) {
                if (!idmd.equals(entry)) continue;
                return true;
            }
            for (IDMDTuple entry : itemEntries) {
                if (!idmd.equals(entry)) continue;
                return true;
            }
        }
        return false;
    }
}

